/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.document.util;

import com.ygsoft.abc.service.document.function.impl.Word2003TransferFunction;
import com.ygsoft.abc.service.document.function.impl.Word2007TransferFunction;
import com.ygsoft.abc.service.document.type.FontType;
import com.ygsoft.abc.service.document.type.WordType;
import com.ygsoft.abc.service.document.util.PdfUtil;
import com.ygsoft.abc.service.document.vo.PageMarginVO;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.ecp.service.exception.EcpCheckException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StreamUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;

public final class WordUtil {
    private static final BigDecimal INCH_UNIT = new BigDecimal("0.393700787402");
    private static final Pattern BODY_TAG_PATTERN = Pattern.compile("<body([\\s\\S]*?)>");
    private static final String REGEX_FONT_FAMILY = "(font-family)([\\s\\S]*?)(;)";
    private static final String STYLE_TAG_REGEX = "<style([\\s\\S]*?)>";
    private static final Pattern STYLE_TAG_PATTERN = Pattern.compile("<style([\\s\\S]*?)>");
    private static final String IMG_PLACEHOLDER_REGEX = "\\#\\{.*?\\}";
    private static final Pattern IMG_PLACEHOLDER_PATTERN = Pattern.compile("\\#\\{.*?\\}");
    private static final String DEL_P_TAG_MARGIN = "table p{margin:0px; padding:0px;}";
    private static final String AVOID_TR_BREAK_CSS = "table tr{ page-break-inside: avoid;}";
    private static final String TABLE_CELL_COLLAPSE = "table {border-collapse: collapse;}";
    private static final String IMAGE_SCALE_HEIGHT = System.getProperty("image.scale.height", "35");
    private static final String PREFIX_HTML = "<html>";
    private static final String SUFFIX_HTML = "</html>";
    private static final String HTML_PREFIX = "<html><body>";
    private static final String HTML_SUFFIX = "</body></html>";
    private static final IEcpLog LOG = EcpLogFactory.getLog(WordUtil.class);

    private WordUtil() {
    }

    public static String transferWord2Html(InputStream in, WordType wordType, boolean isScaleImage) {
        if (null == in) {
            throw new EcpCheckException("ERR.WORD.UTIL.001", "\u5165\u53c2InputStream\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == wordType) {
            throw new EcpCheckException("ERR.WORD.UTIL.001", "\u5165\u53c2wordType\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        return WordUtil.transferWord2Html(in, wordType, isScaleImage, null, null);
    }

    public static String transferWord2Html(InputStream in, WordType wordType, boolean isScaleImage, FontType fontType) {
        if (null == in) {
            throw new EcpCheckException("ERR.WORD.UTIL.001", "\u5165\u53c2InputStream\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == wordType) {
            throw new EcpCheckException("ERR.WORD.UTIL.001", "\u5165\u53c2wordType\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == fontType) {
            throw new EcpCheckException("ERR.WORD.UTIL.001", "\u5165\u53c2fontType\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        return WordUtil.transferWord2Html(in, wordType, isScaleImage, fontType, null);
    }

    public static String transferWord2Html(InputStream in, WordType wordType, String fontName, boolean isScaleImage) {
        if (null == in) {
            throw new EcpCheckException("ERR.WORD.UTIL.001", "\u5165\u53c2InputStream\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == wordType) {
            throw new EcpCheckException("ERR.WORD.UTIL.001", "\u5165\u53c2wordType\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)fontName)) {
            throw new EcpCheckException("ERR.WORD.UTIL.001", "\u5165\u53c2fontName\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        FontType fontType = FontType.getByFontName(fontName);
        return WordUtil.transferWord2Html(in, wordType, isScaleImage, fontType, null);
    }

    public static String transferWord2Html(InputStream in, WordType wordType, boolean isScaleImage, FontType fontType, PageMarginVO pageMargin) {
        if (null == in) {
            throw new EcpCheckException("ERR.WORD.UTIL.001", "\u5165\u53c2InputStream\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == wordType) {
            throw new EcpCheckException("ERR.WORD.UTIL.001", "\u5165\u53c2wordType\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        String html = "";
        try {
            if (wordType == WordType.DOC) {
                html = Word2003TransferFunction.INSTANCE.transfer2Html(in);
            }
            if (wordType == WordType.DOCX) {
                html = Word2007TransferFunction.INSTANCE.transfer2Html(in);
            }
            return WordUtil.handleWord2HtmlCssProblem(html, isScaleImage, fontType, pageMargin);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return html;
        }
    }

    public static String transferWord2Html(String templatePath, boolean isScaleImage) {
        if (StringUtils.isEmpty((CharSequence)templatePath)) {
            throw new EcpCheckException("ERR.WORD.UTIL.001", "\u5165\u53c2templatePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (!templatePath.endsWith(".doc") && !templatePath.endsWith(".docx")) {
            throw new EcpCheckException("ERR.WORD.UTIL.002", "\u975e\u6cd5\u683c\u5f0f\u3002");
        }
        return WordUtil.transferWord2Html(templatePath, isScaleImage, null, null);
    }

    public static String transferWord2Html(String templatePath, boolean isScaleImage, FontType fontType) {
        if (StringUtils.isEmpty((CharSequence)templatePath)) {
            throw new EcpCheckException("ERR.WORD.UTIL.001", "\u5165\u53c2templatePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == fontType) {
            throw new EcpCheckException("ERR.WORD.UTIL.001", "\u5165\u53c2fontType\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (!templatePath.endsWith(".doc") && !templatePath.endsWith(".docx")) {
            throw new EcpCheckException("ERR.WORD.UTIL.002", "\u975e\u6cd5\u683c\u5f0f\u3002");
        }
        return WordUtil.transferWord2Html(templatePath, isScaleImage, fontType, null);
    }

    public static String transferWord2Html(String templatePath, String fontName, boolean isScaleImage) {
        if (StringUtils.isEmpty((CharSequence)templatePath)) {
            throw new EcpCheckException("ERR.WORD.UTIL.001", "\u5165\u53c2templatePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)fontName)) {
            throw new EcpCheckException("ERR.WORD.UTIL.001", "\u5165\u53c2fontName\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (!templatePath.endsWith(".doc") && !templatePath.endsWith(".docx")) {
            throw new EcpCheckException("ERR.WORD.UTIL.002", "\u975e\u6cd5\u683c\u5f0f\u3002");
        }
        FontType fontType = FontType.getByFontName(fontName);
        return WordUtil.transferWord2Html(templatePath, isScaleImage, fontType, null);
    }

    public static String transferWord2Html(String templatePath, boolean isScaleImage, FontType fontType, PageMarginVO pageMargin) {
        if (StringUtils.isEmpty((CharSequence)templatePath)) {
            throw new EcpCheckException("ERR.WORD.UTIL.001", "\u5165\u53c2templatePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (!templatePath.endsWith(".doc") && !templatePath.endsWith(".docx")) {
            throw new EcpCheckException("ERR.WORD.UTIL.002", "\u975e\u6cd5\u683c\u5f0f\u3002");
        }
        String html = "";
        try {
            if (templatePath.endsWith(".doc")) {
                html = Word2003TransferFunction.INSTANCE.transfer2Html(templatePath);
            }
            if (templatePath.endsWith(".docx")) {
                html = Word2007TransferFunction.INSTANCE.transfer2Html(templatePath);
            }
            return WordUtil.handleWord2HtmlCssProblem(html, isScaleImage, fontType, pageMargin);
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return html;
        }
    }

    protected static String handleWord2HtmlCssProblem(String html, boolean isScaleImage, FontType fontType, PageMarginVO pageMargin) {
        if (StringUtils.isEmpty((CharSequence)html)) {
            return html;
        }
        String htmlTemp = html;
        htmlTemp = WordUtil.handleFont(htmlTemp, fontType);
        htmlTemp = WordUtil.translationHtmlTag(htmlTemp);
        htmlTemp = WordUtil.avoidTrBreak(htmlTemp);
        htmlTemp = WordUtil.clearCollapse(htmlTemp);
        htmlTemp = WordUtil.deletePMargin(htmlTemp);
        htmlTemp = WordUtil.handleTextAlignIneffective(htmlTemp);
        htmlTemp = WordUtil.setPageMargin(pageMargin, htmlTemp);
        htmlTemp = WordUtil.handleImagePlaceholder(htmlTemp, isScaleImage);
        htmlTemp = WordUtil.formatHtml(htmlTemp);
        return htmlTemp;
    }

    private static String formatHtml(String html) {
        Document doc = Jsoup.parse((String)html);
        doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml);
        doc.outputSettings().escapeMode(Entities.EscapeMode.xhtml);
        return doc.html();
    }

    private static String handleFont(String html, FontType fontType) {
        if (null != fontType) {
            return html.replaceAll(REGEX_FONT_FAMILY, fontType.getCssStyle());
        }
        return html.replaceAll(FontType.ST.getCssRegx(), FontType.ST.getCssStyle()).replaceAll(FontType.FS.getCssRegx(), FontType.FS.getCssStyle()).replaceAll(FontType.XST.getCssRegx(), FontType.XST.getCssStyle()).replaceAll(FontType.HT.getCssRegx(), FontType.HT.getCssStyle()).replaceAll(FontType.KT.getCssRegx(), FontType.KT.getCssStyle()).replaceAll(FontType.HWST.getCssRegx(), FontType.HWST.getCssStyle()).replaceAll(FontType.HWFS.getCssRegx(), FontType.HWFS.getCssStyle()).replaceAll(FontType.HWXH.getCssRegx(), FontType.HWXH.getCssStyle()).replaceAll(FontType.HWKT.getCssRegx(), FontType.HWKT.getCssStyle()).replaceAll(FontType.HWXK.getCssRegx(), FontType.HWXK.getCssStyle()).replaceAll(FontType.FZYT.getCssRegx(), FontType.FZYT.getCssStyle()).replaceAll(FontType.FZST.getCssRegx(), FontType.FZST.getCssStyle()).replaceAll(FontType.WRYH.getCssRegx(), FontType.WRYH.getCssStyle());
    }

    private static String translationHtmlTag(String html) {
        return html.replaceAll("&lt;", "<").replaceAll("&gt;", ">");
    }

    private static String avoidTrBreak(String html) {
        Matcher m = STYLE_TAG_PATTERN.matcher(html);
        if (m.find()) {
            String targetStr = m.group(0);
            return html.replace(targetStr, targetStr + AVOID_TR_BREAK_CSS);
        }
        return html;
    }

    private static String clearCollapse(String html) {
        Matcher m = STYLE_TAG_PATTERN.matcher(html);
        if (m.find()) {
            String targetStr = m.group(0);
            return html.replace(targetStr, targetStr + TABLE_CELL_COLLAPSE);
        }
        return html;
    }

    private static String deletePMargin(String html) {
        Matcher m = STYLE_TAG_PATTERN.matcher(html);
        if (m.find()) {
            String targetStr = m.group(0);
            return html.replace(targetStr, targetStr + DEL_P_TAG_MARGIN);
        }
        return html;
    }

    private static String handleTextAlignIneffective(String html) {
        return html.replace("text-align:end;", "text-align:right;").replace("text-align:start;", "text-align:left;");
    }

    private static String handleImagePlaceholder(String html, boolean isScaleImage) {
        Matcher matcher = IMG_PLACEHOLDER_PATTERN.matcher(html);
        String htmlTemp = html;
        while (matcher.find()) {
            int height;
            String tmp = matcher.group();
            String[] tmpArr = tmp.substring(2, tmp.length() - 1).split(",");
            String key = tmpArr[0];
            String imgText = "";
            if (tmpArr.length > 1) {
                height = Integer.valueOf(tmpArr[1]);
                imgText = "<img style=\"height:" + height + "px; \" src=\"data:image/png;base64, ${" + key + "}\" />";
            } else if (isScaleImage) {
                height = Integer.parseInt(IMAGE_SCALE_HEIGHT);
                imgText = "<img style=\"height:" + height + "px; \" src=\"data:image/png;base64, ${" + key + "}\" />";
            } else {
                imgText = "<img src=\"data:image/png;base64, ${" + key + "}\" />";
            }
            htmlTemp = htmlTemp.replace(tmp, imgText);
        }
        return htmlTemp;
    }

    private static String setPageMargin(PageMarginVO vo, String html) {
        Matcher m;
        BigDecimal margin;
        if (StringUtils.isEmpty((CharSequence)html)) {
            return html;
        }
        if (null == vo) {
            return html;
        }
        StringBuilder css = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)vo.getMarginTop())) {
            margin = new BigDecimal(vo.getMarginTop());
            css.append("margin-top:").append(margin.multiply(INCH_UNIT)).append("in;");
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getMarginLeft())) {
            margin = new BigDecimal(vo.getMarginLeft());
            css.append("margin-left:").append(margin.multiply(INCH_UNIT)).append("in;");
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getMarginRight())) {
            margin = new BigDecimal(vo.getMarginRight());
            css.append("margin-right:").append(margin.multiply(INCH_UNIT)).append("in;");
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getMarginBottom())) {
            margin = new BigDecimal(vo.getMarginBottom());
            css.append("margin-bottom:").append(margin.multiply(INCH_UNIT)).append("in;");
        }
        if (StringUtils.isNotEmpty((CharSequence)css.toString()) && (m = BODY_TAG_PATTERN.matcher(html)).find()) {
            String targetStr = m.group(0);
            String bodyTag = "<body style=\"" + css.toString() + "\">";
            return html.replace(targetStr, bodyTag);
        }
        return html;
    }

    public static ByteArrayOutputStream transferHtml2Word(InputStream htmlInput) {
        try {
            byte[] bytes = StreamUtil.getBytes((InputStream)htmlInput);
            String html = new String(bytes);
            return WordUtil.transferHtml2Word(html);
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return new ByteArrayOutputStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ByteArrayOutputStream transferHtml2Word(String html) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream inputStream = null;
        POIFSFileSystem poifsFileSystem = null;
        try {
            String content = HTML_PREFIX + html + HTML_SUFFIX;
            inputStream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
            poifsFileSystem = new POIFSFileSystem();
            poifsFileSystem.createDocument((InputStream)inputStream, "WordDocument");
            poifsFileSystem.writeFilesystem((OutputStream)byteArrayOutputStream);
            StreamUtil.closeStream((OutputStream)byteArrayOutputStream);
        }
        catch (Exception e) {
            if (!LOG.isErrorEnabled()) return byteArrayOutputStream;
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return byteArrayOutputStream;
        }
        StreamUtil.closeStream((InputStream)inputStream);
        try {
            poifsFileSystem.close();
            return byteArrayOutputStream;
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return byteArrayOutputStream;
        }
        finally {
            StreamUtil.closeStream((OutputStream)byteArrayOutputStream);
            StreamUtil.closeStream(inputStream);
            try {
                poifsFileSystem.close();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] transferHtml2WordRemoveInvalidInfo(String html) {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream inputStream = null;
        POIFSFileSystem poifsFileSystem = null;
        try {
            String htmlContent = html;
            if (StringUtil.isNullOrTrimEmptyString((String)htmlContent)) {
                htmlContent = HTML_PREFIX + html + HTML_SUFFIX;
            } else {
                if (!htmlContent.startsWith(PREFIX_HTML)) {
                    htmlContent = PREFIX_HTML + htmlContent;
                }
                if (!htmlContent.endsWith(SUFFIX_HTML)) {
                    htmlContent = htmlContent + SUFFIX_HTML;
                }
            }
            inputStream = new ByteArrayInputStream(htmlContent.getBytes(StandardCharsets.UTF_8));
            poifsFileSystem = new POIFSFileSystem();
            poifsFileSystem.createDocument((InputStream)inputStream, "WordDocument");
            poifsFileSystem.writeFilesystem((OutputStream)byteArrayOutputStream);
            PdfUtil.removeBlankPage(byteArrayOutputStream);
            String wordStream = byteArrayOutputStream.toString();
            wordStream = wordStream.substring(wordStream.lastIndexOf(PREFIX_HTML));
            wordStream = wordStream.substring(0, wordStream.indexOf(SUFFIX_HTML) + SUFFIX_HTML.length());
            byArray = wordStream.getBytes();
        }
        catch (Exception e) {
            try {
                String msg = String.format("\u5c06html\u8f6c\u6362\u4e3aword\u51fa\u73b0\u5f02\u5e38\uff1a%s", e.getMessage());
                LOG.error((Object)msg, (Throwable)e);
                throw AbcServiceException.newInstance(msg);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream((OutputStream)byteArrayOutputStream);
                StreamUtil.closeStream(inputStream);
                try {
                    poifsFileSystem.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    LOG.error((Object)String.format("\u5c06html\u8f6c\u6362\u4e3aword\uff0c\u5173\u95edPOIFSFileSystem\u6d41\u5f02\u5e38\uff1a%s", e2.getMessage()), (Throwable)e2);
                }
                throw throwable;
            }
        }
        StreamUtil.closeStream((OutputStream)byteArrayOutputStream);
        StreamUtil.closeStream((InputStream)inputStream);
        try {
            poifsFileSystem.close();
            return byArray;
        }
        catch (IOException e) {
            LOG.error((Object)String.format("\u5c06html\u8f6c\u6362\u4e3aword\uff0c\u5173\u95edPOIFSFileSystem\u6d41\u5f02\u5e38\uff1a%s", e.getMessage()), (Throwable)e);
        }
        return byArray;
    }
}

