/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.domain.vo;

import com.ygsoft.abc.service.domain.vo.JSTreeNodeVO;
import com.ygsoft.ecp.service.model.IValueObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JSTreeVO<T>
implements IValueObject {
    private static final long serialVersionUID = 3017014333450165394L;
    private List<JSTreeNodeVO<T>> datas = new ArrayList<JSTreeNodeVO<T>>();
    private Map<T, List<JSTreeNodeVO<T>>> pgidToList = new HashMap<T, List<JSTreeNodeVO<T>>>();
    private Map<T, JSTreeNodeVO<T>> gidToNode = new HashMap<T, JSTreeNodeVO<T>>();

    public static <T> JSTreeVO<T> newInstance(List<JSTreeNodeVO<T>> datas, boolean buildSlibings) {
        JSTreeVO<T> jstree = new JSTreeVO<T>(datas);
        if (buildSlibings) {
            super.buildSlibings();
        }
        return jstree;
    }

    public JSTreeVO(List<JSTreeNodeVO<T>> datas) {
        this.datas = datas;
    }

    public JSTreeVO() {
    }

    private void buildSlibings() {
        for (JSTreeNodeVO<T> treeNode : this.datas) {
            ArrayList<JSTreeNodeVO<T>> nodes;
            this.gidToNode.put(treeNode.getGid(), treeNode);
            T pgid = treeNode.getParentGid();
            if (this.pgidToList.containsKey(pgid)) {
                nodes = this.pgidToList.get(pgid);
                this.addNodeWithSlibings(nodes, treeNode);
                continue;
            }
            nodes = new ArrayList<JSTreeNodeVO<T>>();
            nodes.add(treeNode);
            this.pgidToList.put(pgid, nodes);
        }
    }

    private void addNodeWithSlibings(List<JSTreeNodeVO<T>> nodes, JSTreeNodeVO<T> node) {
        JSTreeNodeVO<T> lastNode = nodes.get(nodes.size() - 1);
        lastNode.setNextGid(node.getGid());
        node.setPreGid(lastNode.getGid());
        nodes.add(node);
    }

    public List<JSTreeNodeVO<T>> getDatas() {
        return this.datas;
    }

    public void setDatas(List<JSTreeNodeVO<T>> datas) {
        this.datas = datas;
    }

    public Map<T, List<JSTreeNodeVO<T>>> getPgidToList() {
        return this.pgidToList;
    }

    public Map<T, JSTreeNodeVO<T>> getGidToNode() {
        return this.gidToNode;
    }
}

