/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.domain.vo;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;

public class RestResult
implements Serializable {
    private static final long serialVersionUID = 7433220491024800404L;
    public static final String CODE_SUCCESS = "1";
    public static final String CODE_FAILURE = "0";
    private String code;
    private String message;
    private String data;

    public RestResult() {
    }

    public RestResult(String code, String data, String message) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public void fail(String message) {
        this.code = CODE_FAILURE;
        this.message = message;
        this.data = null;
    }

    public void succeed(String data, String message) {
        this.code = CODE_SUCCESS;
        this.message = message;
        this.data = data;
    }

    public static RestResult failure(String message) {
        RestResult result = new RestResult();
        result.fail(message);
        return result;
    }

    public static <T> RestResult ofFailure(T data, String message) {
        String dataStr = JSON.toJSONString(data);
        RestResult result = RestResult.failure(message);
        result.setData(dataStr);
        return result;
    }

    public static RestResult success(String data, String message) {
        RestResult result = new RestResult();
        result.succeed(data, message);
        return result;
    }

    public static <T> RestResult ofSuccess(T data) {
        String dataStr = JSON.toJSONString(data);
        return RestResult.success(dataStr, "");
    }

    public static <T> RestResult ofSuccess(T data, String message) {
        String dataStr = JSON.toJSONString(data);
        return RestResult.success(dataStr, message);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }
}

