/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.excel;

import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.CollectionUtils;
import com.alibaba.fastjson.JSONArray;
import com.ygsoft.abc.service.consts.ExcelConst;
import com.ygsoft.abc.service.excel.IExcelImportHandler;
import com.ygsoft.abc.service.excel.bo.ImportResultBO;
import com.ygsoft.abc.service.excel.bo.ImportValueBO;
import com.ygsoft.abc.service.tool.ExcelUtil;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

public abstract class AbstractExcelImportHandler
implements IExcelImportHandler {
    private static final IEcpLog LOG = EcpLogFactory.getLog(AbstractExcelImportHandler.class);
    private ThreadLocal<List<ImportValueBO>> tl = new ThreadLocal();

    public List<ImportValueBO> getSourceImprtValue() {
        return this.tl.get();
    }

    @Override
    @Transactional
    public ImportResultBO excuteImport(MultipartFile file, String configFilePath) {
        if (null == file) {
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"AbstractExcelImportHandler_excuteImport_77", (String)"\u6587\u4ef6\u4e3a\u7a7a\u3002"));
        }
        if (StringUtil.isEmptyString((String)configFilePath)) {
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"AbstractExcelImportHandler_excuteImport_80", (String)"\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\u3002"));
        }
        Map<String, Map<String, String>> colRules = this.readColumnRule(configFilePath);
        List<ImportValueBO> excelDatas = this.readExcel(file, colRules);
        List sourceExcelDatas = excelDatas.stream().collect(Collectors.toList());
        this.tl.set(sourceExcelDatas);
        ImportResultBO result = new ImportResultBO();
        result.setAllDatas(excelDatas);
        List<ImportValueBO> validRuleDatas = this.checkImportDataByColRule(excelDatas, colRules, result);
        List<ImportValueBO> validDatas = this.checkImportData(validRuleDatas, colRules, result);
        int rows = this.importCallback(validDatas);
        result.setCount(String.valueOf(rows));
        if (0 == rows) {
            result.setFlag("0");
        } else if (rows == validRuleDatas.size()) {
            result.setFlag("1");
        } else {
            result.setFlag("2");
        }
        return result;
    }

    protected abstract List<ImportValueBO> checkImportData(List<ImportValueBO> var1, Map<String, Map<String, String>> var2, ImportResultBO var3);

    protected abstract int importCallback(List<ImportValueBO> var1);

    private Map<String, Map<String, String>> readColumnRule(String configFilePath) {
        String fileContent = this.readFile(configFilePath);
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        List ruleList = null;
        try {
            ruleList = (List)JSONArray.parseObject((String)fileContent, List.class);
        }
        catch (Exception e) {
            String msg = EcpI18nUtil.localizedString((String)"AbstractExcelImportHandler_readColumnRule_155", (String)"\u89e3\u6790\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u3002");
            this.errorLog(msg, e);
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", msg);
        }
        if (CollectionUtils.isEmpty((Collection)ruleList)) {
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"AbstractExcelImportHandler_readColumnRule_158", (String)"\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002"));
        }
        this.checkColRule(ruleList);
        ruleList.forEach(item -> result.put((String)item.get("columnText"), (Map<String, String>)item));
        return result;
    }

    private String readFile(String filePath) {
        BufferedReader bufReader = null;
        StringBuilder rule = new StringBuilder("");
        try {
            InputStream in = this.getClass().getResourceAsStream(filePath);
            bufReader = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while (StringUtil.isNotEmpty((String)(line = bufReader.readLine()))) {
                rule.append(line);
            }
        }
        catch (Exception e) {
            String msg = EcpI18nUtil.localizedString((String)"AbstractExcelImportHandler_readFile_189", (String)("\u8bfb\u53d6\u6587\u4ef6\uff1a" + filePath + "\u5931\u8d25\u3002\u539f\u56e0\uff1a"), (Object[])new Object[]{filePath}) + e.getMessage();
            this.errorLog(msg, e);
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", msg);
        }
        finally {
            if (null != bufReader) {
                try {
                    bufReader.close();
                }
                catch (IOException e) {
                    this.errorLog("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a" + e.getMessage(), e);
                    throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"AbstractExcelImportHandler_readFile_196", (String)"\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\u3002"));
                }
            }
        }
        return rule.toString();
    }

    private void checkColRule(List<Map<String, String>> rules) {
        rules.forEach(item -> {
            if (!item.containsKey("columnText")) {
                throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"AbstractExcelImportHandler_checkColRule_212", (String)"\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u7f3a\u5931columnText\u914d\u7f6e\u9879\u3002"));
            }
            if (!item.containsKey("columnName")) {
                throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"AbstractExcelImportHandler_checkColRule_217", (String)"\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u7f3a\u5931columnName\u914d\u7f6e\u9879\u3002"));
            }
            if (item.containsKey("required")) {
                String value = (String)item.get("required");
                if (!"true".equals(value) && !"false".equals(value)) {
                    throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"AbstractExcelImportHandler_checkColRule_224", (String)"\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u4e2drequired\u914d\u7f6e\u9879\u914d\u7f6e\u6709\u8bef\u3002"));
                }
            } else {
                item.put("required", "false");
            }
            if (item.containsKey("columnType")) {
                String dateType = (String)item.get("columnType");
                if (StringUtil.isNullOrTrimEmptyString((String)dateType) || !ExcelConst.DATA_TYPES.containsKey(dateType.toLowerCase())) {
                    throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"AbstractExcelImportHandler_checkColRule_235", (String)"\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u4e2dcolumnType\u914d\u7f6e\u9879\u914d\u7f6e\u6709\u8bef\u3002"));
                }
            } else {
                item.put("columnType", "string");
            }
        });
    }

    private List<ImportValueBO> checkImportDataByColRule(List<ImportValueBO> excelData, Map<String, Map<String, String>> colRule, ImportResultBO result) {
        excelData.forEach(item -> {
            this.isRowRequired((ImportValueBO)((Object)item), colRule, result);
            this.checkColumnDataType((ImportValueBO)((Object)item), colRule, result);
        });
        this.checkRepeatRow(excelData, colRule, result);
        return excelData.stream().filter(item -> !"false".equals(item.get("valid"))).collect(Collectors.toList());
    }

    private void checkRepeatRow(List<ImportValueBO> excelData, Map<String, Map<String, String>> colRule, ImportResultBO result) {
        Map<String, String> rule = null;
        String[] multiUnique = null;
        String multiUniqueStr = "";
        for (String key : colRule.keySet()) {
            rule = colRule.get(key);
            if (null == rule || !rule.containsKey("multiUnique") || StringUtil.isNullOrTrimEmptyString((String)(multiUniqueStr = rule.get("multiUnique")))) continue;
            multiUnique = multiUniqueStr.trim().split(",");
        }
        if (null == multiUnique || multiUnique.length == 0) {
            return;
        }
        for (Iterator<String> iterator : multiUnique) {
            boolean valid = false;
            for (String colKey : colRule.keySet()) {
                if (!((String)((Object)iterator)).equals(colRule.get(colKey).get("columnName"))) continue;
                valid = true;
                break;
            }
            if (valid) continue;
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"AbstractExcelImportHandler_checkRepeatRow_311", (String)"\u914d\u7f6e\u6587\u4ef6\u4e2dmultiUnique\u914d\u7f6e\u9879\u5b58\u5728\u65e0\u6548\u5c5e\u6027\u503c\u3002"));
        }
        HashMap<String, String> rowRepeatMap = new HashMap<String, String>();
        StringBuilder keyBuilder = null;
        String key = "";
        for (ImportValueBO item : excelData) {
            keyBuilder = new StringBuilder("");
            String rowNo = item.get("rowNo");
            for (String unqiueKey : multiUnique) {
                keyBuilder.append(item.get(unqiueKey)).append(",");
            }
            key = keyBuilder.toString();
            if (rowRepeatMap.containsKey(key)) {
                result.fail(rowNo, "\u4e0e\u7b2c" + (String)rowRepeatMap.get(key) + "\u884c\u6570\u636e\u91cd\u590d\u3002");
                item.set("valid", "false");
                continue;
            }
            rowRepeatMap.put(key, rowNo);
        }
    }

    private boolean isRowRequired(ImportValueBO rowData, Map<String, Map<String, String>> colRule, ImportResultBO result) {
        String configValue = "";
        String columnValue = null;
        String columnName = "";
        String columnText = "";
        String rowNo = String.valueOf(rowData.get("rowNo"));
        StringBuilder msg = new StringBuilder("");
        boolean isValid = true;
        block0: for (String rowKey : rowData.getValueMap().keySet()) {
            for (String colRowkey : colRule.keySet()) {
                columnName = colRule.get(colRowkey).get("columnName");
                columnText = colRule.get(colRowkey).get("columnText");
                if (!rowKey.equals(columnName)) continue;
                configValue = colRule.get(colRowkey).get("required");
                columnValue = rowData.get(rowKey);
                if ("false".equals(configValue) || "true".equals(configValue) && StringUtil.isNotEmpty((String)columnValue)) continue block0;
                isValid = false;
                msg.append("\u3010").append(columnText + "\u3011\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                continue block0;
            }
        }
        if (!isValid) {
            result.fail(rowNo, msg.toString());
            rowData.set("valid", "false");
        }
        return isValid;
    }

    private boolean checkColumnDataType(ImportValueBO rowData, Map<String, Map<String, String>> colRule, ImportResultBO result) {
        String configValue = "";
        String columnValue = null;
        String columnName = "";
        String columnText = "";
        String pattern = "yyyy-MM-dd";
        String rowNo = String.valueOf(rowData.get("rowNo"));
        StringBuilder msg = new StringBuilder("");
        boolean isValid = true;
        block0: for (String rowKey : rowData.getValueMap().keySet()) {
            for (String colRowkey : colRule.keySet()) {
                columnName = colRule.get(colRowkey).get("columnName");
                if (!rowKey.equals(columnName)) continue;
                columnText = colRule.get(colRowkey).get("columnText");
                if (colRule.get(colRowkey).containsKey("pattern")) {
                    pattern = colRule.get(colRowkey).get("pattern");
                }
                configValue = colRule.get(colRowkey).get("columnType");
                columnValue = rowData.get(rowKey);
                if (this.checkDataType(columnValue, configValue, pattern)) continue block0;
                isValid = false;
                msg.append("\u3010").append(columnText + "\u3011\u5217\u5bfc\u5165\u7684\u6570\u636e\u7c7b\u578b\u548c\u683c\u5f0f\u4e0e\u914d\u7f6e\u7684\u4e0d\u4e00\u81f4\u3002");
                continue block0;
            }
        }
        if (!isValid) {
            result.fail(rowNo, msg.toString());
            rowData.set("valid", "false");
        }
        return isValid;
    }

    private List<ImportValueBO> readExcel(MultipartFile file, Map<String, Map<String, String>> colRule) {
        String excelFileName = file.getOriginalFilename();
        Workbook workbook = null;
        try {
            workbook = ExcelUtil.getWrokbook(file.getInputStream(), excelFileName);
        }
        catch (Exception e) {
            this.errorLog("\u8bfb\u53d6\u5bfc\u5165\u6587\u4ef6\u51fa\u9519\u3002", e);
            throw new EcpRuntimeException(EcpI18nUtil.localizedString((String)"AbstractExcelImportHandler_readExcel_461", (String)"\u5bfc\u5165\u51fa\u9519"), e.getMessage());
        }
        ArrayList<ImportValueBO> excelDatas = new ArrayList<ImportValueBO>();
        Sheet sheet = workbook.getSheetAt(0);
        if (null == sheet) {
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"AbstractExcelImportHandler_readExcel_468", (String)"\u6587\u4ef6\u683c\u5f0f\u6709\u8bef\u3002"));
        }
        String sheetName = sheet.getSheetName();
        ImportValueBO rowValue = null;
        Row row = sheet.getRow(0);
        int colCounts = row.getLastCellNum();
        if (colCounts == 0) {
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"AbstractExcelImportHandler_readExcel_478", (String)"excel\u8868\u683c\u5934\u90e8\u4e0d\u80fd\u4e3a\u7a7a\u3002"));
        }
        ArrayList<String> headNames = new ArrayList<String>();
        for (int j = 0; j < colCounts; ++j) {
            String colName = ExcelUtil.getCellValue(row, j);
            if (!colRule.containsKey(colName)) {
                throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"AbstractExcelImportHandler_readExcel_486", (String)("\u914d\u7f6e\u6587\u4ef6\u4e2d\u4e0d\u5b58\u5728columnText=" + colName + "\u7684\u914d\u7f6e\u9879\u3002"), (Object[])new Object[]{colName}));
            }
            headNames.add(colRule.get(colName).get("columnName"));
        }
        for (int rowIndex = 1; rowIndex <= sheet.getLastRowNum(); ++rowIndex) {
            rowValue = new ImportValueBO();
            row = sheet.getRow(rowIndex);
            StringBuilder rowSb = new StringBuilder("");
            try {
                rowValue.set("rowNo", String.valueOf(rowIndex + 1));
                for (int colIndex = 0; colIndex < colCounts; ++colIndex) {
                    String cellValue = ExcelUtil.getCellValue(row, colIndex);
                    rowSb.append(cellValue);
                    rowValue.set((String)headNames.get(colIndex), cellValue);
                }
            }
            catch (Exception e) {
                this.errorLog("\u8bfb\u53d6" + excelFileName + "-->" + sheetName + "-->" + rowIndex + "\u884c\u51fa\u9519\u3002", e);
                continue;
            }
            if (StringUtil.isEmptyString((String)rowSb.toString())) continue;
            excelDatas.add(rowValue);
        }
        if (excelDatas.size() == 0) {
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"AbstractExcelImportHandler_readExcel_515", (String)"\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a\u3002"));
        }
        return excelDatas;
    }

    private void errorLog(String msg, Exception e) {
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)msg, (Throwable)e);
        }
    }

    private boolean checkDataType(String data, String type, String pattern) {
        switch (type) {
            case "number": {
                return StringUtil.isNotEmpty((String)data) && data.matches("-[0-9]+(.[0-9]+)?|[0-9]+(.[0-9]+)?");
            }
            case "date": {
                try {
                    SimpleDateFormat format = new SimpleDateFormat(pattern);
                    format.setLenient(false);
                    format.parse(data);
                }
                catch (ParseException e) {
                    this.errorLog("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38\uff1a" + data + "---\u300b" + type + "---\u300b" + pattern, e);
                    return false;
                }
                return true;
            }
        }
        return true;
    }
}

