/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.filter;

import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.login.ExtendContextContainer;
import com.ygsoft.abc.service.tool.BlockUrlBuilder;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.abc.service.tool.UrlUtils;
import com.ygsoft.ecp.framework.util.ResourceUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class BaseTokenFilter
implements Filter {
    private static final IEcpLog LOG = EcpLogFactory.getLog(BaseTokenFilter.class);
    private static final String NOFILTER_PATH = "classpath*:/META-INF/ecp-login/nofiler.url.properties";
    private static final String FILTER_ERROR_URL = "/filter/error";
    protected static final Set<String> EXCLUDE_PATH = new HashSet<String>();

    protected void addExcludePath() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"BaseTokenFilter init.");
        }
        EXCLUDE_PATH.add("/checklogin");
        EXCLUDE_PATH.add("/modifyUserPwd");
        EXCLUDE_PATH.add("/necp/mapp/4a/necp/login/getRandomValidteCode");
        EXCLUDE_PATH.addAll(this.readNofilterConfig(NOFILTER_PATH));
        this.addExcludePath();
    }

    public void destroy() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"BaseTokenFilter destroy.");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String url = UrlUtils.buildRequestUrl(httpRequest);
        String path = BlockUrlBuilder.parsePath(url);
        if (PropertyConfigUtil.getSystemState().isShutdown()) {
            String errorUrl = PropertyConfigUtil.getVipAddress() + FILTER_ERROR_URL;
            if (path.equals(errorUrl)) {
                chain.doFilter(request, response);
                return;
            }
            request.setAttribute("errMsg", (Object)"\u7cfb\u7edf\u505c\u673a\u7ef4\u62a4\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
            request.getRequestDispatcher(errorUrl).forward(request, response);
            return;
        }
        if (this.isPublic(path)) {
            chain.doFilter(request, response);
            return;
        }
        if (ExtendContextContainer.checkToken()) {
            String redirectUrl = this.permitUrl(path);
            if (StringUtil.isNotEmpty((String)redirectUrl)) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("\u8bbf\u95ee\u83dc\u5355\u65e0\u6743\u9650\u3002url[" + url + "]"));
                }
                httpResponse.sendRedirect(redirectUrl);
                return;
            }
            chain.doFilter(request, response);
        } else {
            String xRequest;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("token\u9a8c\u8bc1\u5931\u8d25\uff0c\u9700\u8981\u91cd\u65b0\u767b\u5f55\u3002url[" + url + "]"));
            }
            if (this.bizSupport(url)) {
                httpResponse.setHeader("REDIRECT", "REDIRECT");
                return;
            }
            String loginUrl = PropertyConfigUtil.getLoginUrl();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("\u767b\u5f55url[" + loginUrl + "]"));
            }
            if ((xRequest = httpRequest.getHeader("X-Requested-With")) != null && "XMLHttpRequest".equalsIgnoreCase(xRequest)) {
                httpResponse.setStatus(200);
                httpResponse.setHeader("REDIRECT", "REDIRECT");
                httpResponse.setHeader("CONTEXTPATH", loginUrl);
            } else {
                httpResponse.sendRedirect(loginUrl);
            }
        }
    }

    protected boolean isPublic(String url) {
        String urlPath = url;
        int firstQuestionMarkIndex = url.indexOf("?");
        if (firstQuestionMarkIndex != -1) {
            urlPath = url.substring(0, firstQuestionMarkIndex);
        }
        if (urlPath.indexOf("/assets/") != -1) {
            return true;
        }
        if (urlPath.indexOf("/actuator/") != -1) {
            return true;
        }
        if (urlPath.indexOf("/plugins/") != -1) {
            return true;
        }
        if (EXCLUDE_PATH.contains(urlPath)) {
            return true;
        }
        return urlPath.endsWith("/websocket");
    }

    protected boolean bizSupport(String url) {
        return false;
    }

    protected String permitUrl(String url) {
        return null;
    }

    protected Set<String> readNofilterConfig(String filePath) {
        HashSet<String> set = new HashSet<String>();
        try {
            List urls = ResourceUtil.findResources((String)filePath);
            for (URL url : urls) {
                List lines = IOUtils.readLines((InputStream)url.openStream(), (String)"UTF-8");
                lines.forEach(path -> {
                    if (this.isValidUrlPath((String)path)) {
                        set.add((String)path);
                    }
                });
            }
        }
        catch (Exception e) {
            String msg = String.format(EcpI18nUtil.localizedString((String)"BaseTokenFilter_readNofilterConfig_202", (String)"\u8bfb\u53d6nofilter\u914d\u7f6e\u6587\u4ef6%s\u5931\u8d25\u3002"), filePath);
            throw new AbcServiceException("ABC.0015", msg, e, new Object[0]);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\n>>>url\u767d\u540d\u5355\uff1a" + set));
        }
        return set;
    }

    private boolean isValidUrlPath(String url) {
        if (StringUtil.isNullOrTrimEmptyString((String)url)) {
            return false;
        }
        return !url.startsWith("#");
    }
}

