/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.http;

import com.ygsoft.abc.service.exception.AbcIOException;
import com.ygsoft.abc.service.http.DelegatingServletInputStream;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;

public class SimpleRequestWrapper
extends HttpServletRequestWrapper {
    static final IEcpLog LOG = EcpLogFactory.getLog(SimpleRequestWrapper.class);
    private Map<String, String[]> parameterMap;
    private HttpServletRequest request;
    private byte[] requestBody;

    public SimpleRequestWrapper(HttpServletRequest request) {
        super(request);
        this.request = request;
        this.parameterMap = request.getParameterMap();
        this.readBody();
    }

    public Enumeration<String> getParameterNames() {
        Vector<String> vector = new Vector<String>(this.parameterMap.keySet());
        return vector.elements();
    }

    public String getParameter(String name) {
        String[] results = this.parameterMap.get(name);
        if (null == results) {
            return null;
        }
        return results[0];
    }

    public String[] getParameterValues(String name) {
        return this.parameterMap.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public void setParameterMap(Map<String, String[]> parameterMap) {
        this.parameterMap = parameterMap;
    }

    private void readBody() {
        try (ServletInputStream input = this.request.getInputStream();){
            if (null == input) {
                this.requestBody = null;
            }
            this.requestBody = IOUtils.toByteArray((InputStream)input);
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0014", "\u8bfb\u53d6\u8bf7\u6c42body\u5931\u8d25\u3002", e, new Object[0]);
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        String data = new String(this.requestBody);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data.getBytes());
        return new DelegatingServletInputStream(byteArrayInputStream);
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public String getBodyData() {
        if (null == this.requestBody) {
            return null;
        }
        String data = new String(this.requestBody);
        return data;
    }
}

