/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.http.kit;

import java.io.Serializable;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;

public class HttpClientInitParam
implements Serializable {
    private static final long serialVersionUID = -6094688876626332744L;
    private static final int DEFAULT_POOL_MAX_TOTAL = 200;
    private static final int DEFAULT_POOL_MAX_PER_ROUTE = 200;
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private static final int DEFAULT_CONNECT_REQUEST_TIMEOUT = 30000;
    private static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    private static final HttpClientInitParam INSTANCE = new HttpClientInitParam(200, 200, 30000, 30000, 30000);
    private int maxTotal;
    private int maxPerRoute;
    private int connectTimeout;
    private int connectRequestTimeout;
    private int socketTimeout;
    private ConnectionSocketFactory httpConnectSocketFactory;
    private ConnectionSocketFactory httpsConnectSocketFactory;

    public HttpClientInitParam() {
    }

    public HttpClientInitParam(int maxTotal, int maxPerRoute, int connectTimeout, int connectRequestTimeout, int socketTimeout) {
        this.maxTotal = maxTotal;
        this.maxPerRoute = maxPerRoute;
        this.connectTimeout = connectTimeout;
        this.connectRequestTimeout = connectRequestTimeout;
        this.socketTimeout = socketTimeout;
        this.httpConnectSocketFactory = PlainConnectionSocketFactory.getSocketFactory();
        this.httpsConnectSocketFactory = SSLConnectionSocketFactory.getSocketFactory();
    }

    public static HttpClientInitParam getInstance() {
        return INSTANCE;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int newMaxTotal) {
        this.maxTotal = newMaxTotal;
    }

    public int getMaxPerRoute() {
        return this.maxPerRoute;
    }

    public void setMaxPerRoute(int newMaxPerRoute) {
        this.maxPerRoute = newMaxPerRoute;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int newConnectTimeout) {
        this.connectTimeout = newConnectTimeout;
    }

    public int getConnectRequestTimeout() {
        return this.connectRequestTimeout;
    }

    public void setConnectRequestTimeout(int newConnectRequestTimeout) {
        this.connectRequestTimeout = newConnectRequestTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int newSocketTimeout) {
        this.socketTimeout = newSocketTimeout;
    }

    public ConnectionSocketFactory getHttpConnectSocketFactory() {
        return this.httpConnectSocketFactory;
    }

    public void setHttpConnectSocketFactory(ConnectionSocketFactory newHttpConnectSocketFactory) {
        this.httpConnectSocketFactory = newHttpConnectSocketFactory;
    }

    public ConnectionSocketFactory getHttpsConnectSocketFactory() {
        return this.httpsConnectSocketFactory;
    }

    public void setHttpsConnectSocketFactory(ConnectionSocketFactory newHttpsConnectSocketFactory) {
        this.httpsConnectSocketFactory = newHttpsConnectSocketFactory;
    }

    public String toString() {
        return "HttpClientInitParam [maxTotal=" + this.maxTotal + ", maxPerRoute=" + this.maxPerRoute + ", connectTimeout=" + this.connectTimeout + ", connectRequestTimeout=" + this.connectRequestTimeout + ", socketTimeout=" + this.socketTimeout + ", httpConnectSocketFactory=" + this.httpConnectSocketFactory + ", httpsConnectSocketFactory=" + this.httpsConnectSocketFactory + "]";
    }
}

