/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.operationLog.aspect;

import com.ygsoft.abc.service.operationLog.IOperationLogInvoker;
import com.ygsoft.abc.service.operationLog.OpLogCache;
import com.ygsoft.abc.service.operationLog.annotation.OperationLog;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.text.MessageFormat;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class OperationLogAspect {
    private static final IEcpLog LOG = EcpLogFactory.getLog(OperationLogAspect.class);
    @Autowired(required=false)
    private IOperationLogInvoker invoker;

    @Pointcut(value="@annotation(com.ygsoft.abc.service.operationLog.annotation.OperationLog)")
    public void operationLogPointCut() {
    }

    @AfterReturning(value="operationLogPointCut()", returning="result")
    public void afterReturning(JoinPoint jp, Object result) {
        MethodSignature signature = (MethodSignature)jp.getSignature();
        OperationLog operationLog = signature.getMethod().getAnnotation(OperationLog.class);
        this.exec(jp, operationLog.op(), operationLog.successDesc());
    }

    @AfterThrowing(value="operationLogPointCut()", throwing="e")
    public void afterThrowing(JoinPoint jp, Exception e) {
        MethodSignature signature = (MethodSignature)jp.getSignature();
        OperationLog operationLog = signature.getMethod().getAnnotation(OperationLog.class);
        this.exec(jp, operationLog.op(), operationLog.failureDesc());
    }

    private void exec(JoinPoint jp, String op, String opDesc) {
        String operationDesc = opDesc;
        if (null == op || "".equals(op.trim()) || null == operationDesc || "".equals(operationDesc.trim())) {
            LOG.info((Object)"\u64cd\u4f5c\u5b57\u6bb5\u6216\u64cd\u4f5c\u63cf\u8ff0\u4e3a\u7a7a\uff0c\u4e0d\u8bb0\u5f55\u65e5\u5fd7\u3002");
            return;
        }
        List<String> descValue = OpLogCache.get();
        if (null != descValue && !descValue.isEmpty()) {
            operationDesc = MessageFormat.format(operationDesc, descValue.toArray());
            OpLogCache.clear();
        }
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        if (null != this.invoker) {
            this.invoker.invoke(request, op, operationDesc);
        }
    }
}

