/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.querydelivery.tool;

import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.CollectionUtils;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.querydelivery.type.QueryOperator;
import com.ygsoft.abc.service.tool.BlockCodingUtil;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.ecp.service.internal.log.EcpLogUtils;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.JSONUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class QueryTypeTool {
    private static final IEcpLog LOG = EcpLogFactory.getLog(QueryTypeTool.class);
    public static final String QUERY_NULL = "_null_";
    public static final String QUERY_NOT_NULL = "_notnull_";
    public static final String ORDER_DEFULT_COLUMN = "_order_";
    public static final String EQ = "eq";
    public static final String NOTEQ = "noteq";
    public static final String IN = "in";
    public static final String NOTIN = "notin";
    public static final String LIKE = "like";
    public static final String GT = "gt";
    public static final String EGT = "egt";
    public static final String LT = "lt";
    public static final String ELT = "elt";
    public static final String ISNULL = "isnull";
    public static final String ASC = "asc";
    public static final String DESC = "desc";

    private QueryTypeTool() {
    }

    public static String buildUrlParam(List<QueryOperator<String>> operatorList) {
        if (CollectionUtils.isEmpty(operatorList)) {
            String msg = EcpI18nUtil.localizedString((String)"QueryTypeTool_buildUrlParam_78", (String)"\u53c2\u6570\u9519\u8bef\uff1aoperatorList\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        String filter = JSONArray.toJSONString(operatorList);
        return BlockCodingUtil.encodeUrl(filter);
    }

    public static String encoderFilter(String jsonFilter) throws UnsupportedEncodingException {
        return URLEncoder.encode(jsonFilter, "utf-8");
    }

    public static String optToTypeClass(String opt) {
        String clsStr = "";
        if (EQ.equals(opt)) {
            clsStr = "com.ygsoft.abc.service.querydelivery.type.EqualQueryOperator";
        } else if (NOTEQ.equals(opt)) {
            clsStr = "com.ygsoft.abc.service.querydelivery.type.NotEqualQueryOperator";
        } else if (IN.equals(opt)) {
            clsStr = "com.ygsoft.abc.service.querydelivery.type.InQueryOperator";
        } else if (NOTIN.equals(opt)) {
            clsStr = "com.ygsoft.abc.service.querydelivery.type.NotInQueryOperator";
        } else if (LIKE.equals(opt)) {
            clsStr = "com.ygsoft.abc.service.querydelivery.type.LikeQueryOperator";
        } else if (GT.equals(opt)) {
            clsStr = "com.ygsoft.abc.service.querydelivery.type.GtQueryOperator";
        } else if (EGT.equals(opt)) {
            clsStr = "com.ygsoft.abc.service.querydelivery.type.EGtQueryOperator";
        } else if (LT.equals(opt)) {
            clsStr = "com.ygsoft.abc.service.querydelivery.type.LtQueryOperator";
        } else if (ELT.equals(opt)) {
            clsStr = "com.ygsoft.abc.service.querydelivery.type.ELtQueryOperator";
        } else if (ISNULL.equals(opt)) {
            clsStr = "com.ygsoft.abc.service.querydelivery.type.NullQueryOperator";
        } else if (ASC.equals(opt) || DESC.equals(opt)) {
            clsStr = "com.ygsoft.abc.service.querydelivery.type.OrderQueryOperator";
        }
        return clsStr;
    }

    public static List<QueryOperator> analysisFilter(String filter) {
        ArrayList<QueryOperator> operatorList = new ArrayList<QueryOperator>();
        if (StringUtil.isNotEmptyString((String)filter)) {
            try {
                List list = JSONArray.parseArray((String)URLDecoder.decode(filter, "utf-8"), JSONObject.class);
                list.forEach(jsonObj -> {
                    if (jsonObj.containsKey((Object)"jcls")) {
                        jsonObj.remove((Object)"jcls");
                    }
                    String opt = String.valueOf(jsonObj.get((Object)"opt"));
                    String clsStr = QueryTypeTool.optToTypeClass(opt);
                    String value = jsonObj.toJSONString();
                    QueryOperator qo = null;
                    try {
                        qo = (QueryOperator)JSONUtil.fromJsonString((String)value, Class.forName(clsStr));
                        qo.setCls(clsStr);
                    }
                    catch (Exception e) {
                        EcpLogUtils.handleAndLogException((Throwable)e);
                    }
                    operatorList.add(qo);
                });
            }
            catch (UnsupportedEncodingException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)"\u53c2\u6570filter decode \u62a5\u9519");
                }
                EcpLogUtils.handleAndLogException((Throwable)e);
            }
        }
        return operatorList;
    }

    public static Object typeConversion(String propertyValue, Class propertyClass) {
        if (Integer.class.isAssignableFrom(propertyClass) || Integer.TYPE.isAssignableFrom(propertyClass)) {
            return Integer.parseInt(propertyValue);
        }
        if (Float.class.isAssignableFrom(propertyClass) || Float.TYPE.isAssignableFrom(propertyClass)) {
            return Float.valueOf(Float.parseFloat(propertyValue));
        }
        if (Long.class.isAssignableFrom(propertyClass) || Long.TYPE.isAssignableFrom(propertyClass)) {
            return Long.parseLong(propertyValue);
        }
        if (Double.class.isAssignableFrom(propertyClass) || Double.TYPE.isAssignableFrom(propertyClass)) {
            return Double.parseDouble(propertyValue);
        }
        if (BigDecimal.class.isAssignableFrom(propertyClass)) {
            return new BigDecimal(propertyValue);
        }
        if (Boolean.class.isAssignableFrom(propertyClass) || Boolean.TYPE.isAssignableFrom(propertyClass)) {
            return Boolean.valueOf(propertyValue);
        }
        if (Date.class.isAssignableFrom(propertyClass)) {
            return CastUtil.stringToDate(propertyValue);
        }
        return propertyValue;
    }
}

