/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.schedule.domain.vo;

import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.abc.service.types.YesnoEnum;
import com.ygsoft.ecp.service.tool.UuidUtil;
import java.util.Date;

public class TimedTaskWrapper {
    private String taskID;
    private final String taskName;
    private final String taskArgument;
    private final Date createTime;
    private YesnoEnum persistent = YesnoEnum.YES;
    private Runnable taskItem;

    public TimedTaskWrapper(Runnable taskItem) {
        this(UuidUtil.newUUID(), taskItem);
    }

    public TimedTaskWrapper(String taskID, Runnable taskItem) {
        this.taskName = "-";
        this.taskArgument = "-";
        this.createTime = new Date();
        this.persistent = YesnoEnum.NO;
        this.taskID = taskID;
        this.taskItem = taskItem;
    }

    public TimedTaskWrapper(String newTaskName, String newTaskArgument) {
        this.taskID = UuidUtil.newUUID();
        this.taskName = newTaskName;
        this.taskArgument = newTaskArgument;
        this.createTime = new Date();
    }

    public static TimedTaskWrapper newInstance(String taskName, String taskArgument) {
        PreconditionUtil.checkNotTrimEmpty(taskName, "\u53c2\u6570\u9519\u8bef\uff1ataskName\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotTrimEmpty(taskArgument, "\u53c2\u6570\u9519\u8bef\uff1ataskArgument\u4e3a\u7a7a\u3002");
        return new TimedTaskWrapper(taskName, taskArgument);
    }

    public static TimedTaskWrapper newTemporary(Runnable taskItem) {
        PreconditionUtil.checkNotNull(taskItem, "\u53c2\u6570\u9519\u8bef\uff1ataskItem\u4e3a\u7a7a\u3002");
        return new TimedTaskWrapper(taskItem);
    }

    public static TimedTaskWrapper newTemporary(String taskID, Runnable taskItem) {
        PreconditionUtil.checkNotTrimEmpty(taskID, "\u53c2\u6570\u9519\u8bef\uff1ataskID\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotNull(taskItem, "\u53c2\u6570\u9519\u8bef\uff1ataskItem\u4e3a\u7a7a\u3002");
        TimedTaskWrapper wrapper = new TimedTaskWrapper(taskID, taskItem);
        return wrapper;
    }

    public String buildKey() {
        return this.taskName + "_" + this.taskArgument;
    }

    public String getTaskID() {
        return this.taskID;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskArgument() {
        return this.taskArgument;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public YesnoEnum getPersistent() {
        return this.persistent;
    }

    public Runnable getTaskItem() {
        return this.taskItem;
    }

    public String toString() {
        return "TimedTaskWrapper [taskID=" + this.taskID + ", taskName=" + this.taskName + ", taskArgument=" + this.taskArgument + ", createTime=" + this.createTime + ", persistent=" + (Object)((Object)this.persistent) + ", taskItem=" + this.taskItem + "]";
    }
}

