/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security;

import com.ygsoft.abc.service.exception.AbcDigestException;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;

public class DigestCoder {
    private DigestCoder() {
    }

    private String byte2Hex(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer();
        String temp = null;
        for (int i = 0; i < bytes.length; ++i) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }

    private String digestByAlgorithm(InputStream inputStream, String algorithm) throws Exception {
        try (DigestInputStream dis = new DigestInputStream(inputStream, MessageDigest.getInstance(algorithm));){
            dis.on(true);
            byte[] b = new byte[1024];
            while (dis.read(b) != -1) {
            }
            byte[] digest = dis.getMessageDigest().digest();
            String string = this.byte2Hex(digest);
            return string;
        }
    }

    private String digestByAlgorithm(String inputStr, String algorithm) throws Exception {
        MessageDigest digest = MessageDigest.getInstance(algorithm);
        digest.update(inputStr.getBytes());
        byte[] digestByte = digest.digest();
        return this.byte2Hex(digestByte);
    }

    public static DigestCoder getInstance() {
        return InnerCls.digestCoder;
    }

    public String digestBySHA(InputStream inputStream) {
        PreconditionUtil.checkNotNull(inputStream, "\u53c2\u6570\u9519\u8bef\uff1ainputStream\u4e3anull\u3002");
        try {
            return this.digestByAlgorithm(inputStream, "SHA-256");
        }
        catch (Exception e) {
            throw new AbcDigestException("ABC.0034", EcpI18nUtil.localizedString((String)"DigestCoder_digestBySHA_118", (String)"\u751f\u6210\u6458\u8981\u5931\u8d25\u3002"));
        }
    }

    public String digestBySHA(String inputStr) {
        PreconditionUtil.checkNotTrimEmpty(inputStr, "\u53c2\u6570\u9519\u8bef\uff1ainputStr\u4e3a\u7a7a\u3002");
        try {
            return this.digestByAlgorithm(inputStr, "SHA-256");
        }
        catch (Exception e) {
            throw new AbcDigestException("ABC.0034", EcpI18nUtil.localizedString((String)"DigestCoder_digestBySHA_133", (String)"\u751f\u6210\u6458\u8981\u5931\u8d25\u3002"));
        }
    }

    public String digestByMD5(InputStream inputStream) {
        PreconditionUtil.checkNotNull(inputStream, "\u53c2\u6570\u9519\u8bef\uff1ainputStream\u4e3anull\u3002");
        try {
            return this.digestByAlgorithm(inputStream, "MD5");
        }
        catch (Exception e) {
            throw new AbcDigestException("ABC.0034", EcpI18nUtil.localizedString((String)"DigestCoder_digestByMD5_148", (String)"\u751f\u6210\u6458\u8981\u5931\u8d25\u3002"));
        }
    }

    public String digestByMD5(String inputStr) {
        PreconditionUtil.checkNotTrimEmpty(inputStr, "\u53c2\u6570\u9519\u8bef\uff1ainputStr\u4e3a\u7a7a\u3002");
        try {
            return this.digestByAlgorithm(inputStr, "MD5");
        }
        catch (Exception e) {
            throw new AbcDigestException("ABC.0034", EcpI18nUtil.localizedString((String)"DigestCoder_digestByMD5_163", (String)"\u751f\u6210\u6458\u8981\u5931\u8d25\u3002"));
        }
    }

    public static String signBySHA(String ... agr) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        Arrays.sort(agr);
        for (int i = 0; i < agr.length; ++i) {
            sb.append(agr[i]);
        }
        return DigestUtils.shaHex((byte[])sb.toString().getBytes("utf-8"));
    }

    public static void main(String[] args) throws Exception {
        System.out.println("--------------begin----------------");
        String dirPath = "D:/data/program";
        File dirFile = new File("D:/data/program");
        if (dirFile.isDirectory()) {
            List<String> suffixList = Arrays.asList("jar", "war");
            File[] childFiles = dirFile.listFiles((newDir, newName) -> suffixList.contains(newName.substring(newName.lastIndexOf(".") + 1)));
            ArrayList<String> resultList = new ArrayList<String>();
            System.out.println("--------------wait----------------");
            for (File f : childFiles) {
                String md5 = DigestCoder.getInstance().digestByMD5(new BufferedInputStream(new FileInputStream(f)));
                resultList.add(f.getName() + "-----------------" + md5);
            }
            try (PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter("D:/data/program" + File.separator + "digest_md5.log")));){
                resultList.forEach(result -> out.println((String)result));
            }
            System.out.println("success\uff0c\u6587\u4ef6\uff1aD:/data/program" + File.separator + "digest_md5.log");
        } else {
            System.out.println("error");
        }
    }

    private static class InnerCls {
        private static final String DIGEST_SHA = "SHA-256";
        private static final String DIGEST_MD5 = "MD5";
        private static final DigestCoder digestCoder = new DigestCoder();

        private InnerCls() {
        }
    }
}

