/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security;

import com.ygsoft.abc.service.exception.AbcIOException;
import com.ygsoft.abc.service.http.DelegatingServletInputStream;
import com.ygsoft.abc.service.tool.EncryDesUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;

public class SimpleSecurityRequestWrapper
extends HttpServletRequestWrapper {
    private static final IEcpLog LOG = EcpLogFactory.getLog(SimpleSecurityRequestWrapper.class);
    private HttpServletRequest request;
    private byte[] requestBody;

    public SimpleSecurityRequestWrapper(HttpServletRequest request) {
        super(request);
        this.request = request;
        this.readBody();
    }

    private void readBody() {
        ServletInputStream input = null;
        try {
            input = this.request.getInputStream();
            this.requestBody = IOUtils.toByteArray((InputStream)input);
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0014", "\u8bfb\u53d6\u8bf7\u6c42body\u5931\u8d25\u3002", e, new Object[0]);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        String data = new String(this.requestBody);
        if (LOG.isInfoEnabled()) {
            String msg = String.format("\u89e3\u5bc6\u524d\u6570\u636edata=%s", data);
            LOG.info((Object)msg);
        }
        String decodeData = EncryDesUtil.doDecodeByDefaultKey(data);
        if (LOG.isInfoEnabled()) {
            String msg = String.format("\u89e3\u5bc6\u540e\u6570\u636edata=%s", decodeData);
            LOG.info((Object)msg);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(decodeData.getBytes());
        return new DelegatingServletInputStream(byteArrayInputStream);
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }
}

