/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security.kit;

import com.google.common.collect.ImmutableMap;
import com.ygsoft.abc.service.security.kit.DigestKit;
import com.ygsoft.abc.service.security.kit.HexKit;
import com.ygsoft.abc.service.security.types.Base64ModeEnum;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import com.ygsoft.abc.service.tool.MonitorUtil;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.codec.binary.Base64;

public final class Base64Kit {
    static final IEcpLog LOG = EcpLogFactory.getLog(Base64Kit.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final Map<Base64ModeEnum, IBase64Coder> MAP = ImmutableMap.of((Object)((Object)Base64ModeEnum.STANDARD), (Object)new Base64Standard(), (Object)((Object)Base64ModeEnum.URL), (Object)new Base64Url(), (Object)((Object)Base64ModeEnum.MIME), (Object)new Base64Mime());
    private static final Base64Kit BASE64_STANDARD_KIT = new Base64Kit(Base64ModeEnum.STANDARD);
    private static final Base64Kit BASE64_URL_KIT = new Base64Kit(Base64ModeEnum.URL);
    private static final Base64Kit BASE64_MIME_KIT = new Base64Kit(Base64ModeEnum.MIME);
    private final Base64ModeEnum mode;

    private Base64Kit(Base64ModeEnum mode) {
        this.mode = mode;
    }

    public static Base64Kit standardMode() {
        return BASE64_STANDARD_KIT;
    }

    public static Base64Kit urlMode() {
        return BASE64_URL_KIT;
    }

    public static Base64Kit mimeMode() {
        return BASE64_MIME_KIT;
    }

    public static boolean isBase64(String base64String) {
        PreconditionUtil.checkNotTrimEmpty(base64String, "\u53c2\u6570\u9519\u8bef\uff1abase64String\u4e3a\u7a7a\u3002");
        return Base64.isBase64((String)base64String);
    }

    public String encodeFromString(String str) {
        return MAP.get((Object)this.mode).encodeFromString(str);
    }

    public String decodeToString(String str) {
        return MAP.get((Object)this.mode).decodeToString(str);
    }

    public String encode(byte[] bytes) {
        return MAP.get((Object)this.mode).encode(bytes);
    }

    public byte[] decode(String str) {
        return MAP.get((Object)this.mode).decode(str);
    }

    public static void main(String[] args) {
        String javaVersion = System.getProperty("java.version");
        System.out.println(javaVersion);
        String appid = "3bffd05d7a054a3ea8c1938e75f8ef17";
        String preid = "000EA93E068D00000000000000000000";
        System.out.println("appid\uff1a" + Base64Kit.standardMode().encodeFromString("3bffd05d7a054a3ea8c1938e75f8ef17"));
        System.out.println("preid\uff1a" + Base64Kit.standardMode().encodeFromString("000EA93E068D00000000000000000000"));
        String str = "abc\u662f\u5426\u554a\u554a\uff01\uff20\uff01\uff20\uff03\uff20\uff03\uffe5\uff03\uffe5\u5361\u770b\u5230\u4e86~!\u5361\u592b\u5361@#$%^&*(((\u770b\u770b\u770b;....";
        String encode1 = Base64Kit.standardMode().encodeFromString("abc\u662f\u5426\u554a\u554a\uff01\uff20\uff01\uff20\uff03\uff20\uff03\uffe5\uff03\uffe5\u5361\u770b\u5230\u4e86~!\u5361\u592b\u5361@#$%^&*(((\u770b\u770b\u770b;....");
        System.out.println("\u6807\u51c6\u7248\u7f16\u7801\u7f16\u7801\u540e\uff1a" + encode1);
        String decode1 = Base64Kit.standardMode().decodeToString(encode1);
        System.out.println("\u6807\u51c6\u7248\u7f16\u89e3\u7801\u540e\uff1a" + decode1);
        String encode2 = Base64Kit.urlMode().encode("abc\u662f\u5426\u554a\u554a\uff01\uff20\uff01\uff20\uff03\uff20\uff03\uffe5\uff03\uffe5\u5361\u770b\u5230\u4e86~!\u5361\u592b\u5361@#$%^&*(((\u770b\u770b\u770b;....".getBytes());
        System.out.println("url\u7248\u7f16\u7801\u7f16\u7801\u540e\uff1a" + encode2);
        byte[] decode2 = Base64Kit.urlMode().decode(encode2);
        System.out.println("url\u7248\u7f16\u89e3\u7801\u540e\uff1a" + new String(decode2));
        byte[] data = BlockIOUtil.readBytes("D:/data/Base64/file.pdf");
        byte[] md5 = DigestKit.md().hash(data);
        System.out.println(HexKit.getInstance().encode(md5));
        String base64Data = Base64Kit.standardMode().encode(data);
        BlockIOUtil.write(base64Data, "D:/data/Base64/str.txt");
        String text = BlockIOUtil.readText("D:/data/Base64/str.txt");
        byte[] dataRead = Base64Kit.standardMode().decode(text);
        byte[] md5Read = DigestKit.md().hash(dataRead);
        System.out.println(HexKit.getInstance().encode(md5Read));
        byte[] sha1 = DigestKit.sha().hash(dataRead);
        System.out.println(HexKit.getInstance().encode(sha1));
        byte[] sha2 = DigestKit.sha("SHA-256").hash(dataRead);
        System.out.println(HexKit.getInstance().encode(sha2));
    }

    static class Base64Mime
    implements IBase64Coder {
        Base64Mime() {
        }

        @Override
        public String encodeFromString(String str) {
            if (Objects.isNull(str)) {
                return null;
            }
            return this.encode(str.getBytes(UTF_8));
        }

        @Override
        public String decodeToString(String str) {
            if (Objects.isNull(str)) {
                return null;
            }
            byte[] data = this.decode(str);
            return new String(data, UTF_8);
        }

        @Override
        public String encode(byte[] bytes) {
            return java.util.Base64.getMimeEncoder().encodeToString(bytes);
        }

        @Override
        public byte[] decode(String str) {
            return java.util.Base64.getMimeDecoder().decode(str);
        }
    }

    static class Base64Url
    implements IBase64Coder {
        Base64Url() {
        }

        @Override
        public String encodeFromString(String str) {
            if (Objects.isNull(str)) {
                return null;
            }
            return this.encode(str.getBytes(UTF_8));
        }

        @Override
        public String decodeToString(String str) {
            if (Objects.isNull(str)) {
                return null;
            }
            byte[] data = this.decode(str);
            return new String(data, UTF_8);
        }

        @Override
        public String encode(byte[] bytes) {
            return java.util.Base64.getUrlEncoder().encodeToString(bytes);
        }

        @Override
        public byte[] decode(String str) {
            return java.util.Base64.getUrlDecoder().decode(str);
        }
    }

    static class Base64Standard
    implements IBase64Coder {
        static final String LINE_FEED = "\n";
        static final String EMPTY = "";

        Base64Standard() {
        }

        @Override
        public String encodeFromString(String str) {
            if (Objects.isNull(str)) {
                return null;
            }
            return this.encode(str.getBytes(UTF_8));
        }

        @Override
        public String decodeToString(String str) {
            if (Objects.isNull(str)) {
                return null;
            }
            byte[] data = this.decode(str);
            return new String(data, UTF_8);
        }

        @Override
        public String encode(byte[] bytes) {
            MonitorUtil util = MonitorUtil.getInstance(LOG);
            String data = Base64.encodeBase64String((byte[])bytes);
            util.monitor("Base64\u7f16\u7801\u8017\u65f6");
            return data;
        }

        @Override
        public byte[] decode(String str) {
            if (Objects.isNull(str)) {
                return null;
            }
            MonitorUtil util = MonitorUtil.getInstance(LOG);
            byte[] data = Base64.decodeBase64((String)str);
            util.monitor("Base64\u89e3\u7801\u8017\u65f6");
            return data;
        }
    }

    static interface IBase64Coder {
        public String encodeFromString(String var1);

        public String decodeToString(String var1);

        public String encode(byte[] var1);

        public byte[] decode(String var1);
    }
}

