/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security.kit;

import com.ygsoft.abc.service.domain.vo.Base64KeyPair;
import com.ygsoft.abc.service.exception.AbcCryptoException;
import com.ygsoft.abc.service.security.key.kit.KeyPairKit;
import com.ygsoft.abc.service.security.kit.Base64Kit;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;

public class RSAKit {
    private static final String RSA_ALGORITHM = "RSA";
    private static final RSAKit INSTANCE = new RSAKit();

    private RSAKit() {
    }

    public static RSAKit getInstance() {
        return INSTANCE;
    }

    public IRSACoder publicMode() {
        return new RSAPublicCoder();
    }

    public IRSACoder privateMode() {
        return new RSAPrivateCoder();
    }

    public static void main(String[] args) {
        KeyPair keyPair = KeyPairKit.rsa().generate();
        Base64KeyPair base64KeyPair = KeyPairKit.transfer(keyPair);
        System.out.println("\u79c1\u94a5\uff1a" + base64KeyPair.getPrivateKey());
        System.out.println("\u516c\u94a5\uff1a" + base64KeyPair.getPublicKey());
        String data = "\u6211\u7684\u4e16\u754c\u4e00\u5207\u90fd\u597d\u3002";
        byte[] encrypted = null;
        byte[] decrypted = null;
        encrypted = RSAKit.getInstance().publicMode().encrypt(data.getBytes(), Base64Kit.standardMode().decode(base64KeyPair.getPublicKey()));
        System.out.println("-----\u516c\u94a5\u52a0\u5bc6\u6570\u636e\uff1a" + Base64Kit.standardMode().encode(encrypted));
        decrypted = RSAKit.getInstance().privateMode().decrypt(encrypted, Base64Kit.standardMode().decode(base64KeyPair.getPrivateKey()));
        System.out.println("-----\u79c1\u94a5\u89e3\u5bc6\u6570\u636e\uff1a" + new String(decrypted));
        data = "\u9762\u671d\u5927\u6d77\uff0c\u6625\u6696\u82b1\u5f00\u3002";
        encrypted = RSAKit.getInstance().privateMode().encrypt(data.getBytes(), Base64Kit.standardMode().decode(base64KeyPair.getPrivateKey()));
        System.out.println("-----\u79c1\u94a5\u52a0\u5bc6\u6570\u636e\uff1a" + Base64Kit.standardMode().encode(encrypted));
        decrypted = RSAKit.getInstance().publicMode().decrypt(encrypted, Base64Kit.standardMode().decode(base64KeyPair.getPublicKey()));
        System.out.println("-----\u516c\u94a5\u89e3\u5bc6\u6570\u636e\uff1a" + new String(decrypted));
    }

    static class RSAPrivateCoder
    implements IRSACoder {
        RSAPrivateCoder() {
        }

        private PrivateKey restore(byte[] key) {
            try {
                PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(key);
                KeyFactory keyFactory = KeyFactory.getInstance(RSAKit.RSA_ALGORITHM);
                PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
                return privateKey;
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u6062\u590d\u79c1\u94a5\u5931\u8d25\u3002", e);
            }
        }

        @Override
        public byte[] decrypt(byte[] data, byte[] key) {
            try {
                PrivateKey privateKey = this.restore(key);
                KeyFactory keyFactory = KeyFactory.getInstance(RSAKit.RSA_ALGORITHM);
                Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
                cipher.init(2, privateKey);
                return cipher.doFinal(data);
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u79c1\u94a5\u89e3\u5bc6\u5931\u8d25\u3002", e);
            }
        }

        @Override
        public byte[] encrypt(byte[] data, byte[] key) {
            try {
                PrivateKey privateKey = this.restore(key);
                KeyFactory keyFactory = KeyFactory.getInstance(RSAKit.RSA_ALGORITHM);
                Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
                cipher.init(1, privateKey);
                return cipher.doFinal(data);
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u79c1\u94a5\u89e3\u5bc6\u5931\u8d25\u3002", e);
            }
        }
    }

    static class RSAPublicCoder
    implements IRSACoder {
        RSAPublicCoder() {
        }

        private PublicKey restore(byte[] key) {
            try {
                X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(key);
                KeyFactory keyFactory = KeyFactory.getInstance(RSAKit.RSA_ALGORITHM);
                PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
                return publicKey;
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u6062\u590d\u516c\u94a5\u5931\u8d25\u3002", e);
            }
        }

        @Override
        public byte[] decrypt(byte[] data, byte[] key) {
            try {
                PublicKey publicKey = this.restore(key);
                KeyFactory keyFactory = KeyFactory.getInstance(RSAKit.RSA_ALGORITHM);
                Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
                cipher.init(2, publicKey);
                return cipher.doFinal(data);
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u516c\u94a5\u89e3\u5bc6\u5931\u8d25\u3002", e);
            }
        }

        @Override
        public byte[] encrypt(byte[] data, byte[] key) {
            try {
                PublicKey publicKey = this.restore(key);
                KeyFactory keyFactory = KeyFactory.getInstance(RSAKit.RSA_ALGORITHM);
                Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
                cipher.init(1, publicKey);
                return cipher.doFinal(data);
            }
            catch (Exception e) {
                throw AbcCryptoException.newInstance("\u516c\u94a5\u52a0\u5bc6\u5931\u8d25\u3002", e);
            }
        }
    }

    static interface IRSACoder {
        public byte[] decrypt(byte[] var1, byte[] var2);

        public byte[] encrypt(byte[] var1, byte[] var2);
    }
}

