/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security.kit;

import cn.hutool.core.text.StrBuilder;
import cn.hutool.core.util.StrUtil;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.exception.CheckFailedException;
import com.ygsoft.abc.service.security.kit.SM2Encryptor;
import com.ygsoft.ecp.mapp.common.service.crypto.util.SignUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SM2TextEncryptUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(SM2TextEncryptUtil.class);

    public static String encryptSM2(String originalText) {
        String encryptedString = SM2Encryptor.encrypt(originalText);
        return encryptedString;
    }

    public static String decryptSM2(String cipherText) {
        String decryptedString = SM2Encryptor.decrypt(cipherText);
        return decryptedString;
    }

    public static <T> void encrypt(T desOneObj, boolean onlySM2, String ... fields) {
        if (ObjectUtils.isEmpty(desOneObj) || StringUtils.isEmpty((Object)fields)) {
            return;
        }
        Class<?> desCls = desOneObj.getClass();
        try {
            for (int i = 0; i < fields.length; ++i) {
                String fieldName = fields[i];
                Field field = desCls.getDeclaredField(fieldName);
                if (ObjectUtils.isEmpty((Object)field)) continue;
                field.setAccessible(true);
                Object value = field.get(desOneObj);
                if (ObjectUtils.isEmpty((Object)value) || !(value instanceof String)) continue;
                String strVal = String.valueOf(value);
                String cipherText = null;
                cipherText = onlySM2 ? SM2TextEncryptUtil.encryptSM2(strVal) : SM2TextEncryptUtil.encryptWithSM3(strVal);
                String curSetMethodName = new StringBuffer().append("set").append(field.getName().substring(0, 1).toUpperCase()).append(field.getName().substring(1)).toString();
                Method curPropertyMethod = desCls.getMethod(curSetMethodName, String.class);
                curPropertyMethod.setAccessible(true);
                curPropertyMethod.invoke(desOneObj, cipherText);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"\u5904\u7406\u6307\u5b9a\u5c5e\u6027\u503c\u5f02\u5e38\uff1a", (Throwable)ex);
            throw AbcServiceException.newInstance(ex.getMessage());
        }
    }

    public static <T> void decrypt(T desOneObj, boolean onlySM2, String ... fields) {
        if (ObjectUtils.isEmpty(desOneObj) || StringUtils.isEmpty((Object)fields)) {
            return;
        }
        Class<?> desCls = desOneObj.getClass();
        try {
            for (int i = 0; i < fields.length; ++i) {
                String fieldName = fields[i];
                Field field = desCls.getDeclaredField(fieldName);
                if (ObjectUtils.isEmpty((Object)field)) continue;
                field.setAccessible(true);
                Object value = field.get(desOneObj);
                if (ObjectUtils.isEmpty((Object)value) || !(value instanceof String)) continue;
                String cipherText = String.valueOf(value);
                String originalText = null;
                originalText = onlySM2 ? SM2TextEncryptUtil.decryptSM2(cipherText) : SM2TextEncryptUtil.decryptWithSM3(cipherText);
                String curSetMethodName = new StringBuffer().append("set").append(field.getName().substring(0, 1).toUpperCase()).append(field.getName().substring(1)).toString();
                Method curPropertyMethod = desCls.getMethod(curSetMethodName, String.class);
                curPropertyMethod.setAccessible(true);
                curPropertyMethod.invoke(desOneObj, originalText);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"\u5904\u7406\u6307\u5b9a\u5c5e\u6027\u503c\u5f02\u5e38\uff1a", (Throwable)ex);
            throw AbcServiceException.newInstance(ex.getMessage());
        }
    }

    public static <T> void encrypt(List<T> listDesObj, boolean onlySM2, String ... fields) {
        if (CollectionUtils.isEmpty(listDesObj) || StringUtils.isEmpty((Object)fields)) {
            return;
        }
        listDesObj.forEach(desOneObj -> SM2TextEncryptUtil.encrypt(desOneObj, onlySM2, fields));
    }

    public static <T> void decrypt(List<T> listDesObj, boolean onlySM2, String ... fields) {
        if (CollectionUtils.isEmpty(listDesObj) || StringUtils.isEmpty((Object)fields)) {
            return;
        }
        listDesObj.forEach(desOneObj -> SM2TextEncryptUtil.decrypt(desOneObj, onlySM2, fields));
    }

    public static <T> Page encrypt(Page<T> pageDesObj, Pageable pageable, boolean onlySM2, String ... fields) {
        if (ObjectUtils.isEmpty(pageDesObj) || CollectionUtils.isEmpty((Collection)pageDesObj.getContent())) {
            return pageDesObj;
        }
        List listDesObj = pageDesObj.getContent();
        listDesObj.forEach(desOneObj -> SM2TextEncryptUtil.encrypt(desOneObj, onlySM2, fields));
        PageImpl pageResult = new PageImpl(listDesObj, pageable, pageDesObj.getTotalElements());
        return pageResult;
    }

    public static String encryptWithSM3(String originalText) {
        String result = originalText;
        if (!StringUtils.isEmpty((Object)originalText)) {
            String sm2 = SM2TextEncryptUtil.encryptSM2(originalText);
            String sm3Hash = SignUtil.doSm3Hash((String)originalText);
            String sm2sm3 = SM2TextEncryptUtil.encryptSM2(sm3Hash);
            result = StrBuilder.create((CharSequence[])new CharSequence[]{sm2sm3}).append((CharSequence)"&").append((CharSequence)sm2).toString();
        }
        return result;
    }

    public static String decryptWithSM3(String cipherText) {
        String result = cipherText;
        LOG.info((Object)("SM2\u9644\u5e26SM3\u89e3\u5bc6==>" + cipherText));
        if (!StringUtils.isEmpty((Object)cipherText)) {
            String doSm3Hash;
            String[] split = cipherText.split("\\*");
            String original = StrUtil.utf8Str((Object)SM2TextEncryptUtil.decryptSM2(split[1]));
            if (StringUtils.isEmpty((Object)original)) {
                LOG.error((Object)" SM2\u9644\u5e26SM3\u5bc6\u6587\u6d88\u606f&\u540e\u9762\u7684SM2\u5bc6\u6587\u7f3a\u5931");
                throw CheckFailedException.newInstance("\u4f20\u5165\u53c2\u6570\u6709\u8bef\uff0c\u89e3\u5bc6\u540e\u4e3a\u7a7a");
            }
            String utf8StrSM3 = StrUtil.utf8Str((Object)SM2TextEncryptUtil.decryptSM2(split[0]));
            if (utf8StrSM3.equals(doSm3Hash = SignUtil.doSm3Hash((String)original))) {
                result = original;
            } else {
                throw CheckFailedException.newInstance("\u5b8c\u6574\u6027\u6821\u9a8c\u4e0d\u901a\u8fc7\u3002");
            }
        }
        return result;
    }
}

