/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security.kit;

import com.ygsoft.abc.service.exception.AbcCryptoException;
import com.ygsoft.abc.service.security.kit.Base64Kit;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SM4Kit {
    private static final String SM4 = "SM4";
    private static final String SM4_ALGORITHM = "SM4/ECB/PKCS7Padding";
    private static final int KEY_SIZE = 128;
    private static final SM4Kit INSTANCE;

    public static SM4Kit getInstance() {
        return INSTANCE;
    }

    public SecretKey generateKey() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(SM4, "BC");
            keyGenerator.init(128);
            return keyGenerator.generateKey();
        }
        catch (Exception e) {
            throw AbcCryptoException.newInstance("\u52a0\u7b7e\u5931\u8d25\u3002", e);
        }
    }

    public SecretKey generateKey(String password) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(SM4, "BC");
            keyGenerator.init(128, new SecureRandom(password.getBytes()));
            return keyGenerator.generateKey();
        }
        catch (Exception e) {
            throw AbcCryptoException.newInstance("\u52a0\u7b7e\u5931\u8d25\u3002", e);
        }
    }

    private Cipher initCipher(int mode, byte[] key) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            Cipher cipher = Cipher.getInstance(SM4_ALGORITHM, "BC");
            SecretKeySpec sm4Key = new SecretKeySpec(key, SM4);
            cipher.init(mode, sm4Key);
            return cipher;
        }
        catch (Exception e) {
            throw AbcCryptoException.newInstance("\u52a0\u7b7e\u5931\u8d25\u3002", e);
        }
    }

    public byte[] encrypt(byte[] data, byte[] key) {
        try {
            Cipher cipher = this.initCipher(1, key);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw AbcCryptoException.newInstance("\u52a0\u5bc6\u5931\u8d25\u3002", e);
        }
    }

    public byte[] decrypt(byte[] data, byte[] key) {
        try {
            Cipher cipher = this.initCipher(2, key);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw AbcCryptoException.newInstance("\u89e3\u5bc6\u5931\u8d25\u3002", e);
        }
    }

    public static void main(String[] args) throws Exception {
        String data = "\u620d\u9f13\u65ad\u4eba\u884c\uff0c\u8fb9\u79cb\u4e00\u96c1\u58f0\u3002\u9732\u4ece\u4eca\u591c\u767d\uff0c\u6708\u662f\u6545\u4e61\u660e\u3002\u6709\u5f1f\u7686\u5206\u6563\uff0c\u65e0\u5bb6\u95ee\u6b7b\u751f\u3002\u5bc4\u4e66\u957f\u4e0d\u8fbe\uff0c\u51b5\u4e43\u672a\u4f11\u5175\u3002";
        SecretKey secretKey = SM4Kit.getInstance().generateKey();
        byte[] keyBytes = secretKey.getEncoded();
        System.out.println("\u751f\u6210\u79d8\u94a5\uff1a" + Base64Kit.standardMode().encode(keyBytes));
        byte[] encrypted = SM4Kit.getInstance().encrypt(data.getBytes(), keyBytes);
        System.out.println("\u52a0\u5bc6\u6570\u636e\uff1a" + Base64Kit.standardMode().encode(encrypted));
        byte[] decrypted = SM4Kit.getInstance().decrypt(encrypted, keyBytes);
        System.out.println("\u89e3\u5bc6\u6570\u636e\uff1a" + new String(decrypted));
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
        INSTANCE = new SM4Kit();
    }
}

