/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.sensitive.util;

import cn.hutool.core.util.ReflectUtil;
import com.ygsoft.abc.service.sensitive.annotation.TransferEncryptData;
import com.ygsoft.abc.service.sensitive.strategy.ITransferEncryptStrategy;
import com.ygsoft.abc.service.sensitive.strategy.SM4CBCTransferEncryptStrategy;
import com.ygsoft.abc.service.sensitive.strategy.SM4TransferEncryptStrategy;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class TransferEncryptCover {
    static final IEcpLog LOG = EcpLogFactory.getLog(TransferEncryptCover.class);
    private static final Map<Class<?>, ITransferEncryptStrategy> STRATEGY_MAP = new HashMap();

    private TransferEncryptCover() {
    }

    public static <T> T makeEncrypt(T t) {
        Field[] declaredFields;
        if (null == t) {
            return null;
        }
        for (Field field : declaredFields = t.getClass().getDeclaredFields()) {
            Object fieldValue;
            if (!field.isAnnotationPresent(TransferEncryptData.class) || null == (fieldValue = ReflectUtil.getFieldValue(t, (Field)field))) continue;
            TransferEncryptData annotation = field.getAnnotation(TransferEncryptData.class);
            Class<? extends ITransferEncryptStrategy> strategy = annotation.strategy();
            ITransferEncryptStrategy transferEncryptStrategy = STRATEGY_MAP.get(strategy);
            if (null == transferEncryptStrategy) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)String.format("%s\u7684%s\u5b57\u6bb5\u672a\u627e\u5230\u5bf9\u5e94\u7684\u52a0\u5bc6\u7b56\u7565", t.getClass().getName(), field.getName()));
                continue;
            }
            String encrypt = transferEncryptStrategy.encrypt((String)fieldValue);
            ReflectUtil.setFieldValue(t, (Field)field, (Object)encrypt);
        }
        return t;
    }

    public static <T> T makeDecrypt(T t) {
        Field[] declaredFields;
        if (null == t) {
            return null;
        }
        for (Field field : declaredFields = t.getClass().getDeclaredFields()) {
            Object fieldValue;
            if (!field.isAnnotationPresent(TransferEncryptData.class) || null == (fieldValue = ReflectUtil.getFieldValue(t, (Field)field))) continue;
            TransferEncryptData annotation = field.getAnnotation(TransferEncryptData.class);
            Class<? extends ITransferEncryptStrategy> strategy = annotation.strategy();
            ITransferEncryptStrategy transferEncryptStrategy = STRATEGY_MAP.get(strategy);
            if (null == transferEncryptStrategy) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)String.format("%s\u7684%s\u5b57\u6bb5\u672a\u627e\u5230\u5bf9\u5e94\u7684\u52a0\u5bc6\u7b56\u7565", t.getClass().getName(), field.getName()));
                continue;
            }
            if (!(fieldValue instanceof String)) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)String.format("%s\u7684%s\u5b57\u6bb5\u4e0d\u662fString\u7c7b\u578b", t.getClass().getName(), field.getName()));
                continue;
            }
            String fieldValueStr = (String)fieldValue;
            if (!transferEncryptStrategy.checkIsEncrypt(fieldValueStr).booleanValue()) continue;
            String encrypt = transferEncryptStrategy.decrypt(fieldValueStr);
            ReflectUtil.setFieldValue(t, (Field)field, (Object)encrypt);
        }
        return t;
    }

    static {
        STRATEGY_MAP.put(SM4CBCTransferEncryptStrategy.class, new SM4CBCTransferEncryptStrategy());
        STRATEGY_MAP.put(SM4TransferEncryptStrategy.class, new SM4TransferEncryptStrategy());
    }
}

