/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.types.DestinationType;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.OSGiUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.Objects;
import org.springframework.jms.core.JmsTemplate;

public final class ActiveMQUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ActiveMQUtil.class);

    public static final void sendMessageToQueue(String destStr, String message) {
        ActiveMQUtil.sendMessage(destStr, message, DestinationType.QUEUE);
    }

    public static final void sendMessageToTopic(String destStr, String message) {
        ActiveMQUtil.sendMessage(destStr, message, DestinationType.TOPIC);
    }

    public static final void sendMessage(String destStr, String message, DestinationType destType) {
        if (StringUtil.isNullOrTrimEmptyString((String)destStr)) {
            String msg = EcpI18nUtil.localizedString((String)"ActiveMQUtil_sendMessage_72", (String)"\u53c2\u6570\u9519\u8bef\uff1a\u76ee\u7684\u5730destStr\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (null == message) {
            String msg = EcpI18nUtil.localizedString((String)"ActiveMQUtil_sendMessage_76", (String)"\u53c2\u6570\u9519\u8bef\uff1a\u4fe1\u606fmessage\u4e3anull\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        JmsTemplate jmsTemplate = ActiveMQUtil.getJmsTemplate(destType);
        jmsTemplate.convertAndSend(destStr, (Object)message);
        String desc = "destStr=" + destStr + ",message=" + message;
        ActiveMQUtil.logInfo("\u6210\u529f\u53d1MQ\u6d88\u606f---" + desc);
    }

    private static JmsTemplate getJmsTemplate(DestinationType destType) {
        if (destType.isQueue()) {
            JmsTemplate jmsTemplate = (JmsTemplate)OSGiUtil.getSpringBean((String)"jmsQueueTemplate");
            if (!Objects.isNull(jmsTemplate)) {
                return jmsTemplate;
            }
            return (JmsTemplate)OSGiUtil.getSpringBean((String)"jmsTemplate");
        }
        return (JmsTemplate)OSGiUtil.getSpringBean((String)"jmsTopicTemplate");
    }

    private static void logInfo(Object obj) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\n>>>" + obj));
        }
    }
}

