/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BadWordUtil {
    private static final Logger LOG;
    private static final String COVER = "**";
    private static final String BAD_WORDS_PATH = "classpath:/META-INF/sensitiveWord/bad-words.dict";
    private static final Set<String> words;
    public static final String SENSITIVE_WORD_KEY = "abc.intercept.sensitive.enable";
    public static final String SENSITIVE_WORD_DYNAMIC_CLOSE = "abc.sensitive.close";
    public static final String TRUE = "true";
    private static final Map<String, String> wordMap;

    public static List<String> read() {
        return BlockIOUtil.readLines(BAD_WORDS_PATH, true);
    }

    public static void refresh(List<String> list) {
        words.clear();
        words.addAll(list);
        BadWordUtil.addBadWordToHashMap();
    }

    public static String replace(String text) {
        if (StringUtil.isNullOrTrimEmptyString((String)text)) {
            return text;
        }
        Set<String> badWords = BadWordUtil.getBadWord(text);
        if (BlockCollectionUtil.isEmpty(badWords)) {
            return text;
        }
        return text.replaceAll(BadWordUtil.buildRegex(badWords), COVER);
    }

    private static String buildRegex(Set<String> badWords) {
        StringBuilder sb = new StringBuilder();
        for (String word : badWords) {
            sb.append("(" + word + ")|");
        }
        return sb.substring(0, sb.length() - 1);
    }

    private static void initBadWords() {
        words.addAll(BlockIOUtil.readLines(BAD_WORDS_PATH, true));
    }

    public static int getWordSize() {
        return words.size();
    }

    public static int checkBadWord(String txt, int beginIndex, MatchType matchType) {
        boolean flag = false;
        int matchFlag = 0;
        char word = '\u0000';
        Map nowMap = wordMap;
        for (int i = beginIndex; i < txt.length() && (nowMap = (Map)((Object)nowMap.get(Character.valueOf(word = txt.charAt(i))))) != null; ++i) {
            ++matchFlag;
            if (!"1".equals(nowMap.get("isEnd"))) continue;
            flag = true;
            if (MatchType.MIN == matchType) break;
        }
        if (!flag) {
            matchFlag = 0;
        }
        return matchFlag;
    }

    public static boolean isContainsBadWord(String txt) {
        if (!BadWordUtil.isInterceptSensitive()) {
            return false;
        }
        if (StringUtil.isNullOrTrimEmptyString((String)txt)) {
            return false;
        }
        Set<String> words = BadWordUtil.getBadWord(txt);
        if (BlockCollectionUtil.isEmpty(words)) {
            return false;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("\u6587\u672c:" + txt + "\uff0c\u68c0\u6d4b\u5230\u654f\u611f\u8bcd:" + words);
        }
        return true;
    }

    public static boolean containsBadWord(String txt) {
        return BadWordUtil.containsBadWord(txt, MatchType.MIN);
    }

    public static boolean containsBadWord(String txt, MatchType matchType) {
        boolean flag = false;
        if (!TRUE.equals(System.getProperty(SENSITIVE_WORD_DYNAMIC_CLOSE))) {
            for (int i = 0; i < txt.length(); ++i) {
                int matchFlag = BadWordUtil.checkBadWord(txt, i, matchType);
                if (matchFlag <= 0) continue;
                flag = true;
            }
        }
        return flag;
    }

    public static String replaceBadWord(String txt, String replaceChar) {
        return BadWordUtil.replaceBadWord(txt, MatchType.MIN, replaceChar);
    }

    public static String replaceBadWord(String txt, MatchType matchType, String replaceChar) {
        String resultTxt = txt;
        Set<String> set = BadWordUtil.getBadWord(txt, matchType);
        Iterator<String> iterator = set.iterator();
        String word = null;
        String replaceString = null;
        while (iterator.hasNext()) {
            word = iterator.next();
            replaceString = BadWordUtil.getReplaceChars(replaceChar, word.length());
            resultTxt = resultTxt.replaceAll(word, replaceString);
        }
        return resultTxt;
    }

    public static Set<String> getBadWord(String txt) {
        return BadWordUtil.getBadWord(txt, MatchType.MIN);
    }

    public static Set<String> getBadWord(String txt, MatchType matchType) {
        HashSet<String> sensitiveWordList = new HashSet<String>();
        for (int i = 0; i < txt.length(); ++i) {
            int length = BadWordUtil.checkBadWord(txt, i, matchType);
            if (length <= 0) continue;
            sensitiveWordList.add(txt.substring(i, i + length));
            i = i + length - 1;
        }
        return sensitiveWordList;
    }

    private static String getReplaceChars(String replaceChar, int length) {
        String resultReplace = replaceChar;
        for (int i = 1; i < length; ++i) {
            resultReplace = resultReplace + replaceChar;
        }
        return resultReplace;
    }

    private static void addBadWordToHashMap() {
        String key2 = null;
        HashMap<Object, Object> nowMap = null;
        HashMap<Object, Object> newWorMap = null;
        for (String key2 : words) {
            nowMap = wordMap;
            for (int i = 0; i < key2.length(); ++i) {
                char keyChar = key2.charAt(i);
                String wordMap = nowMap.get(Character.valueOf(keyChar));
                if (wordMap != null) {
                    nowMap = (HashMap<Object, Object>)((Object)wordMap);
                } else {
                    newWorMap = new HashMap<Object, Object>();
                    newWorMap.put("isEnd", "0");
                    nowMap.put(Character.valueOf(keyChar), newWorMap);
                    nowMap = newWorMap;
                }
                if (i != key2.length() - 1) continue;
                nowMap.put("isEnd", "1");
            }
        }
    }

    public static boolean isInterceptSensitive() {
        String value = PropertyConfigUtil.getProperty(SENSITIVE_WORD_KEY);
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return true;
        }
        return TRUE.equalsIgnoreCase(value);
    }

    static {
        block2: {
            LOG = LoggerFactory.getLogger(BadWordUtil.class);
            words = new HashSet<String>(8192);
            wordMap = new HashMap<String, String>(8192);
            try {
                BadWordUtil.initBadWords();
                BadWordUtil.addBadWordToHashMap();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block2;
                LOG.error("\u654f\u611f\u8bcd\u5de5\u5177\u7c7b\u521d\u59cb\u5316\u5931\u8d25\u3002", (Throwable)e);
            }
        }
    }

    public static enum MatchType {
        MIN,
        MAX;

    }
}

