/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.tool.BlockReflectUtil;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.ecp.core.framework.model.DynamicEntityVO;
import com.ygsoft.ecp.service.entity.DynamicEntity;
import com.ygsoft.ecp.service.exception.EcpCheckException;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class BlockCollectionUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(BlockCollectionUtil.class);

    public static boolean isEmpty(Collection<?> set) {
        return set == null || set.isEmpty();
    }

    public static boolean isEmptyOrWithEmptyString(Collection<String> set) {
        if (BlockCollectionUtil.isEmpty(set)) {
            return true;
        }
        long emptySize = set.stream().filter(ele -> StringUtil.isNullOrTrimEmptyString((String)ele)).count();
        return emptySize > 0L;
    }

    public static boolean isEmptyOrWithNull(Collection<?> set) {
        if (BlockCollectionUtil.isEmpty(set)) {
            return true;
        }
        long emptySize = set.stream().filter(ele -> Objects.isNull(ele)).count();
        return emptySize > 0L;
    }

    public static boolean isNotEmpty(Collection<?> set) {
        return !BlockCollectionUtil.isEmpty(set);
    }

    public static boolean isNotEmptyAndWithoutEmptyString(Collection<String> set) {
        if (BlockCollectionUtil.isEmpty(set)) {
            return false;
        }
        long emptySize = set.stream().filter(ele -> StringUtil.isNullOrTrimEmptyString((String)ele)).count();
        return emptySize == 0L;
    }

    public static boolean isNotEmptyAndWithoutNull(Collection<?> set) {
        if (BlockCollectionUtil.isEmpty(set)) {
            return false;
        }
        long emptySize = set.stream().filter(ele -> Objects.isNull(ele)).count();
        return emptySize == 0L;
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static int getSize(Collection<?> colls) {
        if (colls == null) {
            return 0;
        }
        return colls.size();
    }

    public static String[] addAndDistinct(String[] oldArray, String[] addElements) {
        String val;
        int i;
        HashSet<String> set = new HashSet<String>();
        int j = oldArray.length;
        for (i = 0; i < j; ++i) {
            val = oldArray[i].trim().toUpperCase();
            set.add(val);
        }
        j = addElements.length;
        for (i = 0; i < j; ++i) {
            val = addElements[i].trim().toUpperCase();
            set.add(val);
        }
        return BlockCollectionUtil.toArray(set);
    }

    public static List removeRepeat(List data) {
        List list = null;
        if (data != null) {
            HashSet set = new HashSet();
            set.addAll(data);
            list = BlockCollectionUtil.set2List(set);
        }
        return list;
    }

    public static List set2List(Set<?> set) {
        ArrayList list = null;
        if (set != null) {
            list = new ArrayList();
            list.addAll(set);
        }
        return list;
    }

    public static List<String> removeRepeatElement(List<String> repeatList) {
        ArrayList list = null;
        if (repeatList != null) {
            list = new ArrayList();
            HashSet<String> set = new HashSet<String>();
            for (String str : repeatList) {
                set.add(str);
            }
            list.addAll(set);
        }
        return list;
    }

    public static List<List<String>> spliceAry(String[] ary, int subSize) {
        int count = ary.length % subSize == 0 ? ary.length / subSize : ary.length / subSize + 1;
        ArrayList<List<String>> subAryList = new ArrayList<List<String>>();
        for (int i = 0; i < count; ++i) {
            int index = i * subSize;
            ArrayList<String> list = new ArrayList<String>();
            for (int j = 0; j < subSize && index < ary.length; ++j) {
                list.add(ary[index++]);
            }
            subAryList.add(list);
        }
        return subAryList;
    }

    public static List pageList(List data, int currentPageNum, int pageSize) {
        List pagedList = data;
        if (data != null && data.size() > 0 && data.size() > pageSize) {
            int fromIndex = (currentPageNum - 1) * pageSize;
            int toIndex = currentPageNum * pageSize;
            pagedList = data.subList(fromIndex, toIndex);
        }
        return pagedList;
    }

    public static String[] toArray(Collection<String> co) {
        String[] arr = new String[co.size()];
        int i = 0;
        Iterator<String> iterator = co.iterator();
        while (iterator.hasNext()) {
            String o;
            arr[i] = o = iterator.next();
            ++i;
        }
        return arr;
    }

    public static List<String> addAll(String[] arr) {
        ArrayList<String> list = null;
        if (arr != null && arr.length > 0) {
            list = new ArrayList<String>(arr.length);
            for (String str : arr) {
                list.add(str);
            }
        }
        return list;
    }

    public static List<String> trans2String(List<Integer> list) {
        ArrayList<String> strList = null;
        if (list != null) {
            strList = new ArrayList<String>(list.size());
            for (Integer i : list) {
                strList.add(String.valueOf(i));
            }
        }
        return strList;
    }

    public static Map<String, Object> toMap(List list, String keyField) {
        HashMap map = null;
        if (list != null && !StringUtil.isNullOrTrimEmptyString((String)keyField)) {
            map = new HashMap();
            for (Object object : list) {
                Object keyVal = BlockReflectUtil.invokeGetMethod(keyField, object);
                if (keyVal == null) continue;
                String key = keyVal.toString();
                map.put(key, object);
            }
        }
        return map;
    }

    public static Map<String, DynamicEntityVO> voList2Map(List<DynamicEntityVO> list, String keyField) {
        if (list == null) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockCollectionUtil_voList2Map_269", (String)"\u53c2\u6570\u9519\u8bef\uff1alist\u4e3anull\u3002"));
        }
        HashMap<String, DynamicEntityVO> map = new HashMap<String, DynamicEntityVO>(list.size());
        for (DynamicEntityVO vo : list) {
            String key = CastUtil.getString(vo.get(keyField));
            map.put(key, vo);
        }
        return map;
    }

    public static Map<String, DynamicEntity> poList2Map(List<DynamicEntity> list, String keyField) {
        if (list == null) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockCollectionUtil_poList2Map_289", (String)"\u53c2\u6570\u9519\u8bef\uff1alist\u4e3anull\u3002"));
        }
        HashMap<String, DynamicEntity> map = new HashMap<String, DynamicEntity>(list.size());
        for (DynamicEntity po : list) {
            String key = CastUtil.getString(po.get(keyField));
            map.put(key, po);
        }
        return map;
    }

    public static BigDecimal getBigDecimal(Map map, String fieldName) {
        Object obj = map.get(fieldName);
        BigDecimal val = BlockCollectionUtil.getBigDecimal(obj);
        return val;
    }

    public static BigDecimal getBigDecimal(Object obj) {
        BigDecimal val = null;
        if (obj == null) {
            val = new BigDecimal(0);
        } else if (obj instanceof BigDecimal) {
            val = (BigDecimal)obj;
        } else if (obj instanceof Integer) {
            val = new BigDecimal((Integer)obj);
        } else {
            try {
                val = new BigDecimal(obj.toString());
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e);
                }
                throw new EcpRuntimeException("573023", EcpI18nUtil.localizedString((String)"BlockCollectionUtil_getBigDecimal_333", (String)"\u83b7\u53d6BigDecimal\u5931\u8d25\uff0c\u8be5\u5b57\u6bb5\u7c7b\u578b\u975eBigDecimal\u3001Integer\uff0c\u4e5f\u65e0\u6cd5\u901a\u8fc7toString()\u83b7\u53d6\u6570\u5b57\u3002"), (Throwable)e, new Object[0]);
            }
        }
        return val;
    }

    public static String join(String[] items, String splitter) {
        if (items == null || items.length == 0) {
            return null;
        }
        if (StringUtil.isEmptyString((String)splitter)) {
            splitter = ",";
        }
        StringBuffer sb = new StringBuffer();
        int j = items.length;
        for (int i = 0; i < j; ++i) {
            sb.append(items[i]).append(splitter);
        }
        return sb.substring(0, sb.length() - splitter.length());
    }

    public static Integer getInteger(Map map, String fieldName) {
        Object obj = map.get(fieldName);
        Integer val = null;
        if (obj == null) {
            val = 0;
        } else if (obj instanceof Integer) {
            val = (Integer)obj;
        } else if (obj instanceof BigDecimal) {
            val = ((BigDecimal)obj).intValue();
        } else {
            try {
                val = Integer.parseInt(obj.toString());
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e);
                }
                throw new EcpRuntimeException("573023", fieldName + EcpI18nUtil.localizedString((String)"BlockCollectionUtil_getInteger_384", (String)"\u83b7\u53d6\u5931\u8d25\uff0c\u8be5\u5b57\u6bb5\u7c7b\u578b\u975eBigDecimal\u3001Integer\uff0c\u4e5f\u65e0\u6cd5\u901a\u8fc7toString()\u83b7\u53d6\u6570\u5b57\u3002"), (Throwable)e, new Object[0]);
            }
        }
        return val;
    }

    public static Boolean getBoolean(Map map, String fieldName) {
        Object obj = map.get(fieldName);
        Boolean val = null;
        if (obj == null) {
            val = false;
        } else if (obj instanceof Boolean) {
            val = (Boolean)obj;
        } else {
            throw new EcpRuntimeException("573023", fieldName + EcpI18nUtil.localizedString((String)"BlockCollectionUtil_getBoolean_404", (String)"\u83b7\u53d6\u5931\u8d25\uff0c\u8be5\u5b57\u6bb5\u7c7b\u578b\u975eBoolean\u7c7b\u578b\u3002"));
        }
        return val;
    }

    public static String getString(Map map, String fieldName) {
        String val;
        Object obj = map.get(fieldName);
        if (obj == null) {
            val = null;
        } else if (obj instanceof Integer) {
            val = String.valueOf(obj);
        } else if (obj instanceof BigDecimal) {
            val = ((BigDecimal)obj).toPlainString();
        } else {
            try {
                val = obj.toString();
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e);
                }
                throw new EcpRuntimeException("573023", fieldName + EcpI18nUtil.localizedString((String)"BlockCollectionUtil_getString_431", (String)"\u83b7\u53d6\u5931\u8d25\uff0c\u8be5\u5b57\u6bb5\u7c7b\u578b\u975eBigDecimal\u3001Integer\uff0c\u4e5f\u65e0\u6cd5\u901a\u8fc7toString()\u83b7\u53d6\u5b57\u7b26\u4e32\u3002"), (Throwable)e, new Object[0]);
            }
        }
        return val;
    }

    public static String join(Collection<?> items) {
        return BlockCollectionUtil.join(items, ",");
    }

    public static String join(Collection<?> items, String splitter) {
        if (items == null || items.size() == 0) {
            return null;
        }
        if (StringUtil.isEmptyString((String)splitter)) {
            splitter = ",";
        }
        StringBuffer sb = new StringBuffer();
        Iterator<?> iter = items.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString()).append(splitter);
        }
        return sb.substring(0, sb.length() - splitter.length());
    }

    public static String joinInteger(List<Integer> items, String splitter) {
        if (items == null || items.size() == 0) {
            return null;
        }
        if (StringUtil.isEmptyString((String)splitter)) {
            splitter = ",";
        }
        StringBuffer sb = new StringBuffer();
        for (Integer item : items) {
            sb.append(item.toString()).append(splitter);
        }
        return sb.substring(0, sb.length() - splitter.length());
    }

    public static String joinString(Collection<String> items, String splitter) {
        if (items == null || items.size() == 0) {
            return null;
        }
        if (StringUtil.isEmptyString((String)splitter)) {
            splitter = ",";
        }
        StringBuffer sb = new StringBuffer();
        for (String item : items) {
            sb.append(item).append(splitter);
        }
        return sb.substring(0, sb.length() - splitter.length());
    }

    public static List<String> filterBlank(Collection<String> coll) {
        if (null == coll) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockCollectionUtil_filterBlank_497", (String)"\u53c2\u6570\u9519\u8bef\uff1acoll\u4e3anull\u3002"));
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String str : coll) {
            if (StringUtil.isNullOrTrimEmptyString((String)str)) continue;
            list.add(str.trim());
        }
        return list;
    }

    public static List<String> filterBlankRepeat(Collection<String> coll) {
        if (null == coll) {
            throw new EcpCheckException("", EcpI18nUtil.localizedString((String)"BlockCollectionUtil_filterBlankRepeat_517", (String)"\u53c2\u6570\u9519\u8bef\uff1acoll\u4e3anull\u3002"));
        }
        HashSet set = new HashSet(coll.size());
        coll.forEach(element -> {
            if (!StringUtil.isNullOrTrimEmptyString((String)element)) {
                set.add(element);
            }
        });
        return new ArrayList<String>(set);
    }

    public static List<Integer> element2Int(List<String> list, boolean blank2Zero) {
        ArrayList<Integer> rst = new ArrayList<Integer>();
        if (list == null || list.isEmpty()) {
            return rst;
        }
        for (String s : list) {
            if (StringUtil.isNullOrTrimEmptyString((String)s)) {
                if (blank2Zero) {
                    rst.add(0);
                    continue;
                }
                throw new EcpRuntimeException("", EcpI18nUtil.localizedString((String)"BlockCollectionUtil_element2Int_547", (String)"\u6570\u636e\u9519\u8bef\uff1a\u7a7a\u503c\u65e0\u6cd5\u8f6c\u6362\u6210\u6570\u5b57\u3002"));
            }
            rst.add(CastUtil.getInteger(s));
        }
        return rst;
    }

    public static List<String> splitFilterBlank(String str) {
        if (StringUtil.isNullOrTrimEmptyString((String)str)) {
            String msg = EcpI18nUtil.localizedString((String)"BlockCollectionUtil_splitFilterBlank_564", (String)"\u53c2\u6570\u9519\u8bef\uff1astr\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", msg);
        }
        List<String> list = Arrays.asList(str.split(","));
        return list.stream().filter(element -> !StringUtil.isNullOrTrimEmptyString((String)element)).collect(Collectors.toList());
    }

    public static <T> ArrayList<T> newArrayListInstance() {
        return new ArrayList();
    }

    public static <T> LinkedList<T> newLinkedListInstance() {
        return new LinkedList();
    }

    public static <K, V> HashMap<K, V> newHashMapInstance() {
        return new HashMap();
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMapInstance() {
        return new ConcurrentHashMap();
    }

    public static <K, V> TreeMap<K, V> newTreeMapInstance() {
        return new TreeMap();
    }
}

