/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.CheckFailedException;
import com.ygsoft.abc.service.tool.BlockDateUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class BlockDateTimeUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(BlockDateUtil.class);
    public static final String MILL_DATETIME_PATTERN1 = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String MILL_DATETIME_PATTERN2 = "yyyy/MM/dd HH:mm:ss.SSS";
    public static final String MILL_DATETIME_PATTERN3 = "yyyyMMddHHmmssSSS";
    public static final String MILL_DATETIME_PATTERN4 = "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2SSS\u6beb\u79d2";
    public static final String DATETIME_PATTERN1 = "yyyy-MM-dd HH:mm:ss";
    public static final String DATETIME_PATTERN2 = "yyyy/MM/dd HH:mm:ss";
    public static final String DATETIME_PATTERN3 = "yyyyMMddHHmmss";
    public static final String DATETIME_PATTERN4 = "yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206ss\u79d2";
    public static final String DATE_PATTERN1 = "yyyy-MM-dd";
    public static final String DATE_PATTERN2 = "yyyy/MM/dd";
    public static final String DATE_PATTERN3 = "yyyyMMdd";
    public static final String DATE_PATTERN4 = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String MONTH_PATTERN1 = "yyyy-MM";
    public static final String MONTH_PATTERN2 = "yyyy/MM";
    public static final String MONTH_PATTERN3 = "yyyyMM";
    public static final String MONTH_PATTERN4 = "yyyy\u5e74MM\u6708";
    public static final String YEAR_PATTERN = "yyyy";
    public static final Map<String, DateTimeFormatter> FORMATTER_MAP = new HashMap<String, DateTimeFormatter>();

    private BlockDateTimeUtil() {
    }

    public static boolean validDateStr(String dateStr, String pattern) {
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            throw CheckFailedException.newInstance("dateStr\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            throw CheckFailedException.newInstance("pattern\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        DateTimeFormatter formatter = BlockDateTimeUtil.getDateTimeFormatter(pattern);
        try {
            DateTime.parse((String)dateStr, (DateTimeFormatter)formatter);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static List<String> getSerialDays(Date startDate, Date endDate, String pattern) {
        DateTime endDate1;
        if (null == startDate) {
            throw CheckFailedException.newInstance("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == endDate) {
            throw CheckFailedException.newInstance("\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        ArrayList<String> list = new ArrayList<String>();
        DateTime startDate1 = new DateTime(startDate.getTime());
        if (startDate1.compareTo((ReadableInstant)(endDate1 = new DateTime(endDate.getTime()))) > 0) {
            throw CheckFailedException.newInstance("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002");
        }
        Period period = new Period((ReadableInstant)startDate1, (ReadableInstant)endDate1, PeriodType.days());
        String tempPattern = pattern;
        if (StringUtils.isEmpty((CharSequence)tempPattern)) {
            tempPattern = DATE_PATTERN1;
            LOG.info((Object)"\u6ca1\u6709\u4f20\u5165pattern\u53c2\u6570\uff0c\u9ed8\u8ba4\u4f7f\u7528yyyy-MM-dd\u683c\u5f0f\u3002");
        }
        DateTime temp = startDate1;
        int days = period.getDays();
        for (int i = 0; i < days; ++i) {
            list.add(temp.toString(tempPattern));
            temp = temp.plusDays(1);
        }
        return list;
    }

    public static List<String> getSerialDays(Date date, int days, String pattern) {
        DateTime startDate1;
        if (null == date) {
            throw CheckFailedException.newInstance("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        ArrayList<String> list = new ArrayList<String>();
        String tempPattern = pattern;
        if (StringUtils.isEmpty((CharSequence)tempPattern)) {
            tempPattern = DATE_PATTERN1;
            LOG.info((Object)"\u6ca1\u6709\u4f20\u5165pattern\u53c2\u6570\uff0c\u9ed8\u8ba4\u4f7f\u7528yyyy-MM-dd\u683c\u5f0f\u3002");
        }
        DateTime temp = startDate1 = new DateTime(date.getTime());
        if (days < 0) {
            int positiveNumber = Math.abs(days);
            for (int i = 0; i < positiveNumber; ++i) {
                list.add(temp.toString(tempPattern));
                temp = temp.plusDays(-1);
            }
        } else {
            for (int i = 0; i < days; ++i) {
                list.add(temp.toString(tempPattern));
                temp = temp.plusDays(1);
            }
        }
        return list;
    }

    public static List<String> getSerialDays(String date, int days, String pattern) {
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            throw CheckFailedException.newInstance("pattern\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)date)) {
            throw CheckFailedException.newInstance("date\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateTimeFormatter formatter = BlockDateTimeUtil.getDateTimeFormatter(pattern);
        DateTime datetime = DateTime.parse((String)date, (DateTimeFormatter)formatter);
        return BlockDateTimeUtil.getSerialDays(datetime.toDate(), days, pattern);
    }

    public static List<String> getSerialMonths(Date startDate, Date endDate, String pattern) {
        DateTime endDate1;
        if (null == startDate) {
            throw CheckFailedException.newInstance("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == endDate) {
            throw CheckFailedException.newInstance("\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        ArrayList<String> list = new ArrayList<String>();
        DateTime startDate1 = new DateTime(startDate.getTime());
        if (startDate1.compareTo((ReadableInstant)(endDate1 = new DateTime(endDate.getTime()))) > 0) {
            throw CheckFailedException.newInstance("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002");
        }
        Period period = new Period((ReadableInstant)startDate1, (ReadableInstant)endDate1, PeriodType.months());
        String tempPattern = pattern;
        if (StringUtils.isEmpty((CharSequence)tempPattern)) {
            tempPattern = MONTH_PATTERN1;
            LOG.info((Object)"\u6ca1\u6709\u4f20\u5165pattern\u53c2\u6570\uff0c\u9ed8\u8ba4\u4f7f\u7528yyyy-MM\u683c\u5f0f\u3002");
        }
        int months = period.getMonths();
        DateTime temp = startDate1;
        for (int i = 0; i < months; ++i) {
            list.add(temp.toString(pattern));
            temp = temp.plusMonths(1);
        }
        return list;
    }

    public static List<String> getSerialMonths(Date date, int months, String pattern) {
        DateTime startDate1;
        if (null == date) {
            throw CheckFailedException.newInstance("\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        ArrayList<String> list = new ArrayList<String>();
        String tempPattern = pattern;
        if (StringUtils.isEmpty((CharSequence)tempPattern)) {
            tempPattern = MONTH_PATTERN1;
            LOG.info((Object)"\u6ca1\u6709\u4f20\u5165pattern\u53c2\u6570\uff0c\u9ed8\u8ba4\u4f7f\u7528yyyy-MM\u683c\u5f0f\u3002");
        }
        DateTime temp = startDate1 = new DateTime(date.getTime());
        if (months < 0) {
            int positiveNumber = Math.abs(months);
            for (int i = 0; i < positiveNumber; ++i) {
                list.add(temp.toString(tempPattern));
                temp = temp.plusMonths(-1);
            }
        } else {
            for (int i = 0; i < months; ++i) {
                list.add(temp.toString(tempPattern));
                temp = temp.plusMonths(1);
            }
        }
        return list;
    }

    public static List<String> getSerialMonths(String date, int months, String pattern) {
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            throw CheckFailedException.newInstance("pattern\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)date)) {
            throw CheckFailedException.newInstance("date\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateTimeFormatter formatter = BlockDateTimeUtil.getDateTimeFormatter(pattern);
        DateTime datetime = DateTime.parse((String)date, (DateTimeFormatter)formatter);
        return BlockDateTimeUtil.getSerialMonths(datetime.toDate(), months, pattern);
    }

    public static List<String> getSerialYears(Date startDate, Date endDate) {
        DateTime endDate1;
        if (null == startDate) {
            throw CheckFailedException.newInstance("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == endDate) {
            throw CheckFailedException.newInstance("\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        ArrayList<String> list = new ArrayList<String>();
        DateTime startDate1 = new DateTime(startDate.getTime());
        if (startDate1.compareTo((ReadableInstant)(endDate1 = new DateTime(endDate.getTime()))) > 0) {
            throw CheckFailedException.newInstance("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f\u3002");
        }
        Period period = new Period((ReadableInstant)startDate1, (ReadableInstant)endDate1, PeriodType.years());
        DateTime temp = startDate1;
        int years = period.getYears();
        for (int i = 0; i < years; ++i) {
            list.add(temp.toString(YEAR_PATTERN));
            temp = temp.plusYears(1);
        }
        return list;
    }

    public static List<String> getSerialYears(Date date, int years) {
        DateTime startDate1;
        if (null == date) {
            throw CheckFailedException.newInstance("\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        ArrayList<String> list = new ArrayList<String>();
        DateTime temp = startDate1 = new DateTime(date.getTime());
        if (years < 0) {
            int positiveNumber = Math.abs(years);
            for (int i = 0; i < positiveNumber; ++i) {
                list.add(temp.toString(YEAR_PATTERN));
                temp = temp.plusYears(-1);
            }
        } else {
            for (int i = 0; i < years; ++i) {
                list.add(temp.toString(YEAR_PATTERN));
                temp = temp.plusYears(1);
            }
        }
        return list;
    }

    public static List<String> getSerialYears(String date, int years) {
        if (StringUtils.isEmpty((CharSequence)date)) {
            throw CheckFailedException.newInstance("startDate\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DateTimeFormatter formatter = BlockDateTimeUtil.getDateTimeFormatter(YEAR_PATTERN);
        DateTime datetime = DateTime.parse((String)date, (DateTimeFormatter)formatter);
        return BlockDateTimeUtil.getSerialYears(datetime.toDate(), years);
    }

    public static Date setZeroTime(Date date) {
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.millisOfDay().withMinimumValue().toDate();
    }

    public static Date getFirstDayOfMonth(Date date) {
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.dayOfMonth().withMinimumValue().millisOfDay().withMinimumValue().toDate();
    }

    public static Date getFirstDayOfYear(Date date) {
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.dayOfYear().withMinimumValue().millisOfDay().withMinimumValue().toDate();
    }

    public static Date getFirstDayOfWeek(Date date) {
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.dayOfWeek().withMinimumValue().secondOfDay().withMinimumValue().millisOfDay().withMinimumValue().toDate();
    }

    public static Date getLastDayOfMonth(Date date) {
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.dayOfMonth().withMaximumValue().millisOfDay().withMaximumValue().toDate();
    }

    public static Date getLastDayOfYear(Date date) {
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.dayOfYear().withMaximumValue().millisOfDay().withMaximumValue().toDate();
    }

    public static Date getLastDayOfWeek(Date date) {
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.dayOfWeek().withMaximumValue().millisOfDay().withMaximumValue().toDate();
    }

    public static Date nextYear(Date date, int years) {
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.plusYears(years).toDate();
    }

    public static Date nextMonth(Date date, int months) {
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.plusMonths(months).toDate();
    }

    public static Date nextWeek(Date date, int weeks) {
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.plusWeeks(weeks).toDate();
    }

    public static Date nextDay(Date date, int days) {
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.plusDays(days).toDate();
    }

    public static Date nextHour(Date date, int hours) {
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.plusHours(hours).toDate();
    }

    public static Date nextMinute(Date date, int minutes) {
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.plusMinutes(minutes).toDate();
    }

    public static Date nextSecond(Date date, int seconds) {
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.plusSeconds(seconds).toDate();
    }

    public static int compare(Date date1, Date date2) {
        if (null == date1) {
            throw CheckFailedException.newInstance("date1\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == date2) {
            throw CheckFailedException.newInstance("date2\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        DateTime dateTime1 = new DateTime(date1.getTime());
        DateTime dateTime2 = new DateTime(date2.getTime());
        return dateTime1.compareTo((ReadableInstant)dateTime2);
    }

    public static Date parse(String dateStr, String pattern) {
        if (StringUtils.isEmpty((CharSequence)dateStr)) {
            throw CheckFailedException.newInstance("dateStr\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            throw CheckFailedException.newInstance("pattern\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        DateTimeFormatter formatter = BlockDateTimeUtil.getDateTimeFormatter(pattern);
        return DateTime.parse((String)dateStr, (DateTimeFormatter)formatter).toDate();
    }

    public static String formate(Date date, String pattern) {
        if (null == date) {
            throw CheckFailedException.newInstance("date\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)pattern)) {
            throw CheckFailedException.newInstance("pattern\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.toString(pattern);
    }

    public static int getYear(Date date) {
        if (null == date) {
            throw CheckFailedException.newInstance("date\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.getYear();
    }

    public static int getMonth(Date date) {
        if (null == date) {
            throw CheckFailedException.newInstance("date\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.getMonthOfYear();
    }

    public static int getDay(Date date) {
        if (null == date) {
            throw CheckFailedException.newInstance("date\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.getDayOfMonth();
    }

    public static int getHour(Date date) {
        if (null == date) {
            throw CheckFailedException.newInstance("date\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.getHourOfDay();
    }

    public static int getMinute(Date date) {
        if (null == date) {
            throw CheckFailedException.newInstance("date\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.getMinuteOfHour();
    }

    public static int getSecond(Date date) {
        if (null == date) {
            throw CheckFailedException.newInstance("date\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        DateTime dateTime = new DateTime(date.getTime());
        return dateTime.getSecondOfMinute();
    }

    public static String convertPattern(String dateStr, String originPattern, String targetPattern) {
        DateTimeFormatter formatter = BlockDateTimeUtil.getDateTimeFormatter(originPattern);
        DateTime dateTime = DateTime.parse((String)dateStr, (DateTimeFormatter)formatter);
        return dateTime.toString(targetPattern);
    }

    private static DateTimeFormatter getDateTimeFormatter(String pattern) {
        DateTimeFormatter formatter = FORMATTER_MAP.containsKey(pattern) ? FORMATTER_MAP.get(pattern) : DateTimeFormat.forPattern((String)pattern);
        return formatter;
    }

    static {
        FORMATTER_MAP.put(MILL_DATETIME_PATTERN1, DateTimeFormat.forPattern((String)MILL_DATETIME_PATTERN1));
        FORMATTER_MAP.put(MILL_DATETIME_PATTERN2, DateTimeFormat.forPattern((String)MILL_DATETIME_PATTERN2));
        FORMATTER_MAP.put(MILL_DATETIME_PATTERN3, DateTimeFormat.forPattern((String)MILL_DATETIME_PATTERN3));
        FORMATTER_MAP.put(MILL_DATETIME_PATTERN4, DateTimeFormat.forPattern((String)MILL_DATETIME_PATTERN4));
        FORMATTER_MAP.put(DATETIME_PATTERN1, DateTimeFormat.forPattern((String)DATETIME_PATTERN1));
        FORMATTER_MAP.put(DATETIME_PATTERN2, DateTimeFormat.forPattern((String)DATETIME_PATTERN2));
        FORMATTER_MAP.put(DATETIME_PATTERN3, DateTimeFormat.forPattern((String)DATETIME_PATTERN3));
        FORMATTER_MAP.put(DATETIME_PATTERN4, DateTimeFormat.forPattern((String)DATETIME_PATTERN4));
        FORMATTER_MAP.put(DATE_PATTERN1, DateTimeFormat.forPattern((String)DATE_PATTERN1));
        FORMATTER_MAP.put(DATE_PATTERN2, DateTimeFormat.forPattern((String)DATE_PATTERN2));
        FORMATTER_MAP.put(DATE_PATTERN3, DateTimeFormat.forPattern((String)DATE_PATTERN3));
        FORMATTER_MAP.put(DATE_PATTERN4, DateTimeFormat.forPattern((String)DATE_PATTERN4));
        FORMATTER_MAP.put(MONTH_PATTERN1, DateTimeFormat.forPattern((String)MONTH_PATTERN1));
        FORMATTER_MAP.put(MONTH_PATTERN2, DateTimeFormat.forPattern((String)MONTH_PATTERN2));
        FORMATTER_MAP.put(MONTH_PATTERN3, DateTimeFormat.forPattern((String)MONTH_PATTERN3));
        FORMATTER_MAP.put(MONTH_PATTERN4, DateTimeFormat.forPattern((String)MONTH_PATTERN4));
        FORMATTER_MAP.put(YEAR_PATTERN, DateTimeFormat.forPattern((String)YEAR_PATTERN));
    }
}

