/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ygsoft.abc.service.attachment.io.StorageObjectInputStream;
import com.ygsoft.abc.service.exception.AbcIOException;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.exception.CheckFailedException;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.tool.BlockCodingUtil;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.BlockDateUtil;
import com.ygsoft.abc.service.tool.CommonUtil;
import com.ygsoft.abc.service.tool.FileTypeUtil;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.ecp.framework.util.ResourceUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.UuidUtil;
import com.ygsoft.ecp.service.unstructure.EntityAttachmentDetailVO;
import com.ygsoft.ecp.service.unstructure.EntityAttachmentSummaryVO;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.entity.ContentType;
import org.springframework.core.io.FileSystemResource;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class BlockIOUtil {
    static final IEcpLog LOG = EcpLogFactory.getLog(BlockIOUtil.class);
    private static final int BUFFER_SIZE = 0x100000;
    private static final String ATTACH_TEMP_PATH = "abc.attachment.temp.dir";
    private static final int TEMP_FILE_SIZE = 0x1000000;
    private static final ExecutorService executor = new ThreadPoolExecutor(10, 200, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(10), new ThreadFactoryBuilder().setNameFormat("BlockIOUtil-Pool ").build());
    private static final String DATE_PATTERN = "yyyyMMddHHmmss";

    private BlockIOUtil() {
    }

    public static void close(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException ioe) {
            BlockIOUtil.logError("\u5173\u95ed\u6d41\u5931\u8d25", ioe);
        }
    }

    public static void write(byte[] data, String filePath) {
        try (FileOutputStream output = new FileOutputStream(filePath);){
            IOUtils.write((byte[])data, (OutputStream)output);
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0015", e);
        }
    }

    public static void write(String data, String filePath) {
        try (FileOutputStream output = new FileOutputStream(filePath);){
            IOUtils.write((String)data, (OutputStream)output, (Charset)Charset.forName("UTF-8"));
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0015", e);
        }
    }

    private static String buildPrefixedPath(String filePath) {
        String prefixedPath = filePath;
        if (!filePath.startsWith("classpath") && !filePath.startsWith("file")) {
            prefixedPath = "file:" + filePath;
        }
        return prefixedPath;
    }

    public static URL readResource(String filePath) {
        String prefixedPath = BlockIOUtil.buildPrefixedPath(filePath);
        List urls = ResourceUtil.findResources((String)prefixedPath);
        return (URL)urls.get(0);
    }

    public static List<URL> readResources(String filePath) {
        String prefixedPath = BlockIOUtil.buildPrefixedPath(filePath);
        List urls = ResourceUtil.findResources((String)prefixedPath);
        if (BlockCollectionUtil.isEmpty(urls)) {
            String msg = String.format(EcpI18nUtil.localizedString((String)"CommonUtil_readConfig_680", (String)"\u6307\u5b9a\u8def\u5f84(%s)\u67e5\u627e\u8d44\u6e90\u5931\u8d25\u3002"), filePath);
            throw new EmptyValueException("ABC.0001", msg);
        }
        return urls;
    }

    public static InputStream openStream(String path) {
        return BlockIOUtil.openStream(BlockIOUtil.readResource(path));
    }

    public static InputStream openStream(URL url) {
        try {
            return url.openStream();
        }
        catch (IOException e) {
            throw new AbcServiceException("ABC.0015", e.getMessage(), e, new Object[0]);
        }
    }

    public static void downloadFile(String filePath, String fileName, HttpServletResponse response) {
        try (InputStream in = BlockIOUtil.openStream(BlockIOUtil.readResource(filePath));){
            response.setCharacterEncoding("utf-8");
            response.setHeader("content-Type", new MimetypesFileTypeMap().getContentType(fileName));
            response.setHeader("Content-Disposition", "attachment;filename=" + BlockIOUtil.encodeFileName(fileName));
            BlockIOUtil.copy(in, (OutputStream)response.getOutputStream());
            response.getOutputStream().flush();
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0015", e);
        }
    }

    public static void downloadFileTail(String filePath, String fileName, long byteSize, HttpServletResponse response) {
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(new File(filePath), "r");){
            response.setCharacterEncoding("utf-8");
            response.setHeader("content-Type", new MimetypesFileTypeMap().getContentType(fileName));
            response.setHeader("Content-Disposition", "attachment;filename=" + BlockIOUtil.encodeFileName(fileName));
            randomAccessFile.seek(BlockIOUtil.offset(randomAccessFile.length(), byteSize));
            BlockIOUtil.copy(randomAccessFile, (OutputStream)response.getOutputStream());
            response.getOutputStream().flush();
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0015", e);
        }
    }

    static long offset(long length, long byteSize) {
        if (length <= byteSize) {
            return 0L;
        }
        return length - byteSize;
    }

    public static void downloadExcel(String filePath, String fileName, HttpServletResponse response) {
        InputStream in = null;
        ByteArrayOutputStream byteOut = null;
        try {
            in = BlockIOUtil.openStream(BlockIOUtil.readResource(filePath));
            byteOut = new ByteArrayOutputStream();
            BlockIOUtil.copy(in, (OutputStream)byteOut);
            response.setCharacterEncoding("utf-8");
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.setHeader("Content-Disposition", "attachment;filename=" + BlockIOUtil.encodeFileName(fileName));
            response.getOutputStream().write(byteOut.toByteArray());
            response.getOutputStream().flush();
        }
        catch (Exception e) {
            try {
                throw new AbcIOException("ABC.0015", e);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(in);
                BlockIOUtil.close(byteOut);
                throw throwable;
            }
        }
        BlockIOUtil.close(in);
        BlockIOUtil.close(byteOut);
    }

    public static void downloadAttachmentToFile(EntityAttachmentSummaryVO attachment, HttpServletResponse response) {
        InputStream in = null;
        ByteArrayOutputStream byteOut = null;
        try {
            in = BlockIOUtil.getInputStream(attachment);
            byteOut = new ByteArrayOutputStream();
            BlockIOUtil.copy(in, (OutputStream)byteOut);
            String fileName = BlockIOUtil.getEncodeFileName(attachment);
            response.setHeader("content-type", "application/octet-stream");
            response.setContentType("application/octet-stream");
            response.setHeader("content-disposition", "attachment;filename=" + fileName);
            response.setHeader("file-name", fileName);
            response.getOutputStream().write(byteOut.toByteArray());
            response.getOutputStream().flush();
        }
        catch (Exception e) {
            try {
                throw new AbcIOException("ABC.0015", e);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(in);
                BlockIOUtil.close(byteOut);
                throw throwable;
            }
        }
        BlockIOUtil.close(in);
        BlockIOUtil.close(byteOut);
    }

    public static void downloadToFile(StorageObjectInputStream soInputStream, HttpServletResponse response) {
        PreconditionUtil.checkNotNull(soInputStream, "\u53c2\u6570\u9519\u8bef\uff1asoInputStream\u4e3a\u7a7a\u3002");
        try {
            response.setHeader("content-type", "application/octet-stream");
            response.setContentType("application/octet-stream");
            response.setHeader("content-disposition", "attachment;filename=" + BlockIOUtil.encodeFileName(soInputStream.getSummary().getFileName()));
            int size = 0;
            int count = 0;
            byte[] buffer = new byte[0x100000];
            while ((count = soInputStream.read(buffer)) != -1) {
                response.getOutputStream().write(buffer, 0, count);
                size += count;
            }
            response.getOutputStream().flush();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("=====>\u4e0b\u8f7d\u6587\u4ef6\uff0csize=" + size));
            }
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0015", e);
        }
        finally {
            BlockIOUtil.close(soInputStream);
        }
    }

    public static void downloadToImage(InputStream inputStream, HttpServletResponse response) {
        PreconditionUtil.checkNotNull(inputStream, "\u53c2\u6570\u9519\u8bef\uff1ainputStream\u4e3a\u7a7a\u3002");
        try {
            int size = 0;
            int count = 0;
            byte[] buffer = new byte[0x100000];
            while ((count = inputStream.read(buffer)) != -1) {
                response.getOutputStream().write(buffer, 0, count);
                size += count;
            }
            response.setContentType("image/*");
            response.getOutputStream().flush();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("=====>\u4e0b\u8f7d\u56fe\u7247\uff0csize=" + size));
            }
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0015", e);
        }
        finally {
            BlockIOUtil.close(inputStream);
        }
    }

    public static void downloadAttachmentToImage(EntityAttachmentSummaryVO attachment, HttpServletResponse response) {
        PreconditionUtil.checkNotNull(attachment, "\u53c2\u6570\u9519\u8bef\uff1aattachment\u4e3a\u7a7a\u3002");
        if (!FileTypeUtil.isImage(attachment.getBtype())) {
            throw CheckFailedException.newInstance("\u9644\u4ef6\u8d44\u6e90\uff08" + attachment.getResId() + "\uff09\u4e0d\u662f\u56fe\u7247\u3002");
        }
        InputStream in = null;
        ByteArrayOutputStream byteOut = null;
        try {
            in = BlockIOUtil.getInputStream(attachment);
            byteOut = new ByteArrayOutputStream();
            BlockIOUtil.copy(in, (OutputStream)byteOut);
            response.setContentType("image/*");
            response.getOutputStream().write(byteOut.toByteArray());
            response.getOutputStream().flush();
        }
        catch (Exception e) {
            try {
                throw new AbcIOException("ABC.0015", e);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(in);
                BlockIOUtil.close(byteOut);
                throw throwable;
            }
        }
        BlockIOUtil.close(in);
        BlockIOUtil.close(byteOut);
    }

    public static void downloadToImage(byte[] data, HttpServletResponse response) {
        PreconditionUtil.checkArgument(!BlockIOUtil.isEmpty(data), "data is empty.");
        PreconditionUtil.checkNotNull(response, "response is null.");
        try {
            response.setContentType("image/*");
            response.getOutputStream().write(data);
            response.getOutputStream().flush();
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0015", e);
        }
    }

    private static String getEncodeFileName(EntityAttachmentSummaryVO attachment) throws Exception {
        String filename = attachment.getTitle();
        String fileType = attachment.getBtype();
        String encodeFileName = BlockIOUtil.encodeFileName(filename + "." + fileType.toLowerCase());
        return encodeFileName;
    }

    public static void downloadZip(String filePath, String fileName, HttpServletResponse response, boolean deleteFile) {
        FileInputStream fileIn = null;
        ByteArrayOutputStream byteOut = null;
        try {
            fileIn = new FileInputStream(new File(filePath));
            byteOut = new ByteArrayOutputStream();
            BlockIOUtil.copy(fileIn, (OutputStream)byteOut);
            response.setHeader("content-type", "application/octet-stream");
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment;filename*=UTF-8''" + BlockIOUtil.encodeFileName(fileName));
            response.getOutputStream().write(byteOut.toByteArray());
            response.getOutputStream().flush();
            if (deleteFile) {
                BlockIOUtil.deleteFile(filePath);
            }
        }
        catch (Exception e) {
            try {
                throw new AbcIOException("ABC.0015", e);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(fileIn);
                BlockIOUtil.close(byteOut);
                throw throwable;
            }
        }
        BlockIOUtil.close(fileIn);
        BlockIOUtil.close(byteOut);
    }

    public static void downloadByBytes(byte[] fileBytes, String fileName, HttpServletResponse response) {
        response.setHeader("content-type", "application/octet-stream");
        response.setContentType("application/octet-stream");
        ServletOutputStream out = null;
        try {
            response.setHeader("content-disposition", "attachment;filename=" + BlockIOUtil.encodeFileName(fileName));
            out = response.getOutputStream();
            out.write(fileBytes);
            out.flush();
        }
        catch (Exception e) {
            try {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)e);
                }
                throw new AbcIOException("ABC.0015", e);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(out);
                throw throwable;
            }
        }
        BlockIOUtil.close((Closeable)out);
    }

    public static void downloadWithoutExt(byte[] fileBytes, HttpServletResponse response) {
        String fileName = UUID.randomUUID().toString();
        BlockIOUtil.downloadByBytes(fileBytes, fileName, response);
    }

    private static String encodeFileName(String fileName) throws Exception {
        String fname = URLEncoder.encode(fileName, "UTF-8");
        fname = fname.replaceAll("[+]", "%20");
        return fname;
    }

    public static void deleteFile(String filePath) {
        File file = new File(filePath);
        BlockIOUtil.deleteFile(file);
    }

    public static void deleteFile(File file) {
        BlockIOUtil.logInfo("\u5220\u9664\u6587\u4ef6\uff0cfilePath=" + file.getAbsolutePath());
        executor.submit(() -> {
            try {
                Thread.sleep(30000L);
                FileUtils.forceDelete((File)file);
            }
            catch (Exception e) {
                BlockIOUtil.logError("\u5220\u9664\u6587\u4ef6\u5931\u8d25\u3002", e);
            }
        });
    }

    public static InputStream toInputStream(EntityAttachmentDetailVO attachmentDetail) {
        if (attachmentDetail == null) {
            return null;
        }
        InputStream is = null;
        Blob blob = attachmentDetail.getData();
        if (blob != null) {
            try {
                is = blob.getBinaryStream();
            }
            catch (Exception e) {
                throw AbcIOException.newInstance("\u4ece\u9644\u4ef6\u5185\u5bb9\u4e2d\u53d6\u6570\u636e\u6d41\u51fa\u9519\u3002", e);
            }
        }
        try {
            is = new FileInputStream(attachmentDetail.getFile());
        }
        catch (Exception e) {
            throw AbcIOException.newInstance("\u4ece\u9644\u4ef6\u5185\u5bb9\u4e2d\u53d6\u6570\u636e\u6d41\u51fa\u9519\u3002", e);
        }
        return is;
    }

    public static InputStream toInputStream(byte[] data) {
        if (Objects.isNull(data)) {
            throw EmptyValueException.newInstance("\u53c2\u6570\u9519\u8bef\uff1adata\u4e3a\u7a7a\u3002");
        }
        return new ByteArrayInputStream(data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] toByteArray(InputStream input) {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            BlockIOUtil.copy(input, (OutputStream)output);
            byte[] byArray = output.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw AbcIOException.newInstance(e);
        }
    }

    public static byte[] toByteArray(EntityAttachmentDetailVO attachmentDetail) {
        InputStream is = BlockIOUtil.toInputStream(attachmentDetail);
        if (null == is) {
            return null;
        }
        return BlockIOUtil.toByteArray(is);
    }

    public static long copy(RandomAccessFile input, OutputStream output) {
        try {
            byte[] buf = new byte[0x100000];
            int byteRead = 0;
            long size = 0L;
            while ((byteRead = input.read(buf)) != -1) {
                output.write(buf, 0, byteRead);
                size += (long)byteRead;
            }
            return size;
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0014", e);
        }
    }

    public static long copy(InputStream input, OutputStream output) {
        try {
            byte[] buf = new byte[0x100000];
            int byteRead = 0;
            long size = 0L;
            while ((byteRead = input.read(buf)) != -1) {
                output.write(buf, 0, byteRead);
                size += (long)byteRead;
            }
            return size;
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0014", e);
        }
    }

    public static long copy(Reader input, Writer output) {
        long l;
        BufferedReader bufReader = null;
        try {
            bufReader = new BufferedReader(input);
            char[] buf = new char[0x100000];
            int charRead = 0;
            long size = 0L;
            while ((charRead = bufReader.read(buf)) != -1) {
                output.write(buf, 0, charRead);
                size += (long)charRead;
            }
            BlockIOUtil.logInfo("copy size:" + size);
            l = size;
        }
        catch (Exception e) {
            try {
                throw new AbcIOException("ABC.0014", e);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(bufReader);
                throw throwable;
            }
        }
        BlockIOUtil.close(bufReader);
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytes(String filePath) {
        try (InputStream in = BlockIOUtil.openStream(BlockIOUtil.readResource(filePath));){
            byte[] byArray = BlockIOUtil.toByteArray(in);
            return byArray;
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0014", e);
        }
    }

    public static String readText(String filePath) {
        String string;
        InputStream in = null;
        ByteArrayOutputStream byteOut = null;
        try {
            in = BlockIOUtil.openStream(BlockIOUtil.readResource(filePath));
            byteOut = new ByteArrayOutputStream();
            BlockIOUtil.copy(in, (OutputStream)byteOut);
            string = new String(byteOut.toByteArray(), "UTF-8");
        }
        catch (Exception e) {
            try {
                throw new AbcIOException("ABC.0014", e);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(in);
                BlockIOUtil.close(byteOut);
                throw throwable;
            }
        }
        BlockIOUtil.close(in);
        BlockIOUtil.close(byteOut);
        return string;
    }

    public static List<String> readLines(String filePath) {
        return BlockIOUtil.readLines(filePath, true);
    }

    public static List<String> readLines(String filePath, Charset charset) {
        return BlockIOUtil.readLines(filePath, charset, true);
    }

    public static List<String> readLines(String filePath, boolean skipEmpty) {
        Function<String, Boolean> skipFunction = str -> StringUtil.isNullOrTrimEmptyString((String)str);
        return BlockIOUtil.readLines(filePath, skipFunction);
    }

    public static List<String> readLines(String filePath, Charset charset, boolean skipEmpty) {
        Function<String, Boolean> skipFunction = str -> StringUtil.isNullOrTrimEmptyString((String)str);
        return BlockIOUtil.readLines(filePath, charset, skipFunction);
    }

    public static List<String> readLinesWithSkip(String filePath) {
        Function<String, Boolean> skipFunction = str -> {
            boolean isEmpty = StringUtil.isNullOrTrimEmptyString((String)str);
            boolean isNote = str.startsWith("#");
            return isEmpty || isNote;
        };
        return BlockIOUtil.readLines(filePath, skipFunction);
    }

    public static List<String> readLines(String filePath, Function<String, Boolean> skipFunction) {
        if (filePath.startsWith("file:")) {
            return BlockIOUtil.readLinesFromFile(filePath, skipFunction);
        }
        return BlockIOUtil.readLinesFromClasspath(filePath, skipFunction);
    }

    public static List<String> readLinesFromClasspath(String filePath, Function<String, Boolean> skipFunction) {
        ArrayList<String> arrayList;
        ArrayList<String> list = new ArrayList<String>(64);
        InputStream in = null;
        BufferedReader reader = null;
        try {
            in = BlockIOUtil.openStream(BlockIOUtil.readResource(filePath));
            reader = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (skipFunction.apply(line).booleanValue()) continue;
                list.add(line);
            }
            arrayList = list;
        }
        catch (Exception e) {
            try {
                throw new AbcIOException("ABC.0014", e);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(in);
                BlockIOUtil.close(reader);
                throw throwable;
            }
        }
        BlockIOUtil.close(in);
        BlockIOUtil.close(reader);
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readLinesFromFile(String filePath, Function<String, Boolean> skipFunction) {
        if (!filePath.startsWith("file:")) {
            throw CheckFailedException.newInstance("\u6587\u4ef6\u8def\u5f84\u9700\u8981file:\u5f00\u5934\u3002");
        }
        String path = filePath.substring(5);
        System.out.println("path:" + path);
        ArrayList<String> list = new ArrayList<String>(64);
        FileSystemResource resource = new FileSystemResource(path);
        try (BufferedReader reader = new BufferedReader(new FileReader(resource.getFile()));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (skipFunction.apply(line).booleanValue()) continue;
                list.add(line);
            }
            ArrayList<String> arrayList = list;
            return arrayList;
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0014", e);
        }
    }

    public static List<String> readLines(String filePath, Charset charset, Function<String, Boolean> skipFunction) {
        ArrayList<String> arrayList;
        ArrayList<String> list = new ArrayList<String>(64);
        InputStream in = null;
        BufferedReader reader = null;
        try {
            if (filePath.startsWith("file:")) {
                String path = filePath.substring(5);
                in = new FileInputStream(path);
            } else {
                in = BlockIOUtil.openStream(BlockIOUtil.readResource(filePath));
            }
            reader = new BufferedReader(new InputStreamReader(in, charset.name()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (skipFunction.apply(line).booleanValue()) continue;
                list.add(line);
            }
            arrayList = list;
        }
        catch (Exception e) {
            try {
                throw new AbcIOException("ABC.0014", e);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(in);
                BlockIOUtil.close(reader);
                throw throwable;
            }
        }
        BlockIOUtil.close(in);
        BlockIOUtil.close(reader);
        return arrayList;
    }

    public static void writeLines(String filePath, List<String> list) {
        BlockIOUtil.writeLines(new File(filePath), list);
    }

    public static void writeLines(File file, List<String> list) {
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                throw new AbcIOException("ABC.0014", e);
            }
        }
        try (OutputStreamWriter output = new OutputStreamWriter(new FileOutputStream(file));
             BufferedWriter writer = new BufferedWriter(output);){
            for (String line : list) {
                writer.write(line);
                writer.newLine();
            }
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0014", e);
        }
    }

    public static String zipAttachments(List<EntityAttachmentSummaryVO> attachments) {
        String string;
        String tempFolderPath = BlockIOUtil.getTempFilePath();
        File folder = new File(tempFolderPath);
        String zipFilePath = tempFolderPath + File.separator + "temp" + UuidUtil.newUUID() + ".zip";
        ZipOutputStream zipOut = null;
        try {
            if (!folder.exists()) {
                FileUtils.forceMkdir((File)folder);
            }
            zipOut = new ZipOutputStream(new FileOutputStream(zipFilePath));
            HashMap<String, Integer> nameCountMap = new HashMap<String, Integer>();
            for (int i = 0; i < attachments.size(); ++i) {
                EntityAttachmentSummaryVO attachment = attachments.get(i);
                String longName = attachment.getTitle() + attachment.getBtype();
                String realAttachName = attachment.getTitle();
                if (nameCountMap.containsKey(longName)) {
                    realAttachName = realAttachName + "(" + nameCountMap.get(longName) + ")";
                    nameCountMap.put(longName, (Integer)nameCountMap.get(longName) + 1);
                } else {
                    nameCountMap.put(longName, 1);
                }
                BlockIOUtil.putZipEntry(zipOut, attachment, realAttachName);
            }
            BlockIOUtil.logInfo("\u6839\u636e\u9644\u4ef6\u751f\u6210zip:" + zipFilePath);
            string = zipFilePath;
        }
        catch (Exception e) {
            try {
                throw new AbcIOException("ABC.0014", e);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(zipOut);
                throw throwable;
            }
        }
        BlockIOUtil.close(zipOut);
        return string;
    }

    public static String zipAttachments(Map<String, List<EntityAttachmentSummaryVO>> fileNameAndAttachMap) {
        String tempFolderPath = BlockIOUtil.getTempFilePath();
        File folder = new File(tempFolderPath);
        String zipFilePath = tempFolderPath + File.separator + "temp" + UuidUtil.newUUID() + ".zip";
        FileOutputStream fileOutputStream = null;
        try {
            if (!folder.exists()) {
                FileUtils.forceMkdir((File)folder);
            }
            fileOutputStream = new FileOutputStream(zipFilePath);
        }
        catch (Exception e1) {
            throw new AbcIOException("ABC.0014", e1);
        }
        ZipOutputStream zipOut = new ZipOutputStream(fileOutputStream);
        try {
            fileNameAndAttachMap.forEach((k, v) -> {
                HashMap attachNameAndCountMap = new HashMap();
                HashMap<String, Integer> newAttachNameAndCountMap = new HashMap<String, Integer>();
                v.forEach(ele -> {
                    if (attachNameAndCountMap.containsKey(ele.getTitle())) {
                        attachNameAndCountMap.put(ele.getTitle(), (Integer)attachNameAndCountMap.get(ele.getTitle()) + 1);
                    } else {
                        attachNameAndCountMap.put(ele.getTitle(), 0);
                    }
                    newAttachNameAndCountMap.put(ele.getTitle(), 0);
                });
                for (int i = 0; i < v.size(); ++i) {
                    EntityAttachmentSummaryVO attachment = (EntityAttachmentSummaryVO)v.get(i);
                    if (!((Integer)attachNameAndCountMap.get(attachment.getTitle())).equals(0)) {
                        newAttachNameAndCountMap.put(attachment.getTitle(), (Integer)newAttachNameAndCountMap.get(attachment.getTitle()) + 1);
                    }
                    BlockIOUtil.putZipEntry(zipOut, attachment, k + File.separator, newAttachNameAndCountMap);
                }
            });
            BlockIOUtil.logInfo("\u6839\u636e\u9644\u4ef6\u751f\u6210zip:" + zipFilePath);
            String string = zipFilePath;
            return string;
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0014", e);
        }
        finally {
            BlockIOUtil.close(zipOut);
            BlockIOUtil.close(fileOutputStream);
        }
    }

    private static void putZipEntry(ZipOutputStream zipOut, EntityAttachmentSummaryVO attachment) {
        String attachName = attachment.getTitle();
        String fileType = attachment.getBtype();
        InputStream in = null;
        try {
            in = BlockIOUtil.getInputStream(attachment);
            zipOut.putNextEntry(new ZipEntry(attachName + "." + fileType));
            BlockIOUtil.copy(in, (OutputStream)zipOut);
            zipOut.closeEntry();
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0014", e);
        }
        finally {
            BlockIOUtil.close(in);
        }
    }

    private static void putZipEntry(ZipOutputStream zipOut, EntityAttachmentSummaryVO attachment, String realAttachName) {
        String fileType = attachment.getBtype();
        InputStream in = null;
        try {
            in = BlockIOUtil.getInputStream(attachment);
            zipOut.putNextEntry(new ZipEntry(realAttachName + "." + fileType));
            BlockIOUtil.copy(in, (OutputStream)zipOut);
            zipOut.closeEntry();
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0014", e);
        }
        finally {
            BlockIOUtil.close(in);
        }
    }

    private static void putZipEntry(ZipOutputStream zipOut, EntityAttachmentSummaryVO attachment, String filePath, Map<String, Integer> attachNameAndCountMap) {
        String attachName = attachNameAndCountMap.get(attachment.getTitle()).equals(0) ? attachment.getTitle() : attachment.getTitle() + "_" + attachNameAndCountMap.get(attachment.getTitle());
        String fileType = attachment.getBtype();
        InputStream in = null;
        try {
            in = BlockIOUtil.getInputStream(attachment);
            zipOut.putNextEntry(new ZipEntry(filePath + attachName + "." + fileType));
            BlockIOUtil.copy(in, (OutputStream)zipOut);
            zipOut.closeEntry();
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0014", e);
        }
        finally {
            BlockIOUtil.close(in);
        }
    }

    public static InputStream getInputStream(EntityAttachmentSummaryVO attachment) throws Exception {
        InputStream in = null;
        Blob blob = attachment.getAttachmentDetailVO().getData();
        in = Objects.isNull(blob) ? new FileInputStream(attachment.getAttachmentDetailVO().getFile()) : blob.getBinaryStream();
        return in;
    }

    public static InputStream getInputStream(byte[] data) {
        PreconditionUtil.checkArgument(!BlockIOUtil.isEmpty(data), "data is empty.");
        return new ByteArrayInputStream(data);
    }

    public static byte[] extractByteArray(EntityAttachmentSummaryVO attachment) {
        byte[] byArray;
        InputStream in = null;
        ByteArrayOutputStream byteOut = null;
        try {
            byte[] arr;
            in = BlockIOUtil.getInputStream(attachment);
            byteOut = new ByteArrayOutputStream();
            BlockIOUtil.copy(in, (OutputStream)byteOut);
            byArray = arr = byteOut.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new AbcIOException("ABC.0015", e);
            }
            catch (Throwable throwable) {
                BlockIOUtil.close(in);
                BlockIOUtil.close(byteOut);
                throw throwable;
            }
        }
        BlockIOUtil.close(in);
        BlockIOUtil.close(byteOut);
        return byArray;
    }

    public static String prepareTempFilePath() {
        String path = BlockIOUtil.getTempFilePath();
        File tempFolder = new File(path);
        if (!tempFolder.exists()) {
            try {
                FileUtils.forceMkdir((File)tempFolder);
            }
            catch (IOException e) {
                String err = "\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5939\u5931\u8d25";
                BlockIOUtil.logError("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5939\u5931\u8d25", e);
                throw new AbcIOException("ABC.0014", "\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5939\u5931\u8d25");
            }
        }
        return path;
    }

    private static boolean isEmpty(byte[] data) {
        return Objects.isNull(data) || data.length == 0;
    }

    private static String getTempFilePath() {
        String dayStr = BlockDateUtil.formatDayCompact(new Date());
        return CommonUtil.getSystemDisk() + File.separator + "temp_" + dayStr;
    }

    public static String getTempPath() {
        return PropertyConfigUtil.getStrictProperty(ATTACH_TEMP_PATH);
    }

    public static FileItem toFileItem(File file, ContentType contentType) {
        DiskFileItemFactory factory = new DiskFileItemFactory(0x1000000, new File(BlockIOUtil.getTempPath()));
        FileItem fileItem = factory.createItem("file", contentType.getMimeType(), true, file.getName());
        try (FileInputStream fis = new FileInputStream(file);
             OutputStream out = fileItem.getOutputStream();){
            BlockIOUtil.copy(fis, out);
        }
        catch (Exception e) {
            String err = "\u590d\u5236\u6587\u4ef6\u5931\u8d25\u3002";
            throw new AbcIOException("ABC.0014", "\u590d\u5236\u6587\u4ef6\u5931\u8d25\u3002", e, new Object[0]);
        }
        return fileItem;
    }

    public static MultipartFile toMultipartFile(File file, ContentType contentType) {
        FileItem fileItem = BlockIOUtil.toFileItem(file, contentType);
        return new CommonsMultipartFile(fileItem);
    }

    public static File writeTempFile(byte[] data, String tempDirName) {
        String fileName = BlockIOUtil.buildTempFileName(UuidUtil.newUUID());
        return BlockIOUtil.writeTempFile(data, fileName, tempDirName);
    }

    public static String buildTempFileName(String fileName) {
        String timeStr = BlockDateUtil.formatDate(new Date(), DATE_PATTERN);
        String randomStr = BlockCodingUtil.randomLetters(10);
        return timeStr + "_" + randomStr + "_" + fileName;
    }

    public static File writeTempFile(byte[] data, String newFileName, String tempDirName) {
        String tempDir = BlockIOUtil.getTempPath() + File.separator + tempDirName;
        File dir = new File(tempDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String filePath = tempDir + File.separator + newFileName;
        File tempFile = new File(filePath);
        try {
            FileUtils.writeByteArrayToFile((File)tempFile, (byte[])data);
            return tempFile;
        }
        catch (IOException e) {
            String err = "\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\u3002";
            BlockIOUtil.logError("\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\u3002", e);
            throw new AbcIOException("ABC.0014", "\u521b\u5efa\u4e34\u65f6\u6587\u4ef6\u5931\u8d25\u3002", e, new Object[0]);
        }
    }

    public static String mergePath(String base, String filePath) {
        PreconditionUtil.checkNotTrimEmpty(base, "\u53c2\u6570\u9519\u8bef\uff1abase\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotTrimEmpty(filePath, "\u53c2\u6570\u9519\u8bef\uff1afilePath\u4e3a\u7a7a\u3002");
        String basePath = base;
        if (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        String path = filePath;
        if (!filePath.startsWith("/")) {
            path = "/" + filePath;
        }
        return basePath + path;
    }

    public static String parseFileName(String filePath) {
        PreconditionUtil.checkNotTrimEmpty(filePath, "\u53c2\u6570\u9519\u8bef\uff1afilePath\u4e3a\u7a7a\u3002");
        if (!filePath.contains("/")) {
            return filePath;
        }
        int idx = filePath.lastIndexOf(47);
        return filePath.substring(idx + 1);
    }

    protected static void logInfo(Object obj) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\n>>>" + obj));
        }
    }

    protected static void logError(Object obj, Throwable e) {
        if (LOG.isErrorEnabled()) {
            if (null == e) {
                LOG.error((Object)("\n###" + obj));
            } else {
                LOG.error((Object)("\n###" + obj), e);
            }
        }
    }

    public static String clipFileName(String originFileName) {
        return originFileName.replaceAll("[\\\\/\\:\\*\\?\"\\<\\>\\|]", "");
    }
}

