/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.serializer.ValueFilter;
import com.google.common.collect.ImmutableMap;
import com.ygsoft.ecp.core.framework.collections.DataArrayList;
import com.ygsoft.ecp.service.json.impl.JSONSerializeUtil;
import com.ygsoft.ecp.service.tool.JSONUtil;
import com.ygsoft.necp.core.lic.uitls.ReflectUtil;
import java.lang.reflect.Field;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BlockJSONUtil {
    private static final String JSON_OBJECT_PATTERN = "^\\{.*\\}$";
    private static final String JSON_ARRAY_PATTERN = "^\\[.*\\]$";
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TYPE_MAP = ImmutableMap.builder().put(Byte.class, Byte.TYPE).put(Byte.TYPE, Byte.TYPE).put(Short.class, Short.TYPE).put(Short.TYPE, Short.TYPE).put(Integer.class, Integer.TYPE).put(Integer.TYPE, Integer.TYPE).put(Long.class, Long.TYPE).put(Long.TYPE, Long.TYPE).put(Float.class, Float.TYPE).put(Float.TYPE, Float.TYPE).put(Double.class, Double.TYPE).put(Double.TYPE, Double.TYPE).put(Boolean.class, Boolean.TYPE).put(Boolean.TYPE, Boolean.TYPE).put(Character.class, Character.TYPE).put(Character.TYPE, Character.TYPE).build();
    private static final SerializeConfig CONFIG = new SerializeConfig();

    public static boolean isJsonObject(String str) {
        return str.matches(JSON_OBJECT_PATTERN);
    }

    public static boolean isJsonArray(String str) {
        return str.matches(JSON_ARRAY_PATTERN);
    }

    public static Object fromJsonString(String json, Class<?> targetClazz, Class<?> genericClazz) {
        Object object = BlockJSONUtil.fromJsonString(json, targetClazz);
        return BlockJSONUtil.deserializedGeneric(object, genericClazz);
    }

    public static Object deserializedGeneric(Object object, Class<?> genericClazz) {
        Field[] fields;
        for (Field field : fields = object.getClass().getDeclaredFields()) {
            Result result;
            field.setAccessible(true);
            Object fieldValue = ReflectUtil.getPrivateFieldValue((Object)object, (String)field.getName());
            if (Objects.isNull(fieldValue) || !(result = BlockJSONUtil.needDeserialize(fieldValue.getClass(), field.getType())).isNeed()) continue;
            if (result.isObject()) {
                Object restoreObject = BlockJSONUtil.fromJsonString(fieldValue.toString(), genericClazz);
                ReflectUtil.setPrivateFieldValue((Object)object, (String)field.getName(), restoreObject);
                continue;
            }
            List<?> restoreArray = BlockJSONUtil.fromJsonArray(fieldValue.toString(), genericClazz);
            ReflectUtil.setPrivateFieldValue((Object)object, (String)field.getName(), restoreArray);
        }
        return object;
    }

    private static Result needDeserialize(Class<?> actualClazz, Class<?> declaredClazz) {
        Class<?> declaredTransfer;
        Class<?> actualTransfer;
        if (actualClazz == declaredClazz) {
            return new Result(false, true);
        }
        if (BlockJSONUtil.isPrimitiveType(actualClazz) && BlockJSONUtil.isPrimitiveType(declaredClazz) && (actualTransfer = PRIMITIVE_TYPE_MAP.get(actualClazz)) == (declaredTransfer = PRIMITIVE_TYPE_MAP.get(declaredClazz))) {
            return new Result(false, true);
        }
        if (com.ygsoft.alibaba.fastjson.JSONObject.class == actualClazz) {
            return new Result(true, true);
        }
        if (JSONObject.class == actualClazz) {
            return new Result(true, true);
        }
        if (com.ygsoft.alibaba.fastjson.JSONArray.class == actualClazz) {
            return new Result(true, false);
        }
        if (JSONArray.class == actualClazz) {
            return new Result(true, false);
        }
        if (DataArrayList.class == actualClazz) {
            return new Result(true, false);
        }
        return new Result(false, true);
    }

    private static boolean isPrimitiveType(Class<?> clazz) {
        return PRIMITIVE_TYPE_MAP.containsKey(clazz);
    }

    public static <T> T fromJsonString(String json, Class<T> javaType) {
        return (T)JSONUtil.fromJsonString((String)json, javaType);
    }

    public static <T> T fromJsonStringNotjcls(String json, Class<T> javaType) {
        return (T)JSONUtil.fromJsonString((String)BlockJSONUtil.removeJclsField(json), javaType);
    }

    public static String removeJclsField(String jsonString) {
        String pattern = "\"jcls\"\\s*:\\s*\"[^\"]*\"\\s*";
        Pattern regex = Pattern.compile(pattern);
        Matcher matcher = regex.matcher(jsonString);
        if (matcher.find()) {
            jsonString = matcher.replaceAll("");
        }
        jsonString = jsonString.replaceAll("\\{\\s*,", "\\{");
        jsonString = jsonString.replaceAll("\\s*,\\s*,\\s*", ",");
        jsonString = jsonString.replaceAll(",\\s*}", "\\}");
        return jsonString;
    }

    public static <T> List<T> fromJsonArray(String json, Class<T> javaType) {
        com.ygsoft.alibaba.fastjson.JSONArray jsonArray = com.ygsoft.alibaba.fastjson.JSONObject.parseArray((String)json);
        ArrayList<Object> list = new ArrayList<Object>();
        if (jsonArray != null && jsonArray.size() > 0) {
            for (int i = 0; i < jsonArray.size(); ++i) {
                list.add(jsonArray.getObject(i, javaType));
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toEcpJson(Object object) {
        try (SerializeWriter out = new SerializeWriter();){
            String str;
            JSONSerializer serializer = new JSONSerializer(out, CONFIG);
            serializer.config(SerializerFeature.NotWriteRootClassName, true);
            serializer.config(SerializerFeature.DisableCircularReferenceDetect, true);
            serializer.addFilter((SerializeFilter)DateValueFilter.getInstance());
            serializer.addFilter((SerializeFilter)EnumValueFilter.getInstance());
            serializer.write(object);
            String string = str = out.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toJSONString(Object object) {
        try (SerializeWriter out = new SerializeWriter();){
            String str;
            JSONSerializer serializer = new JSONSerializer(out, CONFIG);
            serializer.config(SerializerFeature.NotWriteRootClassName, true);
            serializer.config(SerializerFeature.DisableCircularReferenceDetect, true);
            serializer.config(SerializerFeature.WriteDateUseDateFormat, true);
            serializer.setDateFormat("yyyy-MM-dd HH:mm:ss");
            serializer.addFilter((SerializeFilter)EnumValueFilter.getInstance());
            serializer.write(object);
            String string = str = out.toString();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toComposerJSONString(Object object) {
        try (SerializeWriter out = new SerializeWriter();){
            String str;
            JSONSerializer serializer = new JSONSerializer(out, CONFIG);
            serializer.config(SerializerFeature.NotWriteRootClassName, true);
            serializer.config(SerializerFeature.DisableCircularReferenceDetect, true);
            serializer.config(SerializerFeature.WriteDateUseDateFormat, true);
            serializer.setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            serializer.addFilter((SerializeFilter)EnumValueFilter.getInstance());
            serializer.write(object);
            String string = str = out.toString();
            return string;
        }
    }

    public static void main(String[] args) {
        java.util.Date d0 = new java.util.Date();
        java.util.Date d1 = new java.util.Date(1645001488310L);
        java.util.Date d2 = (java.util.Date)JSONUtil.fromJsonString((String)"\\/Date(1645001488310+0800)\\/", java.util.Date.class);
        System.out.println("d1 == d2\uff1a" + d1.equals(d2));
        System.out.println("d1.toJsonString:" + JSONUtil.toJsonString((Object)d1));
        System.out.println("d2.toJsonString:" + JSONUtil.toJsonString((Object)d2));
        Date d3 = new Date(d1.getTime());
        Date d4 = (Date)JSONUtil.fromJsonString((String)"\\/Date(1645001488310+0800)\\/", Date.class);
        System.out.println("d3.toJsonString:" + JSONUtil.toJsonString((Object)d3));
        System.out.println("d4.toJsonString:" + JSONUtil.toJsonString((Object)d4));
    }

    static class DateValueFilter
    implements ValueFilter {
        private static final DateValueFilter instance = new DateValueFilter();

        DateValueFilter() {
        }

        public static DateValueFilter getInstance() {
            return instance;
        }

        public Object process(Object object, String name, Object value) {
            if (null != value && this.isDate(value)) {
                return JSONSerializeUtil.dateToJson((Object)value);
            }
            return value;
        }

        private boolean isDate(Object value) {
            if (value instanceof Timestamp) {
                return true;
            }
            if (value instanceof java.util.Date) {
                return true;
            }
            return value instanceof Time;
        }
    }

    static class EnumValueFilter
    implements ValueFilter {
        private static final EnumValueFilter instance = new EnumValueFilter();

        EnumValueFilter() {
        }

        public static EnumValueFilter getInstance() {
            return instance;
        }

        public Object process(Object object, String name, Object value) {
            if (null != value && value instanceof Enum) {
                Enum en = (Enum)value;
                return en.ordinal();
            }
            return value;
        }
    }

    private static class Result {
        private final boolean need;
        private final boolean object;

        public Result(boolean newNeed, boolean newObject) {
            this.need = newNeed;
            this.object = newObject;
        }

        public boolean isNeed() {
            return this.need;
        }

        public boolean isObject() {
            return this.object;
        }
    }
}

