/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.MathUtil;
import java.math.BigDecimal;

public final class BlockMathUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(BlockMathUtil.class);
    private static final int ZERO = 0;
    private static final int SIZE_ONE = 1;

    public static BigDecimal min(BigDecimal decimal1, BigDecimal decimal2) {
        if (null == decimal1) {
            String msg = EcpI18nUtil.localizedString((String)"BlockMathUtil_min_47", (String)"\u53c2\u6570\u9519\u8bef\uff1adecimal1\u4e3a\u7a7a\u3002");
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)(">>>" + msg));
            }
            throw new EmptyValueException("ABC.0001", msg);
        }
        if (null == decimal2) {
            String msg = EcpI18nUtil.localizedString((String)"BlockMathUtil_min_54", (String)"\u53c2\u6570\u9519\u8bef\uff1adecimal2\u4e3a\u7a7a\u3002");
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)(">>>" + msg));
            }
            throw new EmptyValueException("ABC.0001", msg);
        }
        int compare = MathUtil.compare((BigDecimal)decimal1, (BigDecimal)decimal2);
        if (compare > 0) {
            return decimal2;
        }
        return decimal1;
    }

    public static BigDecimal min(BigDecimal ... decimals) {
        if (null == decimals) {
            String msg = EcpI18nUtil.localizedString((String)"BlockMathUtil_min_75", (String)"\u53c2\u6570\u9519\u8bef\uff1adecimals\u4e3a\u7a7a\u3002");
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)(">>>" + msg));
            }
            throw new EmptyValueException("ABC.0001", msg);
        }
        BigDecimal min = decimals[0];
        if (1 == decimals.length) {
            return min;
        }
        for (int i = 1; i < decimals.length; ++i) {
            BigDecimal decimal = decimals[i];
            int compare = MathUtil.compare((BigDecimal)min, (BigDecimal)decimal);
            if (compare <= 0) continue;
            min = decimal;
        }
        return min;
    }
}

