/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.ygsoft.abc.service.exception.AbcValidationException;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.UuidUtil;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;

public final class BlockValidatorUtil {
    private static final String UUID_PATTERN = "^([a-z\\d]{32}|[a-z\\d]{8}-[a-z\\d]{4}-[a-z\\d]{4}-[a-z\\d]{4}-[a-z\\d]{12})$";
    private static final String CHINESE_NAME_PATTERN = "^[\u4e00-\u9fa5]{2,10}$";
    private static final String BIRTHDAY_PATTERN = "^(18|19|20)\\d{2}((0[1-9])|(1[0-2]))(([0-2][1-9])|10|20|30|31)$";
    private static final String PHONE_PATTERN = "^1[3456789]\\d{9}$";
    private static final String EMAIL_PATTERN = "^[\\.A-Za-z0-9_-\u4e00-\u9fa5]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$";
    private static final int CARD_ID_LENGTH_18 = 18;
    private static final int CARD_ID_LENGTH_15 = 15;
    private static final String CARD_PATTERN_18 = "^[1-9]\\d{5}(18|19|20)\\d{2}((0[1-9])|(1[0-2]))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$";
    private static final String CARD_PATTERN_15 = "^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}$";
    private static final List<Integer> CARD_FACTOR = ImmutableList.of((Object)7, (Object)9, (Object)10, (Object)5, (Object)8, (Object)4, (Object)2, (Object)1, (Object)6, (Object)3, (Object)7, (Object)9, (Object[])new Integer[]{10, 5, 8, 4, 2});
    private static final List<String> CARD_PARITY = ImmutableList.of((Object)"1", (Object)"0", (Object)"X", (Object)"9", (Object)"8", (Object)"7", (Object)"6", (Object)"5", (Object)"4", (Object)"3", (Object)"2");
    private static final Map<String, String> PROVINCE_CODE_TO_NAME = ImmutableMap.builder().put((Object)"11", (Object)"\u5317\u4eac").put((Object)"12", (Object)"\u5929\u6d25").put((Object)"13", (Object)"\u6cb3\u5317").put((Object)"14", (Object)"\u5c71\u897f").put((Object)"15", (Object)"\u5185\u8499\u53e4").put((Object)"21", (Object)"\u8fbd\u5b81").put((Object)"22", (Object)"\u5409\u6797").put((Object)"23", (Object)"\u9ed1\u9f99\u6c5f").put((Object)"31", (Object)"\u4e0a\u6d77").put((Object)"32", (Object)"\u6c5f\u82cf").put((Object)"33", (Object)"\u6d59\u6c5f").put((Object)"34", (Object)"\u5b89\u5fbd").put((Object)"35", (Object)"\u798f\u5efa").put((Object)"36", (Object)"\u6c5f\u897f").put((Object)"37", (Object)"\u5c71\u4e1c").put((Object)"41", (Object)"\u6cb3\u5357").put((Object)"42", (Object)"\u6e56\u5317").put((Object)"43", (Object)"\u6e56\u5357").put((Object)"44", (Object)"\u5e7f\u4e1c").put((Object)"45", (Object)"\u5e7f\u897f").put((Object)"46", (Object)"\u6d77\u5357").put((Object)"50", (Object)"\u91cd\u5e86").put((Object)"51", (Object)"\u56db\u5ddd").put((Object)"52", (Object)"\u8d35\u5dde").put((Object)"53", (Object)"\u4e91\u5357").put((Object)"54", (Object)"\u897f\u85cf").put((Object)"61", (Object)"\u9655\u897f").put((Object)"62", (Object)"\u7518\u8083").put((Object)"63", (Object)"\u9752\u6d77").put((Object)"64", (Object)"\u5b81\u590f").put((Object)"65", (Object)"\u65b0\u7586").put((Object)"81", (Object)"\u9999\u6e2f").put((Object)"82", (Object)"\u6fb3\u95e8").build();
    private static final String FILE_NAME_PATTERN = "[^\\\\/:*?\"<>]{1,255}";
    private static final String ALL_NUMBER_PATTERN = "\\d+";

    private BlockValidatorUtil() {
    }

    public static void checkValidResult(BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            String msg = ((ObjectError)bindingResult.getAllErrors().get(0)).getDefaultMessage();
            throw new AbcValidationException("ABC.0041", msg);
        }
    }

    public static boolean validateUuid(String uuid) {
        if (StringUtil.isEmptyString((String)uuid)) {
            return false;
        }
        return uuid.matches(UUID_PATTERN);
    }

    public static boolean validateChineseName(String name) {
        if (StringUtil.isEmptyString((String)name)) {
            return false;
        }
        return name.matches(CHINESE_NAME_PATTERN);
    }

    public static boolean validateCardNo(String cardNo) {
        int length = cardNo.length();
        if (18 == length) {
            if (!BlockValidatorUtil.checkCode(cardNo)) {
                return false;
            }
            String date = cardNo.substring(6, 14);
            if (!BlockValidatorUtil.checkBirthday(date)) {
                return false;
            }
            String provinceCode = cardNo.substring(0, 2);
            return BlockValidatorUtil.checkProvince(provinceCode);
        }
        if (15 == length) {
            return cardNo.matches(CARD_PATTERN_15);
        }
        return false;
    }

    private static boolean checkCode(String cardNo) {
        if (cardNo.matches(CARD_PATTERN_18)) {
            int lastIndex = 17;
            String[] arr = cardNo.split("");
            String code = cardNo.substring(17).toUpperCase();
            int sum = 0;
            for (int i = 0; i < 17; ++i) {
                int current = CastUtil.getInteger(arr[i]);
                sum += current * CARD_FACTOR.get(i);
            }
            int size = CARD_PARITY.size();
            String realCode = CARD_PARITY.get(sum % size);
            if (code.equals(realCode)) {
                return true;
            }
        }
        return false;
    }

    private static boolean checkProvince(String str) {
        return PROVINCE_CODE_TO_NAME.containsKey(str);
    }

    private static boolean checkBirthday(String str) {
        return str.matches(BIRTHDAY_PATTERN);
    }

    public static boolean checkMovetel(String movetel) {
        if (StringUtil.isNullOrTrimEmptyString((String)movetel)) {
            return false;
        }
        return movetel.matches(PHONE_PATTERN);
    }

    public static boolean checkEmail(String email) {
        if (StringUtil.isNullOrTrimEmptyString((String)email)) {
            return false;
        }
        return email.matches(EMAIL_PATTERN);
    }

    public static boolean checkUniqueKey(Map<String, Long> map) {
        for (Map.Entry<String, Long> entry : map.entrySet()) {
            Long value = entry.getValue();
            if (value <= 1L) continue;
            return false;
        }
        return true;
    }

    public static boolean checkFileName(String fileName) {
        return fileName.matches(FILE_NAME_PATTERN);
    }

    public static boolean checkAllNumber(String str) {
        PreconditionUtil.checkNotNull(str, "\u53c2\u6570\u9519\u8bef\uff1astr\u4e3a\u7a7a\u3002");
        return str.matches(ALL_NUMBER_PATTERN);
    }

    public static void main(String[] args) {
        String cardNo = "420102199003076332";
        System.out.println(BlockValidatorUtil.validateCardNo("420102199003076332"));
        System.out.println(BlockValidatorUtil.validateChineseName("\u91cc\u5df4\u5df4"));
        System.out.println(BlockValidatorUtil.checkMovetel("13912349876"));
        String uuid = UuidUtil.newUUID();
        System.out.println(uuid);
        uuid = UUID.randomUUID().toString();
        System.out.println(uuid);
    }
}

