/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.AbcIOException;
import com.ygsoft.ecp.core.framework.web.CookieUtils;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class CaptchaUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(CaptchaUtil.class);
    private static Random random = new Random();
    private static String randString = "0123456789";
    private static final int width = 80;
    private static final int height = 26;
    private static final int lineSize = 40;
    private static final int stringNum = 4;
    private static final int fontSize = 18;
    private static final int maxAge = 300;

    private CaptchaUtil() {
    }

    private static Font getFont() {
        return new Font("Fixedsys", 1, 18);
    }

    private static Color getRandColor(int fc, int bc) {
        int max = 255;
        int nfc = fc;
        int nbc = bc;
        if (fc > 255) {
            nfc = 255;
        }
        if (bc > 255) {
            nbc = 255;
        }
        int r = nfc + random.nextInt(nbc - nfc - 16);
        int g = nfc + random.nextInt(nbc - nfc - 14);
        int b = nfc + random.nextInt(nbc - nfc - 18);
        return new Color(r, g, b);
    }

    public static void generateCaptcha(HttpServletRequest request, HttpServletResponse response) {
        System.setProperty("java.awt.headless", "true");
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setContentType("image/png;charset=UTF-8");
        BufferedImage image = new BufferedImage(80, 26, 4);
        Graphics g = image.getGraphics();
        g.fillRect(0, 0, 80, 26);
        g.setFont(new Font("Times New Roman", 0, 18));
        g.setColor(CaptchaUtil.getRandColor(110, 133));
        for (int i = 0; i <= 40; ++i) {
            CaptchaUtil.drowLine(g);
        }
        String randomString = "";
        for (int i = 1; i <= 4; ++i) {
            randomString = CaptchaUtil.drowString(g, randomString, i);
        }
        request.getSession().setAttribute("validateCode", (Object)randomString);
        CookieUtils.setCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"validateCode", (String)randomString, (int)300);
        g.dispose();
        try {
            ImageIO.write((RenderedImage)image, "PNG", (OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"\u5199\u56fe\u7247\u5931\u8d25\u3002", (Throwable)e);
            }
            throw new AbcIOException("ABC.0014", e);
        }
    }

    private static String drowString(Graphics g, String randomString, int i) {
        g.setFont(CaptchaUtil.getFont());
        g.setColor(new Color(random.nextInt(101), random.nextInt(111), random.nextInt(121)));
        String rand = String.valueOf(CaptchaUtil.getRandomString(random.nextInt(randString.length())));
        randomString = randomString + rand;
        g.translate(random.nextInt(3), random.nextInt(3));
        g.drawString(rand, 13 * i, 16);
        return randomString;
    }

    private static void drowLine(Graphics g) {
        int x = random.nextInt(80);
        int y = random.nextInt(26);
        int xl = random.nextInt(13);
        int yl = random.nextInt(15);
        g.drawLine(x, y, x + xl, y + yl);
    }

    private static String getRandomString(int num) {
        return String.valueOf(randString.charAt(num));
    }
}

