/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.google.common.collect.ImmutableList;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DBKeywordUtil {
    private static final String KEY_WORD_PATH = "classpath:/META-INF/abc-config/keyword.xml";
    private static final Set<String> KEY_WORD_SET = new HashSet<String>();

    private DBKeywordUtil() {
    }

    private static void init() {
        List<String> lines = BlockIOUtil.readLines(KEY_WORD_PATH, true);
        lines.stream().forEach(line -> {
            if (DBKeywordUtil.isRowLine(line)) {
                String keyword = DBKeywordUtil.parseKeyword(line);
                KEY_WORD_SET.add(keyword);
                KEY_WORD_SET.add("`" + keyword + "`");
            }
        });
        System.out.println(KEY_WORD_SET);
    }

    private static boolean isRowLine(String line) {
        return line.contains("<rows");
    }

    private static String parseKeyword(String line) {
        String resultString = null;
        Pattern regex = Pattern.compile("keyword=\"(\\S+)\"");
        Matcher regexMatcher = regex.matcher(line);
        if (regexMatcher.find()) {
            resultString = regexMatcher.group(1);
            return resultString;
        }
        return null;
    }

    public static boolean check(String word) {
        int count = 0;
        for (String keyword : KEY_WORD_SET) {
            if (!keyword.equalsIgnoreCase(word)) continue;
            System.out.println("--------\u5305\u542b\u6570\u636e\u5e93\u5173\u952e\u5b57\uff1a" + keyword);
            ++count;
        }
        return count == 0;
    }

    public static boolean checkWithPath(List<String> paths) {
        for (String path : paths) {
            String text = BlockIOUtil.readText(path);
            Pattern regex = Pattern.compile("CREATE\\s+TABLE\\s+\\S+\\s*\\((.*?)\\)\\s*ENGINE", 34);
            Matcher regexMatcher = regex.matcher(text);
            while (regexMatcher.find()) {
                String[] arr;
                String fieldDef = regexMatcher.group(1);
                for (String str : arr = fieldDef.split(",")) {
                    String fieldName = DBKeywordUtil.parseFieldName(str);
                    if (DBKeywordUtil.check(fieldName)) continue;
                    System.out.println(">>>>>>" + str);
                }
            }
        }
        return true;
    }

    private static String parseFieldName(String text) {
        String[] arr;
        for (String str : arr = text.split("\\s+")) {
            if (StringUtil.isNullOrTrimEmptyString((String)str)) continue;
            return str;
        }
        return null;
    }

    public static boolean checkWithPath(String path) {
        return DBKeywordUtil.checkWithPath((List<String>)ImmutableList.of((Object)path));
    }

    public static void main(String[] args) {
        DBKeywordUtil.check("VALUE");
    }

    static {
        DBKeywordUtil.init();
    }
}

