/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.ecp.service.tool.StringUtil;
import org.apache.commons.lang3.StringUtils;

public final class DesensUtil {
    private DesensUtil() {
    }

    public static String displayMobile(String mobile) {
        int minLength = 8;
        if (StringUtil.isEmpty((String)mobile) || mobile.length() <= 8) {
            return mobile;
        }
        int startLength = 3;
        int endLength = 2;
        return DesensUtil.wordMask(mobile, 3, 2, "*");
    }

    public static String displayTelephone(String telephone) {
        String result;
        if (StringUtil.isEmpty((String)telephone)) {
            return telephone;
        }
        int minLength = 8;
        int startLength = 3;
        int endLength = 4;
        if (telephone.length() > 8) {
            if (telephone.contains("-")) {
                String[] temp = telephone.split("-");
                result = temp[0] + "****" + temp[1].substring(temp[1].length() - 4, temp[1].length());
            } else {
                result = telephone.substring(0, 3) + "****" + telephone.substring(telephone.length() - 4, telephone.length());
            }
        } else {
            result = "****" + telephone.substring(telephone.length() - 4, telephone.length());
        }
        return result;
    }

    public static String displayIDCard(String idCard) {
        if (StringUtil.isEmpty((String)idCard)) {
            return idCard;
        }
        int startLength = 3;
        int endLength = 4;
        return DesensUtil.wordMask(idCard, 3, 4, "*");
    }

    public static String displayBankCard(String cardNo) {
        int minLength = 10;
        if (StringUtil.isEmpty((String)cardNo) || cardNo.length() < 10) {
            return cardNo;
        }
        int startLength = 6;
        int endLength = 4;
        return DesensUtil.wordMask(cardNo, 6, 4, "*");
    }

    public static String displayEmail(String email) {
        if (StringUtil.isEmpty((String)email)) {
            return email;
        }
        String[] temp = email.split("@");
        if (!StringUtil.isNullOrTrimEmptyString((String)temp[0]) && temp[0].length() <= 4) {
            return DesensUtil.wordMask(temp[0], 0, 0, "*") + "@" + temp[1];
        }
        return DesensUtil.wordMask(temp[0], 4, 0, "*") + "@" + temp[1];
    }

    public static String displayName(String name) {
        if (StringUtil.isEmpty((String)name) || name.length() == 1) {
            return name;
        }
        if (name.length() == 2) {
            return "*" + name.substring(1, 2);
        }
        return DesensUtil.wordMask(name, 1, 1, "*");
    }

    public static String displayCvv(String cvv) {
        if (StringUtil.isEmpty((String)cvv)) {
            return cvv;
        }
        return "***";
    }

    public static String displayExpdate(String expdate) {
        if (StringUtil.isEmpty((String)expdate)) {
            return expdate;
        }
        return DesensUtil.wordMask(expdate, 2, 2, "*");
    }

    public static String wordMask(String word, int startLength, int endLength, String fillChar) {
        if (StringUtil.isNullOrTrimEmptyString((String)word)) {
            return "";
        }
        if (startLength + endLength > word.length()) {
            return StringUtils.leftPad((String)"", (int)(word.length() - 1), (String)fillChar);
        }
        String startStr = word.substring(0, startLength);
        String endStr = word.substring(word.length() - endLength, word.length());
        return startStr + StringUtils.leftPad((String)"", (int)(word.length() - startLength - endLength), (String)fillChar) + endStr;
    }
}

