/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.google.common.collect.Lists;
import com.ygsoft.abc.service.document.util.BeetlUtil;
import com.ygsoft.abc.service.exception.CheckFailedException;
import com.ygsoft.abc.service.exception.ExcelAnalysisException;
import com.ygsoft.abc.service.tool.BlockDateTimeUtil;
import com.ygsoft.abc.service.tool.BlockDateUtil;
import com.ygsoft.abc.service.tool.CommonUtil;
import com.ygsoft.abc.service.tool.ObjectPropertyUtil;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.abc.service.types.YesnoEnum;
import com.ygsoft.ecp.framework.util.DateSerializeUtil;
import com.ygsoft.ecp.service.exception.EcpCheckException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.ConvertUtil;
import com.ygsoft.ecp.service.tool.StreamUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.web.spring.util.ObjectUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelPOIUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ExcelPOIUtil.class);
    private static final Pattern CONTAINS_ARR_PATTERN = Pattern.compile("\\[\\d+\\]");
    private static final Pattern END_WITH_ARR_PATTERN = Pattern.compile("\\[\\d+\\]$");
    private static final String NULL_STR = "NULL";
    private static final String SUCCESS_STR = "success";
    private static final String ERR_MSG_STR = "errMsg";

    private ExcelPOIUtil() {
    }

    public static <T> byte[] renderExcel(InputStream in, T templateParam) {
        if (null == in) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2in\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Workbook workbook = ExcelPOIUtil.getWorkbook(in);
        if (null != templateParam) {
            TemplateUtil.renderExcelWithParam(workbook, templateParam);
        }
        return ExcelPOIUtil.transWorkBook2Byte(workbook);
    }

    public static <T> byte[] renderExcel(String templatePath, T templateParam) {
        if (StringUtils.isEmpty((CharSequence)templatePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2templatePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Workbook workbook = ExcelPOIUtil.getWorkbook(templatePath);
        if (null != templateParam) {
            TemplateUtil.renderExcelWithParam(workbook, templateParam);
        }
        return ExcelPOIUtil.transWorkBook2Byte(workbook);
    }

    public static Workbook exportExcel4workbookByTemplate(Workbook workbook, List<?> datas, ExportConfig config) {
        return ExcelPOIUtil.setDataIntoWorkbook(workbook, datas, config);
    }

    public static byte[] exportExcel4byteByTemplate(Workbook workbook, List<?> datas, ExportConfig config) {
        ExcelPOIUtil.setDataIntoWorkbook(workbook, datas, config);
        return ExcelPOIUtil.transWorkBook2Byte(workbook);
    }

    protected static Workbook setDataIntoWorkbook(Workbook workbook, List<?> datas, ExportConfig config) {
        if (null == workbook) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2workbook\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (CollectionUtils.isEmpty(datas)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2datas\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == config) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2ExportConfig\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        int sheetIndex = config.getSheetIndex();
        Sheet sheet = workbook.getSheetAt(sheetIndex);
        if (null == sheet) {
            throw new EcpCheckException("ABC.0048", "\u83b7\u53d6sheet\u5931\u8d25\u3002");
        }
        Integer configRowIndex = config.getConfigRowIndex();
        Row configRow = sheet.getRow(configRowIndex.intValue());
        if (null == configRow) {
            throw new EcpCheckException("ABC.0048", "\u83b7\u53d6\u914d\u7f6e\u884c\u4fe1\u606f\u5931\u8d25\u3002");
        }
        int maxColumnCount = null != config.getMaxColumnCount() ? config.getMaxColumnCount().intValue() : configRow.getLastCellNum();
        Map<String, String> columnMap = TemplateUtil.getConfigMap(configRow, maxColumnCount);
        if (ObjectUtils.isEmpty(columnMap)) {
            throw new EcpCheckException("ABC.0048", "\u914d\u7f6e\u884c\u4fe1\u606f\u8f6c\u6362\u5931\u8d25\u3002");
        }
        Map<String, CellStyle> cellStyleMap = TemplateUtil.getCellStyleMap(configRow, maxColumnCount);
        int rowIndex = configRowIndex;
        for (Object bean : datas) {
            Map<String, List<String>> propertyMap = TemplateUtil.getPropertyMap(columnMap, bean);
            int rowCounts = propertyMap.values().stream().mapToInt(List::size).max().getAsInt();
            for (int r = 0; r < rowCounts; ++r) {
                Row row = sheet.createRow(rowIndex);
                for (int i = 0; i < maxColumnCount; ++i) {
                    List<String> newProperties;
                    int offset;
                    String propertyName;
                    List<String> properties;
                    Cell cell = row.createCell(i);
                    String key = String.valueOf(i);
                    if (cellStyleMap.containsKey(key)) {
                        cell.setCellStyle(cellStyleMap.get(key));
                    }
                    if (!columnMap.containsKey(key) || r >= (properties = propertyMap.get(key)).size() || NULL_STR.equals(propertyName = properties.get(r))) continue;
                    String value = ObjectPropertyUtil.convert(ObjectPropertyUtil.getValue(bean, propertyName));
                    cell.setCellValue(value);
                    if (config.getCellStrategyMap().containsKey(propertyName)) {
                        ICustomCellStrategy styleStrategy = config.getCellStrategyMap().get(propertyName);
                        styleStrategy.configCell(workbook, cell);
                    }
                    if ((offset = TemplateUtil.getMaxChildCounts(propertyName, propertyMap) - 1) <= 0) continue;
                    if (BlankCellHandleStrategyEnum.OFFSET == config.getStrategy()) {
                        newProperties = TemplateUtil.getOffsetListWithBlankValue(properties, propertyName, offset);
                        propertyMap.put(key, newProperties);
                        continue;
                    }
                    if (BlankCellHandleStrategyEnum.FILL == config.getStrategy()) {
                        newProperties = TemplateUtil.getOffsetListWithSameValue(properties, propertyName, offset);
                        propertyMap.put(key, newProperties);
                        continue;
                    }
                    if (BlankCellHandleStrategyEnum.MERGE == config.getStrategy()) {
                        newProperties = TemplateUtil.getOffsetListWithBlankValue(properties, propertyName, offset);
                        propertyMap.put(key, newProperties);
                        CellRangeAddress mergeAddress = new CellRangeAddress(rowIndex, rowIndex + offset, i, i);
                        sheet.addMergedRegion(mergeAddress);
                        continue;
                    }
                    throw CheckFailedException.newInstance("\u6682\u4e0d\u652f\u6301\u7684\u5408\u5e76\u7b56\u7565\u3002");
                }
                ++rowIndex;
            }
        }
        return workbook;
    }

    @Deprecated
    public static byte[] exportExcelByWorkBookTemplate(Workbook workbook, List<?> datas, ExportConfig config) {
        ExcelPOIUtil.setDataIntoWorkbook(workbook, datas, config);
        return ExcelPOIUtil.transWorkBook2Byte(workbook);
    }

    @Deprecated
    public static <T extends Serializable> byte[] exportExcel2003(List<T> datas, String rulePath) {
        if (CollectionUtils.isEmpty(datas)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2datas\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        return ExcelPOIUtil.getExcelData(datas, rulePath, (Workbook)workbook);
    }

    @Deprecated
    public static <T extends Serializable> byte[] exportExcel2007(List<T> datas, String rulePath) {
        if (CollectionUtils.isEmpty(datas)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2datas\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        XSSFWorkbook workbook = new XSSFWorkbook();
        return ExcelPOIUtil.getExcelData(datas, rulePath, (Workbook)workbook);
    }

    protected static <T extends Serializable> byte[] getExcelData(List<T> datas, String rulePath, Workbook workbook) {
        if (CollectionUtils.isEmpty(datas)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2datas\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == workbook) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2workbook\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        List<Rule> rules = ExcelPOIUtil.getRuleList(rulePath);
        ExcelPOIUtil.writeExcelBody(workbook, rules, datas);
        return ExcelPOIUtil.transWorkBook2Byte(workbook);
    }

    protected static <T extends Serializable> void writeExcelBody(Workbook workbook, List<Rule> rules, List<T> datas) {
        Sheet sheet = workbook.createSheet("Sheet1");
        List columnNames = rules.stream().map(Rule::getColumnName).collect(Collectors.toList());
        Map<String, Rule> ruleMap = ExcelPOIUtil.getRuleMap(rules);
        Map<String, CellStyle> cellStyleMap = ExportUtil.createCellStyleByRules(workbook, rules);
        AtomicIntegerArray maxCellWidth = ExportUtil.wirteExcelTitle(sheet, rules);
        int rowIndex = 1;
        for (Serializable bean : datas) {
            JSONObject obj = JSON.parseObject((String)JSON.toJSONString((Object)bean));
            Row row = sheet.createRow(rowIndex++);
            obj.forEach((columnName, value) -> {
                if (!columnNames.contains(columnName)) {
                    return;
                }
                Rule rule = (Rule)ruleMap.get(columnName);
                String cellValue = ExportUtil.castObject2StringByRule(value, rule);
                int columnIndex = columnNames.indexOf(columnName);
                Cell cell = row.createCell(columnIndex);
                cell.setCellValue(cellValue);
                cell.setCellStyle((CellStyle)cellStyleMap.get(columnName));
                int width = ExportUtil.getCellWidth(cellValue, ExportConst.BODY_FONT_SIZE);
                if (width > maxCellWidth.get(columnIndex)) {
                    maxCellWidth.getAndSet(columnIndex, width);
                }
            });
        }
        rules.forEach(rule -> {
            int columnIndex = rules.indexOf(rule);
            sheet.setColumnWidth(columnIndex, maxCellWidth.get(columnIndex));
        });
    }

    public static <T> List<T> importExcel(InputStream in, String rulePath, Class<T> clazz) {
        if (null == in) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2in\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == clazz) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2clazz\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Workbook wk = ExcelPOIUtil.getWorkbook(in);
        return ExcelPOIUtil.readExcelData(wk, rulePath, clazz);
    }

    public static <T> List<T> importExcel(byte[] excelBytes, String rulePath, Class<T> clazz) {
        if (null == excelBytes || excelBytes.length <= 0) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2excelBytes\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == clazz) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2clazz\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        ByteArrayInputStream in = new ByteArrayInputStream(excelBytes);
        Workbook wk = ExcelPOIUtil.getWorkbook(in);
        return ExcelPOIUtil.readExcelData(wk, rulePath, clazz);
    }

    public static <T> List<T> importExcel(String filePath, String rulePath, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2filePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == clazz) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2clazz\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Workbook wk = ExcelPOIUtil.getWorkbook(filePath);
        return ExcelPOIUtil.readExcelData(wk, rulePath, clazz);
    }

    public static List<Map<String, Object>> importExcelWithValid(InputStream in, String rulePath, ExcelRowCheckFunction<Map> fun) {
        if (null == in) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2in\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Workbook wk = ExcelPOIUtil.getWorkbook(in);
        Sheet sheet = ImportUtil.getSheet(wk, "");
        List<Rule> rules = ExcelPOIUtil.getRuleList(rulePath);
        Row header = ImportUtil.getHeaderRow(sheet, null, rules.size());
        ImportUtil.checkHeader(header, rules);
        return ExcelPOIUtil.readExcelDataWithValid(sheet, rules, header.getRowNum() + 1, Map.class, fun);
    }

    public static List<Map<String, Object>> importExcelWithValid(InputStream in, String rulePath, ExcelRowCheckFunction<Map> fun, String configPath) {
        Row header;
        Sheet sheet;
        if (null == in) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2in\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Workbook wk = ExcelPOIUtil.getWorkbook(in);
        List<Rule> rules = ExcelPOIUtil.getRuleList(rulePath);
        if (StringUtils.isNotEmpty((CharSequence)configPath)) {
            ImportConfig config = ImportUtil.getImportConfig(configPath);
            sheet = ImportUtil.getSheet(wk, config);
            header = ImportUtil.getHeaderRow(sheet, config, rules.size());
            if (config.getCheckHeader().booleanValue()) {
                ImportUtil.checkHeader(header, rules);
            }
        } else {
            sheet = ImportUtil.getSheet(wk, "");
            header = ImportUtil.getHeaderRow(sheet, null, rules.size());
            ImportUtil.checkHeader(header, rules);
        }
        return ExcelPOIUtil.readExcelDataWithValid(sheet, rules, header.getRowNum() + 1, Map.class, fun);
    }

    public static List<Map<String, Object>> importExcelWithValid(InputStream in, String rulePath, String sheetName, ExcelRowCheckFunction<Map> fun) {
        if (null == in) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2in\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Workbook wk = ExcelPOIUtil.getWorkbook(in);
        Sheet sheet = ImportUtil.getSheet(wk, sheetName);
        List<Rule> rules = ExcelPOIUtil.getRuleList(rulePath);
        Row header = ImportUtil.getHeaderRow(sheet, null, rules.size());
        ImportUtil.checkHeader(header, rules);
        return ExcelPOIUtil.readExcelDataWithValid(sheet, rules, header.getRowNum() + 1, Map.class, fun);
    }

    public static <T extends ValidBaseResult> List<T> importExcelWithValid(InputStream in, String rulePath, Class<T> clazz, ExcelRowCheckFunction<T> fun) {
        if (null == in) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2in\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == clazz) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2clazz\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Workbook wk = ExcelPOIUtil.getWorkbook(in);
        Sheet sheet = ImportUtil.getSheet(wk, "");
        List<Rule> rules = ExcelPOIUtil.getRuleList(rulePath);
        Row header = ImportUtil.getHeaderRow(sheet, null, rules.size());
        ImportUtil.checkHeader(header, rules);
        List<Map<String, Object>> datas = ExcelPOIUtil.readExcelDataWithValid(sheet, rules, header.getRowNum() + 1, clazz, fun);
        return JSON.parseArray((String)JSON.toJSONString(datas), clazz);
    }

    public static <T extends ValidBaseResult> List<T> importExcelWithValid(InputStream in, String rulePath, Class<T> clazz, ExcelRowCheckFunction<T> fun, String configPath) {
        Row header;
        Sheet sheet;
        if (null == in) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2in\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Workbook wk = ExcelPOIUtil.getWorkbook(in);
        List<Rule> rules = ExcelPOIUtil.getRuleList(rulePath);
        if (StringUtils.isNotEmpty((CharSequence)configPath)) {
            ImportConfig config = ImportUtil.getImportConfig(configPath);
            sheet = ImportUtil.getSheet(wk, config);
            header = ImportUtil.getHeaderRow(sheet, config, rules.size());
            if (config.getCheckHeader().booleanValue()) {
                ImportUtil.checkHeader(header, rules);
            }
        } else {
            sheet = ImportUtil.getSheet(wk, "");
            header = ImportUtil.getHeaderRow(sheet, null, rules.size());
            ImportUtil.checkHeader(header, rules);
        }
        List<Map<String, Object>> datas = ExcelPOIUtil.readExcelDataWithValid(sheet, rules, header.getRowNum() + 1, clazz, fun);
        return JSON.parseArray((String)JSON.toJSONString(datas), clazz);
    }

    public static <T extends ValidBaseResult> List<T> importExcelWithValid(InputStream in, String rulePath, String sheetName, Class<T> clazz, ExcelRowCheckFunction<T> fun) {
        if (null == in) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2in\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == clazz) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2clazz\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Workbook wk = ExcelPOIUtil.getWorkbook(in);
        Sheet sheet = ImportUtil.getSheet(wk, sheetName);
        List<Rule> rules = ExcelPOIUtil.getRuleList(rulePath);
        Row header = ImportUtil.getHeaderRow(sheet, null, rules.size());
        ImportUtil.checkHeader(header, rules);
        List<Map<String, Object>> datas = ExcelPOIUtil.readExcelDataWithValid(sheet, rules, header.getRowNum() + 1, clazz, fun);
        return JSON.parseArray((String)JSON.toJSONString(datas), clazz);
    }

    public static List<Map<String, Object>> importExcelWithValid(String filePath, String rulePath, ExcelRowCheckFunction<Map> fun) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2filePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Workbook wk = ExcelPOIUtil.getWorkbook(filePath);
        Sheet sheet = ImportUtil.getSheet(wk, "");
        List<Rule> rules = ExcelPOIUtil.getRuleList(rulePath);
        Row header = ImportUtil.getHeaderRow(sheet, null, rules.size());
        ImportUtil.checkHeader(header, rules);
        return ExcelPOIUtil.readExcelDataWithValid(sheet, rules, header.getRowNum() + 1, Map.class, fun);
    }

    public static List<Map<String, Object>> importExcelWithValid(String filePath, String rulePath, ExcelRowCheckFunction<Map> fun, String configPath) {
        Row header;
        Sheet sheet;
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2filePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Workbook wk = ExcelPOIUtil.getWorkbook(filePath);
        List<Rule> rules = ExcelPOIUtil.getRuleList(rulePath);
        if (StringUtils.isNotEmpty((CharSequence)configPath)) {
            ImportConfig config = ImportUtil.getImportConfig(configPath);
            sheet = ImportUtil.getSheet(wk, config);
            header = ImportUtil.getHeaderRow(sheet, config, rules.size());
            if (config.getCheckHeader().booleanValue()) {
                ImportUtil.checkHeader(header, rules);
            }
        } else {
            sheet = ImportUtil.getSheet(wk, "");
            header = ImportUtil.getHeaderRow(sheet, null, rules.size());
            ImportUtil.checkHeader(header, rules);
        }
        return ExcelPOIUtil.readExcelDataWithValid(sheet, rules, header.getRowNum() + 1, Map.class, fun);
    }

    public static List<Map<String, Object>> importExcelWithValid(String filePath, String rulePath, String sheetName, ExcelRowCheckFunction<Map> fun) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2filePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Workbook wk = ExcelPOIUtil.getWorkbook(filePath);
        Sheet sheet = ImportUtil.getSheet(wk, sheetName);
        List<Rule> rules = ExcelPOIUtil.getRuleList(rulePath);
        Row header = ImportUtil.getHeaderRow(sheet, null, rules.size());
        ImportUtil.checkHeader(header, rules);
        return ExcelPOIUtil.readExcelDataWithValid(sheet, rules, header.getRowNum() + 1, Map.class, fun);
    }

    public static <T extends ValidBaseResult> List<T> importExcelWithValid(String filePath, String rulePath, Class<T> clazz, ExcelRowCheckFunction<T> fun) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2filePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == clazz) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2clazz\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Workbook wk = ExcelPOIUtil.getWorkbook(filePath);
        Sheet sheet = ImportUtil.getSheet(wk, "");
        List<Rule> rules = ExcelPOIUtil.getRuleList(rulePath);
        Row header = ImportUtil.getHeaderRow(sheet, null, rules.size());
        ImportUtil.checkHeader(header, rules);
        List<Map<String, Object>> datas = ExcelPOIUtil.readExcelDataWithValid(sheet, rules, header.getRowNum() + 1, clazz, fun);
        return JSON.parseArray((String)JSON.toJSONString(datas), clazz);
    }

    public static <T extends ValidBaseResult> List<T> importExcelWithValid(String filePath, String rulePath, Class<T> clazz, ExcelRowCheckFunction<T> fun, String configPath) {
        Row header;
        Sheet sheet;
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2filePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Workbook wk = ExcelPOIUtil.getWorkbook(filePath);
        List<Rule> rules = ExcelPOIUtil.getRuleList(rulePath);
        if (StringUtils.isNotEmpty((CharSequence)configPath)) {
            ImportConfig config = ImportUtil.getImportConfig(configPath);
            sheet = ImportUtil.getSheet(wk, config);
            header = ImportUtil.getHeaderRow(sheet, config, rules.size());
            if (config.getCheckHeader().booleanValue()) {
                ImportUtil.checkHeader(header, rules);
            }
        } else {
            sheet = ImportUtil.getSheet(wk, "");
            header = ImportUtil.getHeaderRow(sheet, null, rules.size());
            ImportUtil.checkHeader(header, rules);
        }
        List<Map<String, Object>> datas = ExcelPOIUtil.readExcelDataWithValid(sheet, rules, header.getRowNum() + 1, clazz, fun);
        return JSON.parseArray((String)JSON.toJSONString(datas), clazz);
    }

    public static <T extends ValidBaseResult> List<T> importExcelWithValid(String filePath, String rulePath, String sheetName, Class<T> clazz, ExcelRowCheckFunction<T> fun) {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2filePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == clazz) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2clazz\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        Workbook wk = ExcelPOIUtil.getWorkbook(filePath);
        Sheet sheet = ImportUtil.getSheet(wk, sheetName);
        List<Rule> rules = ExcelPOIUtil.getRuleList(rulePath);
        Row header = ImportUtil.getHeaderRow(sheet, null, rules.size());
        ImportUtil.checkHeader(header, rules);
        List<Map<String, Object>> datas = ExcelPOIUtil.readExcelDataWithValid(sheet, rules, header.getRowNum() + 1, clazz, fun);
        return JSON.parseArray((String)JSON.toJSONString(datas), clazz);
    }

    protected static <T> List<T> readExcelData(Workbook wk, String rulePath, Class<T> clazz) {
        Row row;
        if (null == wk) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2Workbook\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (null == clazz) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2clazz\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        List<Rule> rules = ExcelPOIUtil.getRuleList(rulePath);
        Sheet sheet = wk.getSheetAt(0);
        Row header = sheet.getRow(0);
        ImportUtil.checkHeader(header, rules);
        int rowNums = sheet.getLastRowNum() + 1;
        int cellNums = header.getLastCellNum();
        ArrayList list = new ArrayList();
        for (int i = 1; i < rowNums && null != (row = sheet.getRow(i)) && row.getFirstCellNum() >= 0; ++i) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (int j = 0; j < cellNums; ++j) {
                Cell cell = row.getCell(j);
                Rule rule = rules.get(j);
                String columnName = rule.getColumnName();
                map.put(columnName, ImportUtil.getCellValue(cell, rule));
            }
            list.add(map);
        }
        return JSON.parseArray((String)JSON.toJSONString(list), clazz);
    }

    protected static <T> List<Map<String, Object>> readExcelDataWithValid(Sheet sheet, List<Rule> rules, int startRowIndex, Class<T> clazz, ExcelRowCheckFunction<T> fun) {
        Row row;
        int rowNums = sheet.getLastRowNum() + 1;
        if (startRowIndex > rowNums) {
            throw new EcpCheckException("Excel_Data_Read_Failed", "\u6570\u636e\u5f00\u59cb\u884c\u5927\u4e8e\u603b\u884c\u6570\u3002");
        }
        int cellNums = rules.size();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        ArrayList<String> uniqueKeyList = new ArrayList<String>();
        String uniqueKeyDesc = ImportRowValidator.getUniqueKeyDesc(rules);
        for (int i = startRowIndex; i < rowNums && null != (row = sheet.getRow(i)) && row.getFirstCellNum() >= 0; ++i) {
            String checkFailedMsg;
            int blankCellCount = 0;
            HashMap<String, Object> map = new HashMap<String, Object>();
            StringBuilder rowErrorMsg = new StringBuilder();
            StringBuilder cellErrorMsg = new StringBuilder();
            for (int j = 0; j < cellNums; ++j) {
                Cell cell = row.getCell(j);
                Rule rule = rules.get(j);
                Object cellValue = null;
                try {
                    cellValue = ImportUtil.getCellValue(cell, rule);
                    if (null == cellValue || StringUtils.isEmpty((CharSequence)cellValue.toString())) {
                        ++blankCellCount;
                    }
                    cellValue = ExcelPOIUtil.replaceUnallowableCharToEmpty(cellValue);
                }
                catch (EcpCheckException e) {
                    LOG.error((Object)">>>>>\u83b7\u53d6\u5355\u5143\u683c\u7684\u503c\u5f02\u5e38>>>>>", (Throwable)e);
                    cellErrorMsg.append(rule.getColumnText()).append(e.getMessage());
                    continue;
                }
                catch (Exception ex) {
                    LOG.error((Object)">>>>>>\u83b7\u53d6\u5355\u5143\u683c\u7684\u503c\u5f02\u5e38>>>>>>", (Throwable)ex);
                    cellErrorMsg.append(rule.getColumnText()).append("\u5185\u5bb9\u4e0e\u5355\u5143\u683c\u683c\u5f0f\u4e0d\u7b26\u3002");
                    continue;
                }
                map.put(rule.getColumnName(), cellValue);
                String errMsg = ImportCellValidator.validateForCommon(rule, cellValue);
                if (!StringUtils.isNotEmpty((CharSequence)errMsg)) continue;
                cellErrorMsg.append(errMsg);
            }
            if (blankCellCount == cellNums) break;
            String uniqueKey = ImportRowValidator.buildUniqueKey(row, rules);
            String errMsg = ImportRowValidator.validateUniqueKey(uniqueKey, uniqueKeyList, uniqueKeyDesc);
            if (StringUtils.isNotEmpty((CharSequence)errMsg)) {
                rowErrorMsg.append(errMsg);
            }
            if (StringUtils.isNotEmpty((CharSequence)cellErrorMsg.toString())) {
                rowErrorMsg.append(cellErrorMsg.toString());
            }
            if (null != fun && StringUtils.isNotEmpty((CharSequence)(checkFailedMsg = fun.check(JSON.parseObject((String)JSON.toJSONString(map), clazz))))) {
                rowErrorMsg.append(checkFailedMsg);
            }
            if (StringUtils.isNotEmpty((CharSequence)rowErrorMsg.toString())) {
                map.put(SUCCESS_STR, false);
                map.put(ERR_MSG_STR, rowErrorMsg.toString());
            } else {
                map.put(SUCCESS_STR, true);
            }
            list.add(map);
        }
        return list;
    }

    public static Object replaceUnallowableCharToEmpty(Object cellValue) {
        String configVal = PropertyConfigUtil.getProperty("abc.excel.specialchar.replaceempty");
        if (StringUtil.isNullOrTrimEmptyString((String)configVal) || "false".equals(configVal)) {
            return cellValue;
        }
        if (!ImportUtil.isNull(cellValue) && ImportConst.ILLEGAL_CHAR_PATTERN.matcher(cellValue.toString()).find()) {
            return ImportConst.ILLEGAL_CHAR_PATTERN.matcher(cellValue.toString()).replaceAll("");
        }
        return cellValue;
    }

    public static Workbook getWorkbook(String path) {
        Workbook workbook;
        if (StringUtils.isEmpty((CharSequence)path)) {
            throw new EcpCheckException("Excel_Workbook_Get_Failed", "\u6587\u4ef6\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new EcpCheckException("Excel_Workbook_Get_Failed", "\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u8def\u5f84\u3002");
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            workbook = WorkbookFactory.create((InputStream)in);
        }
        catch (Exception e) {
            try {
                throw new ExcelAnalysisException("Excel_Workbook_Get_Failed", "Workbook\u83b7\u53d6\u5931\u8d25\u3002");
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(in);
                throw throwable;
            }
        }
        StreamUtil.closeStream((InputStream)in);
        return workbook;
    }

    public static Workbook getWorkbookForClassPath(String classPath) {
        InputStream in = null;
        try {
            in = ExcelPOIUtil.class.getResourceAsStream(classPath);
            Workbook workbook = WorkbookFactory.create((InputStream)in);
            return workbook;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new EcpCheckException("Excel_Workbook_Get_Failed", "Workbook\u83b7\u53d6\u5931\u8d25\u3002");
        }
        finally {
            StreamUtil.closeStream((InputStream)in);
        }
    }

    public static Workbook getWorkbook(InputStream in) {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)in);
            return workbook;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new ExcelAnalysisException("Excel_Workbook_Get_Failed", "Workbook\u83b7\u53d6\u5931\u8d25\u3002");
        }
        finally {
            StreamUtil.closeStream((InputStream)in);
        }
    }

    public static List<Rule> getRuleList(String rulePath) {
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        try {
            InputStream in = ExcelPOIUtil.class.getResourceAsStream(rulePath);
            String fileContent = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            fileContent = fileContent.replaceAll("\n", "");
            return JSON.parseArray((String)fileContent, Rule.class);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            String msg = "\u89e3\u6790\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\u3002";
            throw new EcpCheckException("\u5bfc\u5165\u51fa\u9519", "\u89e3\u6790\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\u3002");
        }
    }

    public static void closeWorkBook(Workbook workbook) {
        block2: {
            try {
                workbook.close();
            }
            catch (IOException e) {
                if (!LOG.isInfoEnabled()) break block2;
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public static Map<String, Rule> getRuleMap(String rulePath) {
        if (StringUtils.isEmpty((CharSequence)rulePath)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        List<Rule> list = ExcelPOIUtil.getRuleList(rulePath);
        return list.stream().collect(Collectors.toMap(Rule::getColumnName, Function.identity()));
    }

    public static Map<String, Rule> getRuleMap(List<Rule> rules) {
        if (CollectionUtils.isEmpty(rules)) {
            throw new EcpCheckException("ABC.0048", "\u5165\u53c2rules\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        return rules.stream().collect(Collectors.toMap(Rule::getColumnName, Function.identity()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] transWorkBook2Byte(Workbook workbook) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)os);
            os.flush();
            byte[] byArray = os.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            byte[] byArray = null;
            return byArray;
        }
        finally {
            StreamUtil.closeStream((OutputStream)os);
            ExcelPOIUtil.closeWorkBook(workbook);
        }
    }

    public static interface ICustomCellStrategy {
        public void configCell(Workbook var1, Cell var2);
    }

    public static enum BlankCellHandleStrategyEnum {
        OFFSET,
        FILL,
        MERGE;

    }

    public static class ExportConfig
    implements Serializable {
        private static final long serialVersionUID = 2331687314503873621L;
        private Integer sheetIndex = 0;
        private Integer configRowIndex = 1;
        private Integer maxColumnCount;
        private BlankCellHandleStrategyEnum strategy = BlankCellHandleStrategyEnum.OFFSET;
        private Map<String, ICustomCellStrategy> cellStrategyMap = new HashMap<String, ICustomCellStrategy>();

        public Map<String, ICustomCellStrategy> getCellStrategyMap() {
            return this.cellStrategyMap;
        }

        public void setCellStrategyMap(Map<String, ICustomCellStrategy> cellStrategyMap) {
            this.cellStrategyMap = cellStrategyMap;
        }

        public BlankCellHandleStrategyEnum getStrategy() {
            return this.strategy;
        }

        public void setStrategy(BlankCellHandleStrategyEnum strategy) {
            this.strategy = strategy;
        }

        public Integer getSheetIndex() {
            return this.sheetIndex;
        }

        public void setSheetIndex(Integer sheetIndex) {
            this.sheetIndex = sheetIndex;
        }

        public Integer getConfigRowIndex() {
            return this.configRowIndex;
        }

        public void setConfigRowIndex(Integer configRowIndex) {
            this.configRowIndex = configRowIndex;
        }

        public Integer getMaxColumnCount() {
            return this.maxColumnCount;
        }

        public void setMaxColumnCount(Integer maxColumnCount) {
            this.maxColumnCount = maxColumnCount;
        }
    }

    public static class ValidBaseResult
    implements Serializable {
        private static final long serialVersionUID = -7267544171655229791L;
        private boolean success;
        private String errMsg;

        public boolean isSuccess() {
            return this.success;
        }

        public void setSuccess(boolean success) {
            this.success = success;
        }

        public String getErrMsg() {
            return this.errMsg;
        }

        public void setErrMsg(String errMsg) {
            this.errMsg = errMsg;
        }
    }

    public static interface ExcelRowCheckFunction<T> {
        public String check(T var1);
    }

    public static class ImportConfig
    implements Serializable {
        private static final long serialVersionUID = -3974378800459554775L;
        private Integer sheetIndex;
        private String sheetName;
        private Boolean checkHeader = false;
        private Boolean isMultiHeader = false;
        private Integer headerStartIndex = 0;
        private Integer headerEndIndex = 0;
        private Boolean isMergeMultiHeaderValue = false;

        public Integer getSheetIndex() {
            return this.sheetIndex;
        }

        public void setSheetIndex(Integer sheetIndex) {
            this.sheetIndex = sheetIndex;
        }

        public String getSheetName() {
            return this.sheetName;
        }

        public void setSheetName(String sheetName) {
            this.sheetName = sheetName;
        }

        public Boolean getCheckHeader() {
            return this.checkHeader;
        }

        public void setCheckHeader(Boolean checkHeader) {
            this.checkHeader = checkHeader;
        }

        public Boolean getIsMultiHeader() {
            return this.isMultiHeader;
        }

        public void setIsMultiHeader(Boolean isMultiHeader) {
            this.isMultiHeader = isMultiHeader;
        }

        public Integer getHeaderStartIndex() {
            return this.headerStartIndex;
        }

        public void setHeaderStartIndex(Integer headerStartIndex) {
            this.headerStartIndex = headerStartIndex;
        }

        public Integer getHeaderEndIndex() {
            return this.headerEndIndex;
        }

        public void setHeaderEndIndex(Integer headerEndIndex) {
            this.headerEndIndex = headerEndIndex;
        }

        public Boolean getIsMergeMultiHeaderValue() {
            return this.isMergeMultiHeaderValue;
        }

        public void setIsMergeMultiHeaderValue(Boolean isMergeMultiHeaderValue) {
            this.isMergeMultiHeaderValue = isMergeMultiHeaderValue;
        }
    }

    public static class Rule
    implements Serializable {
        private static final long serialVersionUID = -7751892101283168918L;
        private String columnName;
        private String columnText;
        private String columnType;
        private String pattern;
        private Integer scale;
        private boolean isWrapText = true;
        private boolean required = false;
        private boolean uniqueCheck = false;
        private Integer length;

        public String getColumnName() {
            return this.columnName;
        }

        public void setColumnName(String columnName) {
            this.columnName = columnName;
        }

        public String getColumnText() {
            return this.columnText;
        }

        public void setColumnText(String columnText) {
            this.columnText = columnText;
        }

        public String getColumnType() {
            return this.columnType;
        }

        public void setColumnType(String columnType) {
            this.columnType = columnType;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public Integer getScale() {
            return this.scale;
        }

        public void setScale(Integer scale) {
            this.scale = scale;
        }

        public boolean isWrapText() {
            return this.isWrapText;
        }

        public void setWrapText(boolean isWrapText) {
            this.isWrapText = isWrapText;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }

        public boolean isUniqueCheck() {
            return this.uniqueCheck;
        }

        public void setUniqueCheck(boolean uniqueCheck) {
            this.uniqueCheck = uniqueCheck;
        }

        public Integer getLength() {
            return this.length;
        }

        public void setLength(Integer length) {
            this.length = length;
        }
    }

    public static class ImportRowValidator
    implements Serializable {
        private static final long serialVersionUID = -1816646618105736440L;

        public static String getUniqueKeyDesc(List<Rule> rules) {
            StringBuilder sb = new StringBuilder();
            for (Rule rule : rules) {
                if (!rule.isUniqueCheck()) continue;
                sb.append(rule.getColumnText()).append("+");
            }
            String str = sb.toString();
            if (StringUtils.isNotEmpty((CharSequence)str)) {
                str = str.substring(0, str.length() - 1);
            }
            return str;
        }

        public static String buildUniqueKey(Row row, List<Rule> rules) {
            if (null == row || row.getFirstCellNum() < 0) {
                throw new EcpCheckException("Excel_Import_Row_Cannot_Be_Null", "row\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (CollectionUtils.isEmpty(rules)) {
                throw new EcpCheckException("Excel_Import_Rules_Cannot_Be_Null", "rules\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            StringBuilder uniqueKey = new StringBuilder();
            for (int j = 0; j < rules.size(); ++j) {
                Cell cell = row.getCell(j);
                Rule rule = rules.get(j);
                if (!rule.isUniqueCheck()) continue;
                try {
                    Object cellValue = ImportUtil.getCellValue(cell, rule);
                    if (!ImportUtil.isNull(cellValue)) {
                        uniqueKey.append(cellValue);
                        continue;
                    }
                    LOG.warn((Object)String.format(">>>>>>\u6784\u5efa\u552f\u4e00\u7d22\u5f15\uff0c\u5355\u5143\u683c%s\u7684\u503c\u4e3a\u7a7a\uff0c\u884c\u53f7=%s>>>>>>", rule.getColumnText(), row.getRowNum()));
                    continue;
                }
                catch (Exception ex) {
                    LOG.error((Object)">>>>>>\u6784\u5efa\u552f\u4e00\u7d22\u5f15\uff0c\u83b7\u53d6\u5355\u5143\u683c\u7684\u503c\u5f02\u5e38>>>>>>", (Throwable)ex);
                }
            }
            return uniqueKey.toString();
        }

        public static String validateUniqueKey(String uniqueKey, List<String> uniqueKeyList, String uniqueKeyDesc) {
            String errMsg = "";
            if (StringUtils.isNotEmpty((CharSequence)uniqueKey)) {
                if (uniqueKeyList.contains(uniqueKey)) {
                    errMsg = String.format("%s\u4e0d\u80fd\u91cd\u590d\u3002", uniqueKeyDesc);
                }
                uniqueKeyList.add(uniqueKey);
            }
            return errMsg;
        }
    }

    public static class ImportCellValidator
    implements Serializable {
        private static final long serialVersionUID = -1581219422889414902L;

        public static String validateForCommon(Rule rule, Object cellValue) {
            String errMsg1 = ImportCellValidator.validateRequired(rule, cellValue);
            if (StringUtils.isNotEmpty((CharSequence)errMsg1)) {
                return errMsg1;
            }
            String errMsg2 = ImportCellValidator.validateUnallowableChar(rule, cellValue);
            if (StringUtils.isNotEmpty((CharSequence)errMsg2)) {
                return errMsg2;
            }
            String errMsg3 = ImportCellValidator.validateLength(rule, cellValue);
            if (StringUtils.isNotEmpty((CharSequence)errMsg3)) {
                return errMsg3;
            }
            String errMsg4 = ImportCellValidator.validateDateFormat(rule, cellValue);
            if (StringUtils.isNotEmpty((CharSequence)errMsg4)) {
                return errMsg4;
            }
            return "";
        }

        public static String validateRequired(Rule rule, Object cellValue) {
            if (rule.isRequired() && ImportUtil.isNull(cellValue)) {
                return rule.getColumnText() + "\u4e0d\u80fd\u4e3a\u7a7a\u3002";
            }
            return "";
        }

        public static String validateUnallowableChar(Rule rule, Object cellValue) {
            if (rule.getColumnType().equals("string") && !ImportUtil.isNull(cellValue) && ImportConst.ILLEGAL_CHAR_PATTERN.matcher(cellValue.toString()).find()) {
                return rule.getColumnText() + "\u5b58\u5728\u975e\u6cd5\u5b57\u7b26\u3002";
            }
            return "";
        }

        public static String validateLength(Rule rule, Object cellValue) {
            int maxLength;
            if (rule.getColumnType().equals("string") && null != rule.getLength() && !ImportUtil.isNull(cellValue)) {
                maxLength = rule.getLength();
                if (cellValue.toString().length() > maxLength) {
                    return String.format("%s\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%s\u4f4d\u3002", rule.getColumnText(), maxLength);
                }
            }
            if (rule.getColumnType().equals("number") && null != rule.getLength() && !ImportUtil.isNull(cellValue)) {
                maxLength = rule.getLength();
                String cellValueStr = cellValue.toString();
                if (null != rule.getLength()) {
                    if (cellValueStr.contains(".") && cellValueStr.length() + 1 > rule.getLength()) {
                        return String.format("%s\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%s\u4f4d\u3002", rule.getColumnText(), maxLength);
                    }
                    if (!cellValueStr.contains(".") && cellValueStr.length() > rule.getLength()) {
                        return String.format("%s\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7%s\u4f4d\u3002", rule.getColumnText(), maxLength);
                    }
                }
            }
            return "";
        }

        public static String validateDateFormat(Rule rule, Object cellValue) {
            if (rule.getColumnType().equals("string") && StringUtils.isNotEmpty((CharSequence)rule.getPattern()) && !ImportUtil.isNull(cellValue) && !BlockDateTimeUtil.validDateStr(cellValue.toString(), rule.getPattern())) {
                return rule.getColumnText() + "\u65e5\u671f\u683c\u5f0f\u9519\u8bef\u3002";
            }
            return "";
        }
    }

    public static final class ImportConst {
        public static final String ILLEGAL_CHAR_REGEX = System.getProperty("abc.excel.import.illegal.regex", "[\\\\%&$#<>=|'\"()*]+|(javascript\\:)|(vbscript\\:)|(onload(.*?)=)|(eval\\((.*?)\\))");
        public static final Pattern ILLEGAL_CHAR_PATTERN = Pattern.compile(ILLEGAL_CHAR_REGEX);

        private ImportConst() {
        }
    }

    public static final class ImportUtil {
        public static ImportConfig getImportConfig(String configPath) {
            if (StringUtils.isEmpty((CharSequence)configPath)) {
                throw new EcpCheckException("ABC.0048", "\u5165\u53c2configPath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            try {
                InputStream in = ExcelPOIUtil.class.getResourceAsStream(configPath);
                String fileContent = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                fileContent = fileContent.replaceAll("\n", "");
                return (ImportConfig)JSON.parseObject((String)fileContent, ImportConfig.class);
            }
            catch (Exception e) {
                e.printStackTrace();
                String msg = "Excel\u6570\u636e\u8bfb\u53d6\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u83b7\u53d6\u5931\u8d25\u3002";
                throw new EcpCheckException("\u5bfc\u5165\u51fa\u9519", "Excel\u6570\u636e\u8bfb\u53d6\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u83b7\u53d6\u5931\u8d25\u3002");
            }
        }

        public static List<String> getHeaderValues(Row header) {
            if (null == header) {
                throw new EcpCheckException("ABC.0048", "\u5165\u53c2header\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            ArrayList<String> list = new ArrayList<String>();
            for (int j = 0; j < header.getLastCellNum(); ++j) {
                String value = String.valueOf(ImportUtil.getCellValue(header.getCell(j), null));
                list.add(value);
            }
            return list;
        }

        public static Row getHeaderRow(Sheet sheet, ImportConfig config, int columns) {
            if (null == sheet) {
                throw new EcpCheckException("ABC.0048", "sheet\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (null == config) {
                return sheet.getRow(0);
            }
            if (config.getIsMultiHeader().booleanValue()) {
                return ImportUtil.transferMultiHeaderToSingle(sheet, config, columns);
            }
            if (config.getHeaderEndIndex() != null) {
                return sheet.getRow(config.getHeaderEndIndex().intValue());
            }
            return sheet.getRow(0);
        }

        public static void checkHeader(Row header, List<Rule> rules) throws EcpCheckException {
            if (null == header) {
                throw new EcpCheckException("ABC.0048", "\u5165\u53c2header\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (CollectionUtils.isEmpty(rules)) {
                throw new EcpCheckException("ABC.0048", "\u5165\u53c2rules\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            List<String> headers = ImportUtil.getHeaderValues(header);
            List ruleHeaders = rules.stream().map(Rule::getColumnText).collect(Collectors.toList());
            if (headers.size() != ruleHeaders.size()) {
                throw new EcpCheckException("Excel_Header_Not_Match", "Excel\u6587\u4ef6\u548cRule\u914d\u7f6e\u6587\u4ef6\uff0c\u5217\u6570\u91cf\u4e0d\u5339\u914d\u3002");
            }
            for (int i = 0; i < ruleHeaders.size(); ++i) {
                String thisRuleHeaderName;
                String thisExcelHeanderName = headers.get(i);
                if (thisExcelHeanderName.equals(thisRuleHeaderName = (String)ruleHeaders.get(i))) continue;
                throw new EcpCheckException("Excel_Header_Not_Match", String.format("Excel\u6587\u4ef6\u548cRule\u914d\u7f6e\u6587\u4ef6\uff0c\u7b2c%s\u5217\u4e0d\u5339\u914d\u3002\u914d\u7f6e\u9879\u5217\u540d\uff1a%s\uff0cExcel\u6587\u4ef6\u5217\u540d\uff1a%s\u3002", i + 1, thisRuleHeaderName, thisExcelHeanderName));
            }
        }

        public static void checkHeader(Row header, String rulePath) throws EcpCheckException {
            if (null == header) {
                throw new EcpCheckException("ABC.0048", "\u5165\u53c2header\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (StringUtils.isEmpty((CharSequence)rulePath)) {
                throw new EcpCheckException("ABC.0048", "\u5165\u53c2rulePath\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            List<Rule> rules = ExcelPOIUtil.getRuleList(rulePath);
            ImportUtil.checkHeader(header, rules);
        }

        public static Row transferMultiHeaderToSingle(Sheet sheet, ImportConfig config, int columns) {
            if (!config.getIsMultiHeader().booleanValue()) {
                throw new EcpCheckException("Excel_Header_Config_Is_Not_Multi", "Excel\u8868\u5934\u68c0\u67e5\u89c4\u5219\u4e0d\u5339\u914d\u3002");
            }
            int startRow = config.getHeaderStartIndex();
            int endRow = config.getHeaderEndIndex();
            LOG.info((Object)String.format("\u4ece\u7b2c%s\u884c\u5230%s\u884c\uff0c\u8fdb\u884c\u591a\u8868\u5934\u8f6c\u5355\u8868\u5934\u3002", startRow, endRow));
            boolean isMergeMultiHeaderValue = config.getIsMergeMultiHeaderValue();
            Row prevRow = null;
            Cell prevCell = null;
            for (int i = startRow; i <= endRow; ++i) {
                Row currentRow = sheet.getRow(i);
                for (int j = 0; j < columns; ++j) {
                    Cell currentCell = currentRow.getCell(j);
                    if (null == currentCell) {
                        currentCell = currentRow.createCell(j);
                    }
                    if (i == config.getHeaderStartIndex()) {
                        if (prevCell != null && StringUtils.isEmpty((CharSequence)currentCell.getStringCellValue())) {
                            currentCell.setCellValue(prevCell.getStringCellValue());
                        }
                        prevCell = currentCell;
                        continue;
                    }
                    if (prevRow == null) continue;
                    String currentCellValue = currentCell.getStringCellValue();
                    if (StringUtils.isEmpty((CharSequence)currentCellValue)) {
                        currentCell.setCellValue(prevRow.getCell(j).getStringCellValue());
                        continue;
                    }
                    if (!isMergeMultiHeaderValue) continue;
                    currentCell.setCellValue(prevRow.getCell(j).getStringCellValue() + "\uff1a" + currentCellValue);
                }
                prevRow = currentRow;
            }
            Row header = sheet.getRow(config.getHeaderEndIndex().intValue());
            LOG.info((Object)String.format("\u591a\u8868\u5934\u8f6c\u5355\u8868\u5934\u7ed3\u679c=%s", ImportUtil.getHeaderValues(header).toString()));
            return header;
        }

        public static Object getCellValue(Cell cell, Rule rule) {
            if (null == cell) {
                return null;
            }
            if (CellType.NUMERIC == cell.getCellType()) {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return ImportUtil.handleCellValueForTypeDate(cell.getDateCellValue(), rule);
                }
                return ImportUtil.handleCellValueForTypeNumber(cell.getNumericCellValue(), rule, cell.getCellStyle().getDataFormat());
            }
            if (CellType.STRING == cell.getCellType()) {
                String cellValue = cell.getStringCellValue();
                return ImportUtil.handleCellValueForTypeString(cellValue, rule);
            }
            if (CellType.FORMULA == cell.getCellType()) {
                return ImportUtil.handleCellValueForTypeFormila(cell, rule);
            }
            if (CellType.BOOLEAN == cell.getCellType()) {
                return ImportUtil.handleCellValueForTypeBoolean(cell.getBooleanCellValue(), rule);
            }
            return null;
        }

        private static Object handleCellValueForTypeDate(Date cellValue, Rule rule) {
            if (null == rule) {
                return cellValue;
            }
            if (rule.getColumnType().equals("date")) {
                return cellValue;
            }
            if (rule.getColumnType().equals("number")) {
                return cellValue.getTime();
            }
            if (rule.getColumnType().equals("string")) {
                if (StringUtils.isEmpty((CharSequence)rule.getPattern())) {
                    throw new EcpCheckException("Excel_CellValue_DataType_Transfer_Failed", rule.getColumnText() + "\uff0cDate \"" + cellValue + "\" \u65e0\u6cd5\u8f6c\u6362\u6210String\u3002Rule\u6587\u4ef6\u7f3a\u5c11pattern\u914d\u7f6e\u3002");
                }
                return BlockDateTimeUtil.formate(cellValue, rule.getPattern());
            }
            if (rule.getColumnType().equals("enum")) {
                throw new EcpCheckException("Excel_CellValue_DataType_Transfer_Failed", rule.getColumnText() + "\uff0cDate \"" + cellValue + "\" \u65e0\u6cd5\u8f6c\u6362\u6210\u679a\u4e3e\u3002");
            }
            if (rule.getColumnType().equals("boolean")) {
                throw new EcpCheckException("Excel_CellValue_DataType_Transfer_Failed", rule.getColumnText() + "\uff0cDate \"" + cellValue + "\" \u65e0\u6cd5\u8f6c\u6362\u6210\u5e03\u5c14\u3002");
            }
            return cellValue;
        }

        private static Object handleCellValueForTypeNumber(double cellValue, Rule rule) {
            if (null == rule) {
                return cellValue;
            }
            if (rule.getColumnType().equals("number")) {
                BigDecimal value = new BigDecimal(String.valueOf(cellValue));
                if (rule.getScale() != null) {
                    return value.setScale((int)rule.getScale(), RoundingMode.HALF_UP).toString();
                }
                return value.toString();
            }
            if (rule.getColumnType().equals("date")) {
                if (StringUtils.isNotEmpty((CharSequence)rule.getPattern())) {
                    String value = String.valueOf(cellValue);
                    if (value.contains(".")) {
                        value = value.substring(0, value.indexOf("."));
                    }
                    return BlockDateTimeUtil.parse(value, rule.getPattern());
                }
                return DateUtil.getJavaDate((double)cellValue);
            }
            if (rule.getColumnType().equals("string")) {
                String value;
                if (StringUtils.isNotEmpty((CharSequence)rule.getPattern()) && (value = String.valueOf(cellValue)).contains(".")) {
                    return value.substring(0, value.indexOf("."));
                }
                String numStr = String.valueOf(cellValue);
                if (numStr.endsWith(".0")) {
                    return numStr.replace(".0", "");
                }
                return numStr;
            }
            if (rule.getColumnType().equals("boolean")) {
                throw new EcpCheckException("Excel_CellValue_DataType_Transfer_Failed", rule.getColumnText() + "\uff0cdouble \"" + cellValue + "\" \u65e0\u6cd5\u8f6c\u6362\u6210\u5e03\u5c14\u3002");
            }
            if (rule.getColumnType().equals("enum")) {
                throw new EcpCheckException("Excel_CellValue_DataType_Transfer_Failed", rule.getColumnText() + "\uff0cdouble \"" + cellValue + "\" \u65e0\u6cd5\u8f6c\u6362\u6210\u679a\u4e3e\u3002");
            }
            return cellValue;
        }

        private static Object handleCellValueForTypeNumber(double cellValue, Rule rule, short cellStyleFormat) {
            if (cellStyleFormat == 31 || cellStyleFormat == 57) {
                Date value = DateUtil.getJavaDate((double)cellValue);
                if (rule.getColumnType().equals("date")) {
                    return BlockDateTimeUtil.parse(BlockDateTimeUtil.formate(value, rule.getPattern()), rule.getPattern());
                }
                if (rule.getColumnType().equals("string")) {
                    return BlockDateTimeUtil.formate(value, rule.getPattern());
                }
            }
            return ImportUtil.handleCellValueForTypeNumber(cellValue, rule);
        }

        private static Object handleCellValueForTypeString(String cellValue, Rule rule) {
            if (null == rule) {
                return cellValue;
            }
            if (StringUtil.isEmpty((String)cellValue)) {
                return cellValue;
            }
            if (rule.getColumnType().equals("string")) {
                return cellValue;
            }
            if (rule.getColumnType().equals("date")) {
                if (StringUtils.isEmpty((CharSequence)rule.getPattern())) {
                    throw new EcpCheckException("Excel_CellValue_DataType_Transfer_Failed", rule.getColumnText() + "\uff0cString \"" + cellValue + "\" \u65e0\u6cd5\u8f6c\u6362\u6210\u65e5\u671f\u3002Rule\u6587\u4ef6\u7f3a\u5c11pattern\u914d\u7f6e\u3002");
                }
                return BlockDateTimeUtil.parse(cellValue, rule.getPattern());
            }
            if (rule.getColumnType().equals("number")) {
                String value = cellValue;
                DecimalFormat df = new DecimalFormat("#.############");
                value = df.format(Double.valueOf(value));
                if (rule != null && rule.getScale() != null) {
                    return new BigDecimal(value).setScale((int)rule.getScale(), RoundingMode.HALF_UP).toString();
                }
                return value;
            }
            if (rule.getColumnType().equals("boolean")) {
                if ("true".equals(cellValue) || "1".equals(cellValue)) {
                    return true;
                }
                if ("false".equals(cellValue) || "0".equals(cellValue)) {
                    return false;
                }
                throw new EcpCheckException("Excel_CellValue_DataType_Transfer_Failed", rule.getColumnText() + "\uff0cString \"" + cellValue + "\" \u65e0\u6cd5\u8f6c\u6362\u6210\u5e03\u5c14\u3002");
            }
            if (rule.getColumnType().equals("enum")) {
                throw new EcpCheckException("Excel_CellValue_DataType_Transfer_Failed", rule.getColumnText() + "\uff0cString \"" + cellValue + "\" \u65e0\u6cd5\u8f6c\u6362\u6210\u679a\u4e3e\u3002");
            }
            return cellValue;
        }

        private static Object handleCellValueForTypeBoolean(boolean cellValue, Rule rule) {
            if (null == rule) {
                return cellValue;
            }
            if (rule.getColumnType().equals("boolean")) {
                return cellValue;
            }
            if (rule.getColumnType().equals("enum")) {
                if (cellValue) {
                    return YesnoEnum.YES;
                }
                return YesnoEnum.NO;
            }
            if (rule.getColumnType().equals("number")) {
                if (cellValue) {
                    return 1;
                }
                return 0;
            }
            if (rule.getColumnType().equals("string")) {
                return String.valueOf(cellValue);
            }
            if (rule.getColumnType().equals("date")) {
                throw new EcpCheckException("Excel_CellValue_DataType_Transfer_Failed", rule.getColumnText() + "\uff0cBoolean \"" + cellValue + "\" \u65e0\u6cd5\u8f6c\u6362\u6210\u65e5\u671f\u3002");
            }
            return cellValue;
        }

        private static Object handleCellValueForTypeFormila(Cell cell, Rule rule) {
            if (CellType.STRING == cell.getCachedFormulaResultType()) {
                return ImportUtil.handleCellValueForTypeString(cell.getStringCellValue(), rule);
            }
            if (CellType.NUMERIC == cell.getCachedFormulaResultType()) {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return ImportUtil.handleCellValueForTypeDate(cell.getDateCellValue(), rule);
                }
                return ImportUtil.handleCellValueForTypeNumber(cell.getNumericCellValue(), rule);
            }
            if (CellType.BOOLEAN == cell.getCachedFormulaResultType()) {
                return ImportUtil.handleCellValueForTypeBoolean(cell.getBooleanCellValue(), rule);
            }
            return cell.getCellFormula();
        }

        public static Sheet getSheet(Workbook wk, ImportConfig config) {
            if (config.getSheetIndex() != null) {
                Sheet sheet = wk.getSheetAt(config.getSheetIndex().intValue());
                if (null == sheet) {
                    throw new EcpCheckException("Excel_Sheet_Not_Match", "\u6839\u636eSheet\u4e0b\u6807\uff0c\u83b7\u53d6Sheet\u5931\u8d25\u3002SheetIndex=" + config.getSheetIndex());
                }
                return sheet;
            }
            if (StringUtils.isNotEmpty((CharSequence)config.getSheetName())) {
                Sheet sheet = wk.getSheet(config.getSheetName());
                if (null == sheet) {
                    throw new EcpCheckException("Excel_Sheet_Not_Match", "\u6839\u636eSheetName\uff0c\u83b7\u53d6Sheet\u5931\u8d25\u3002SheetName=" + config.getSheetName());
                }
                return sheet;
            }
            Sheet sheet = wk.getSheetAt(0);
            if (null == sheet) {
                throw new EcpCheckException("Excel_Sheet_Not_Match", "\u9ed8\u8ba4\u83b7\u53d6Sheet(0)\u5931\u8d25\u3002");
            }
            return sheet;
        }

        public static Sheet getSheet(Workbook wk, String sheetName) {
            if (StringUtils.isEmpty((CharSequence)sheetName)) {
                Sheet sheet = wk.getSheetAt(0);
                if (null == sheet) {
                    throw new EcpCheckException("Excel_Sheet_Not_Match", "\u9ed8\u8ba4\u83b7\u53d6Sheet(0)\u5931\u8d25\u3002");
                }
                return sheet;
            }
            Sheet sheet = wk.getSheet(sheetName);
            if (null == sheet) {
                throw new EcpCheckException("Excel_Sheet_Not_Match", "\u6839\u636eSheetName\uff0c\u83b7\u53d6Sheet\u5931\u8d25\u3002SheetName=" + sheetName);
            }
            return wk.getSheet(sheetName);
        }

        public static boolean isNull(Object obj) {
            if (obj == null) {
                return true;
            }
            if (obj instanceof CharSequence) {
                return ((CharSequence)obj).length() == 0;
            }
            if (obj.getClass().isArray()) {
                return Array.getLength(obj) == 0;
            }
            if (obj instanceof Collection) {
                return ((Collection)obj).isEmpty();
            }
            return obj instanceof Map ? ((Map)obj).isEmpty() : false;
        }
    }

    public static final class ExportConst {
        public static final int UNIT_WIDTH = 255;
        public static final int BASE_FONT_SIZE = 10;
        public static final int MIN_BYTES = Integer.parseInt(System.getProperty("abc.excel.export.column.min.width", "8"));
        public static final int MAX_BYTES = Integer.parseInt(System.getProperty("abc.excel.export.column.max.width", "100"));
        public static final int HEADER_FONT_SIZE = Integer.parseInt(System.getProperty("abc.excel.export.header.fontSize", "12"));
        public static final int BODY_FONT_SIZE = Integer.parseInt(System.getProperty("abc.excel.export.body.fontSize", "10"));
        public static final int DEFAULT_SCALE = Integer.parseInt(System.getProperty("abc.excel.export.default.scale", "2"));
        public static final String DEFAULT_PATTERN = System.getProperty("abc.excel.export.default.pattern", "yyyy-MM-dd");
    }

    public static final class ExportUtil {
        public static AtomicIntegerArray wirteExcelTitle(Sheet sheet, List<Rule> rules) {
            AtomicIntegerArray cellWidth = new AtomicIntegerArray(rules.size());
            int cellIndex = 0;
            Row row = sheet.createRow(0);
            CellStyle headerCellStyle = ExportUtil.getHeaderStyle(sheet.getWorkbook());
            for (Rule rule : rules) {
                Cell cell = row.createCell(cellIndex);
                String headerName = rule.getColumnText();
                cell.setCellStyle(headerCellStyle);
                cell.setCellValue(headerName);
                cellWidth.set(cellIndex++, ExportUtil.getCellWidth(headerName, ExportConst.HEADER_FONT_SIZE));
            }
            return cellWidth;
        }

        public static String castObject2StringByRule(Object cellValue, Rule rule) {
            if (null == cellValue) {
                return "";
            }
            if (null == rule) {
                return ConvertUtil.toString((Object)cellValue);
            }
            switch (rule.getColumnType()) {
                case "date": {
                    String pattern = rule.getPattern();
                    if (StringUtils.isEmpty((CharSequence)pattern)) {
                        pattern = ExportConst.DEFAULT_PATTERN;
                    }
                    Date date = DateSerializeUtil.isDateTimeValue((Object)cellValue) ? (Date)DateSerializeUtil.toDateObject((Object)cellValue, Date.class) : ConvertUtil.toDate((Object)cellValue);
                    return BlockDateUtil.formatDate(date, pattern);
                }
                case "number": {
                    String tempValue = cellValue.toString();
                    if (tempValue.contains(".")) {
                        int scaleTemp = rule.getScale() == null ? ExportConst.DEFAULT_SCALE : rule.getScale();
                        return new BigDecimal(tempValue).setScale(scaleTemp, RoundingMode.HALF_UP).toString();
                    }
                    return tempValue;
                }
            }
            return cellValue.toString();
        }

        public static int getCellWidth(String cellValue, int fontSize) {
            BigDecimal ratio = new BigDecimal(fontSize).divide(new BigDecimal(10), ExportConst.DEFAULT_SCALE, RoundingMode.HALF_UP);
            int cellValueBytes = 0;
            try {
                cellValueBytes = cellValue.getBytes("GBK").length;
            }
            catch (Exception e) {
                cellValueBytes = cellValue.getBytes().length;
            }
            BigDecimal columnWidth = new BigDecimal(0);
            columnWidth = cellValueBytes <= ExportConst.MIN_BYTES ? new BigDecimal(ExportConst.MIN_BYTES).multiply(new BigDecimal(255)).multiply(ratio) : (cellValueBytes > ExportConst.MAX_BYTES ? new BigDecimal(ExportConst.MAX_BYTES).multiply(new BigDecimal(255)).multiply(ratio) : new BigDecimal(cellValueBytes).multiply(new BigDecimal(255)).multiply(ratio));
            return columnWidth.setScale(0, RoundingMode.UP).intValue();
        }

        public static int getCellHeight(String text, short oneLineheight) {
            int count = 0;
            int length = 0;
            try {
                length = text.getBytes("GBK").length;
            }
            catch (Exception e) {
                length = text.getBytes().length;
            }
            if (length <= ExportConst.MAX_BYTES) {
                return oneLineheight;
            }
            count = length % ExportConst.MAX_BYTES == 0 ? length / ExportConst.MAX_BYTES : length / ExportConst.MAX_BYTES + 1;
            return count * oneLineheight;
        }

        public static CellStyle getHeaderStyle(Workbook workbook) {
            Font font = workbook.createFont();
            font.setFontHeightInPoints(ConvertUtil.toShort((Object)ExportConst.HEADER_FONT_SIZE).shortValue());
            font.setBold(true);
            CellStyle cellStyle = workbook.createCellStyle();
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            cellStyle.setAlignment(HorizontalAlignment.CENTER);
            cellStyle.setFont(font);
            return cellStyle;
        }

        public static Map<String, CellStyle> createCellStyleByRules(Workbook workbook, List<Rule> rules) {
            HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();
            rules.forEach(rule -> {
                CellStyle cellStyle = ExportUtil.createCellStyleByRule(workbook, rule);
                cellStyleMap.put(rule.getColumnName(), cellStyle);
            });
            return cellStyleMap;
        }

        public static CellStyle createCellStyleByRule(Workbook workbook, Rule rule) {
            CellStyle cellStyle = workbook.createCellStyle();
            Font font = workbook.createFont();
            font.setFontHeightInPoints(ConvertUtil.toShort((Object)ExportConst.BODY_FONT_SIZE).shortValue());
            cellStyle.setFont(font);
            if (rule.isWrapText) {
                cellStyle.setWrapText(true);
            }
            cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
            switch (rule.getColumnType()) {
                case "date": {
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                    break;
                }
                case "number": {
                    cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                    break;
                }
                case "string": {
                    cellStyle.setAlignment(HorizontalAlignment.LEFT);
                    break;
                }
                default: {
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                }
            }
            return cellStyle;
        }
    }

    public static final class TemplateUtil {
        public static <T> void renderExcelWithParam(Workbook workbook, T templateParam) {
            Sheet sheet = workbook.getSheetAt(0);
            int rowNums = sheet.getLastRowNum() + 1;
            for (int i = 0; i < rowNums; ++i) {
                Row row = sheet.getRow(i);
                int cellNums = row.getLastCellNum();
                for (int j = 0; j < cellNums; ++j) {
                    String cellValue;
                    Cell cell = row.getCell(j);
                    if (null == cell || StringUtils.isEmpty((CharSequence)(cellValue = ConvertUtil.toString((Object)ImportUtil.getCellValue(cell, null))))) continue;
                    if (TemplateUtil.containsTextPlaceholder(cellValue)) {
                        if (TemplateUtil.existTextParamKey(cellValue, templateParam)) {
                            String replaceValue = BeetlUtil.renderFromStr(cellValue, templateParam);
                            if (CommonUtil.isNumber(replaceValue)) {
                                cell.setCellValue(Double.parseDouble(replaceValue));
                            } else {
                                cell.setCellValue(replaceValue);
                            }
                        } else {
                            cell.setCellValue("");
                        }
                    }
                    if (!TemplateUtil.matchImagePlaceholder(cellValue)) continue;
                    String tempPlaceholder = cellValue.replace("#", "$");
                    String imageBase64 = BeetlUtil.renderFromStr(tempPlaceholder, templateParam);
                    TemplateUtil.addImage(workbook, cell, imageBase64);
                    cell.setCellValue("");
                }
            }
            FormulaEvaluator evaluator = workbook.getCreationHelper().createFormulaEvaluator();
            evaluator.evaluateAll();
        }

        public static Map<String, String> getConfigMap(Row configRow, int maxColumnCount) {
            HashMap<String, String> columnConfig = new HashMap<String, String>();
            for (int i = 0; i < maxColumnCount; ++i) {
                String cellValue;
                Cell cell = configRow.getCell(i);
                if (cell == null || !TemplateUtil.containsTextPlaceholder(cellValue = cell.getStringCellValue())) continue;
                columnConfig.put(String.valueOf(cell.getColumnIndex()), cellValue);
            }
            return columnConfig;
        }

        public static Map<String, CellStyle> getCellStyleMap(Row configRow, int maxColumnCount) {
            HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();
            for (int i = 0; i < maxColumnCount; ++i) {
                Cell cell = configRow.getCell(i);
                if (cell == null) continue;
                cellStyleMap.put(String.valueOf(cell.getColumnIndex()), cell.getCellStyle());
            }
            return cellStyleMap;
        }

        public static boolean containsTextPlaceholder(String content) {
            String regex = ".*?\\$\\{.*?\\}.*?$";
            return Pattern.matches(".*?\\$\\{.*?\\}.*?$", content);
        }

        public static <T> boolean existTextParamKey(String content, T param) {
            String jsonstr = JSON.toJSONString(param, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
            Map map = (Map)JSON.parseObject((String)jsonstr, Map.class);
            AtomicBoolean contains = new AtomicBoolean(false);
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                String regex = ".*?\\$\\{" + key + ".*?}.*?$";
                if (!Pattern.matches(regex, content)) continue;
                contains.getAndSet(true);
                break;
            }
            return contains.get();
        }

        public static boolean matchImagePlaceholder(String content) {
            String regex = "\\#\\{.*?\\}";
            return Pattern.matches("\\#\\{.*?\\}", content);
        }

        public static CellRangeAddress getCellRangeAddress(Sheet sheet, Cell cell) {
            int row = cell.getRowIndex();
            int col = cell.getColumnIndex();
            for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
                CellRangeAddress range = sheet.getMergedRegion(i);
                if (row != range.getFirstRow() || col != range.getFirstColumn()) continue;
                return range;
            }
            return new CellRangeAddress(row, row, col, col);
        }

        public static void addImage(Workbook workbook, Cell cell, String imageBase64) {
            Sheet sheet = workbook.getSheetAt(0);
            CellRangeAddress address = TemplateUtil.getCellRangeAddress(sheet, cell);
            CreationHelper helper = workbook.getCreationHelper();
            ClientAnchor anchor = helper.createClientAnchor();
            anchor.setCol1(address.getFirstColumn());
            anchor.setRow1(address.getFirstRow());
            anchor.setCol2(address.getLastColumn() + 1);
            anchor.setRow2(address.getLastRow() + 1);
            Drawing patriarch = sheet.createDrawingPatriarch();
            byte[] bytes = Base64.getDecoder().decode(imageBase64);
            patriarch.createPicture(anchor, workbook.addPicture(bytes, 6));
        }

        public static Map<String, List<String>> getPropertyMap(Map<String, String> columnMap, Object bean) {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            columnMap.forEach((columnIndex, placeholder) -> {
                String holeKey = placeholder.replace("${", "").replace("}", "");
                String[] properties = holeKey.split("\\.");
                String startProperty = properties[0];
                String nextProperty = properties.length > 1 ? properties[1] : "";
                ArrayList<String> keys = new ArrayList<String>();
                TemplateUtil.setKey(holeKey, startProperty, nextProperty, bean, keys);
                map.put((String)columnIndex, (List<String>)keys);
            });
            return map;
        }

        private static void setKey(String holeKey, String curProperty, String nextProperty, Object bean, List<String> keys) {
            Object curValue = ObjectPropertyUtil.getValue(bean, curProperty);
            if (null == curValue) {
                return;
            }
            if (StringUtils.isEmpty((CharSequence)nextProperty) && ObjectPropertyUtil.isBasicType(curValue) && !keys.contains(curProperty)) {
                keys.add(curProperty);
                return;
            }
            if (curValue instanceof List || curValue.getClass().isArray()) {
                List<Object> list = ObjectPropertyUtil.getArrayPropertyValues(bean, curProperty);
                if (CollectionUtils.isNotEmpty(list)) {
                    for (int i = 0; i < list.size(); ++i) {
                        String newNextKey;
                        String newCurKey = curProperty + "[" + i + "]";
                        if (StringUtils.isNotEmpty((CharSequence)nextProperty)) {
                            newCurKey = newCurKey + "." + nextProperty;
                        }
                        String newCurPropertyOriginal = curProperty.replaceAll("\\[\\d+\\]", "");
                        if (StringUtils.isNotEmpty((CharSequence)nextProperty)) {
                            newCurPropertyOriginal = newCurPropertyOriginal + "." + nextProperty;
                        }
                        if (StringUtils.isNotEmpty((CharSequence)(newNextKey = holeKey.replace(newCurPropertyOriginal, ""))) && newNextKey.startsWith(".") && newNextKey.length() > 1) {
                            newNextKey = newNextKey.split("\\.")[1];
                        }
                        TemplateUtil.setKey(holeKey, newCurKey, newNextKey, bean, keys);
                    }
                }
            } else {
                String newCurKey = curProperty + "." + nextProperty;
                String newCurPropertyOriginal = curProperty.replaceAll("\\[\\d+\\]", "") + "." + nextProperty;
                String newNextKey = holeKey.replace(newCurPropertyOriginal, "");
                if (StringUtils.isNotEmpty((CharSequence)newNextKey) && newNextKey.contains("\\.")) {
                    newNextKey = newNextKey.split("\\.")[0];
                }
                TemplateUtil.setKey(holeKey, newCurKey, newNextKey, bean, keys);
            }
        }

        public static int getMaxChildCounts(String currentProperty, Map<String, List<String>> propertyMap) {
            if (StringUtils.isEmpty((CharSequence)currentProperty)) {
                throw CheckFailedException.newInstance("\u5165\u53c2currentProperty\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (null == propertyMap || propertyMap.size() == 0) {
                throw CheckFailedException.newInstance("\u5165\u53c2propertyMap\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            String parentProperty = TemplateUtil.getParentObjectPropertyName(currentProperty);
            Map<String, List<String>> childMap = TemplateUtil.initColumnMap(propertyMap);
            propertyMap.forEach((columnIndex, properties) -> {
                for (String property : properties) {
                    String targetSuffix;
                    if (property.equals(currentProperty)) continue;
                    if (StringUtils.isEmpty((CharSequence)parentProperty)) {
                        targetSuffix = property;
                    } else {
                        if (!property.contains(parentProperty)) continue;
                        targetSuffix = property.substring(property.indexOf(parentProperty) + parentProperty.length());
                    }
                    if (!TemplateUtil.isContainsArrPattern(targetSuffix)) continue;
                    ((List)childMap.get(columnIndex)).add(property);
                }
            });
            return childMap.values().stream().mapToInt(List::size).max().getAsInt();
        }

        private static Map<String, List<String>> initColumnMap(Map<String, List<String>> propertyMap) {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            propertyMap.forEach((k, v) -> {
                List cfr_ignored_0 = map.put((String)k, new ArrayList());
            });
            return map;
        }

        private static String getParentObjectPropertyName(String propertyName) {
            if (StringUtils.isEmpty((CharSequence)propertyName)) {
                throw CheckFailedException.newInstance("\u5165\u53c2propertyName\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (propertyName.contains(".")) {
                return propertyName.substring(0, propertyName.lastIndexOf("."));
            }
            return "";
        }

        private static boolean isContainsArrPattern(String str) {
            if (StringUtils.isEmpty((CharSequence)str)) {
                throw CheckFailedException.newInstance("\u5165\u53c2str\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            Matcher m = CONTAINS_ARR_PATTERN.matcher(str);
            return m.find();
        }

        public static List<String> getOffsetListWithSameValue(List<String> properties, String value, int offset) {
            List<List<String>> lists = TemplateUtil.partitionList(properties, value);
            List<String> fillList = TemplateUtil.fillList(offset, value);
            ArrayList<String> list = new ArrayList<String>();
            list.addAll((Collection)lists.get(0));
            list.addAll(fillList);
            list.addAll((Collection)lists.get(1));
            return list;
        }

        public static List<String> getOffsetListWithBlankValue(List<String> properties, String value, int offset) {
            List<List<String>> lists = TemplateUtil.partitionList(properties, value);
            List<String> fillList = TemplateUtil.fillList(offset, ExcelPOIUtil.NULL_STR);
            ArrayList<String> list = new ArrayList<String>();
            list.addAll((Collection)lists.get(0));
            list.addAll(fillList);
            list.addAll((Collection)lists.get(1));
            return list;
        }

        private static List<String> fillList(int count, String value) {
            ArrayList<String> list = new ArrayList<String>();
            String tempValue = StringUtil.isEmpty((String)value) ? ExcelPOIUtil.NULL_STR : value;
            for (int i = 0; i < count; ++i) {
                list.add(tempValue);
            }
            return list;
        }

        private static List<List<String>> partitionList(List<String> properties, String value) {
            int i = properties.indexOf(value);
            ArrayList<List<String>> returnList = new ArrayList<List<String>>();
            List partitions = Lists.partition(properties, (int)(i + 1));
            List partition1 = (List)partitions.get(0);
            returnList.add(partition1);
            ArrayList partition2 = new ArrayList();
            for (int k = 1; k < partitions.size(); ++k) {
                partition2.addAll((Collection)partitions.get(k));
            }
            returnList.add(partition2);
            return returnList;
        }
    }
}

