/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.common.types.InformationType;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExtStringUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ExtStringUtil.class);
    private static final String EMPTY_STRING = "";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final int MIN_STEP = 1;

    private ExtStringUtil() {
    }

    public static List<String> splitByUTF8(String str, int byteLength) {
        ArrayList<String> list = new ArrayList<String>();
        int step = Math.max(byteLength / 10, 1);
        String remainString = ExtStringUtil.splitByUTF8(list, str, byteLength, step);
        if (StringUtil.isNotEmptyString((String)remainString)) {
            ExtStringUtil.splitByUTF8(list, str, byteLength, 1);
        }
        return list;
    }

    private static String splitByUTF8(List<String> result, String str, int byteLength, int step) {
        try {
            if (str.getBytes(UTF_8).length <= byteLength) {
                result.add(str);
                return EMPTY_STRING;
            }
            String remainString = str;
            block2: do {
                int beginIndex = 0;
                int endIndex = 0;
                int lastIndex = byteLength + 1;
                for (int i = 1; i <= lastIndex; i += step) {
                    String splitString = remainString.substring(beginIndex, i);
                    if (splitString.getBytes(UTF_8).length > byteLength) {
                        splitString = remainString.substring(beginIndex, endIndex);
                        remainString = remainString.substring(endIndex);
                        result.add(splitString);
                        continue block2;
                    }
                    endIndex = i;
                }
            } while (remainString.getBytes(UTF_8).length > byteLength);
            result.add(remainString);
            remainString = EMPTY_STRING;
            return remainString;
        }
        catch (Exception e) {
            throw AbcServiceException.newInstance("\u5206\u5272\u5b57\u7b26\u4e32\u5931\u8d25\u3002", e);
        }
    }

    public static String coverUpSensitive(String value, InformationType type) {
        if (StringUtil.isNullOrTrimEmptyString((String)value)) {
            return value;
        }
        if (type.isText()) {
            return value;
        }
        if (type.isCardNO()) {
            return value.replaceAll("(\\d{3})\\d{11}(\\w{4})", "$1*********$2");
        }
        if (type.isMovetel()) {
            return value.replaceAll("(\\d{3})\\d{6}(\\d{2})", "$1******$2");
        }
        if (type.isBankNO()) {
            return value.replaceAll("(\\d{3})\\d*(\\w{2})", "$1******$2");
        }
        if (type.isEmail()) {
            return value.replaceAll("(\\w{2})\\w+@(\\w+)", "$1***@$2");
        }
        if (type.isAddress()) {
            return value.replaceAll("\\d+", "*");
        }
        if (type.isBrithday()) {
            return value.replaceAll("(\\d{2})\\d*(\\d{2})", "$1*******$2");
        }
        if (type.isMoney()) {
            return "****";
        }
        return value;
    }

    public static String format(String text, Map<String, String> param) {
        if (StringUtil.isNullOrTrimEmptyString((String)text)) {
            return text;
        }
        try {
            StringBuilder sb = new StringBuilder();
            Pattern p = Pattern.compile("\\{\\:(\\w+)\\}");
            Matcher m = p.matcher(text);
            int index = 0;
            int start = 0;
            int end = 0;
            while (m.find()) {
                String paramKey = m.group(1);
                start = m.start();
                end = m.end();
                if (start > index) {
                    sb.append(text.subSequence(index, start));
                }
                if (param.get(paramKey) == null) {
                    LOG.warn((Object)("\n\u6839\u636e\u6b63\u5219\u8868\u8fbe\u5f0f\u627e\u5230\u7684KEY=" + paramKey + "\uff0c\u5728param\u4e2d\u627e\u4e0d\u5230\u5bf9\u5e94\u7684VALUE\u3002"));
                    sb.append(m.group());
                } else {
                    sb.append(param.get(paramKey));
                }
                index = end;
            }
            if (index < text.length()) {
                sb.append(text.substring(index));
            }
            return sb.toString();
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("\n\u5f85\u8f6c\u6362\u7684\u5b57\u7b26\u4e32=" + text + "\n\u7ed1\u5b9a\u53c2\u6570params=" + param));
            }
            throw AbcServiceException.newInstance("\u6839\u636e\u6307\u5b9a\u53c2\u6570\u683c\u5f0f\u5316\u5b57\u7b26\u4e32\u5931\u8d25\u3002", e);
        }
    }

    public static byte[] toByteArray(String str) {
        if (str == null) {
            return null;
        }
        return str.getBytes(UTF_8);
    }

    public static String toString(byte[] data) {
        if (data == null) {
            return null;
        }
        return new String(data, UTF_8);
    }
}

