/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.google.common.collect.Lists;
import com.ygsoft.ecp.core.framework.model.ItemCondition;
import java.util.List;

public class ItemConditionUtil {
    private ItemConditionUtil() {
    }

    public static ItemConditionBuilder newBuilder() {
        return ItemConditionBuilder.newInstance();
    }

    public static class ItemConditionBuilder {
        private List<ItemCondition> conditions = Lists.newArrayList();

        public List<ItemCondition> getConditions() {
            return this.conditions;
        }

        public static ItemConditionBuilder newInstance() {
            return new ItemConditionBuilder();
        }

        public ItemConditionBuilder appendEqual(String field, Object value) {
            return this.append(field, "0", value);
        }

        public ItemConditionBuilder appendEqual(String field, Object value, String text) {
            return this.append(field, "0", value, text);
        }

        public ItemConditionBuilder appendNotEqual(String field, Object value) {
            return this.append(field, "1", value);
        }

        public ItemConditionBuilder appendNotEqual(String field, Object value, String text) {
            return this.append(field, "1", value, text);
        }

        public ItemConditionBuilder appendGreaterThan(String field, Object value) {
            return this.append(field, "2", value);
        }

        public ItemConditionBuilder appendGreaterThan(String field, Object value, String text) {
            return this.append(field, "2", value, text);
        }

        public ItemConditionBuilder appendLessThan(String field, Object value) {
            return this.append(field, "3", value);
        }

        public ItemConditionBuilder appendLessThan(String field, Object value, String text) {
            return this.append(field, "3", value, text);
        }

        public ItemConditionBuilder appendGreaterEqual(String field, Object value) {
            return this.append(field, "4", value);
        }

        public ItemConditionBuilder appendGreaterEqual(String field, Object value, String text) {
            return this.append(field, "4", value, text);
        }

        public ItemConditionBuilder appendLessEqual(String field, Object value) {
            return this.append(field, "5", value);
        }

        public ItemConditionBuilder appendLessEqual(String field, Object value, String text) {
            return this.append(field, "5", value, text);
        }

        public ItemConditionBuilder appendLike(String field, Object value) {
            return this.append(field, "6", value);
        }

        public ItemConditionBuilder appendLike(String field, Object value, String text) {
            return this.append(field, "6", value, text);
        }

        public ItemConditionBuilder appendIn(String field, Object value) {
            return this.append(field, "7", value);
        }

        public ItemConditionBuilder appendIn(String field, Object value, String text) {
            return this.append(field, "7", value, text);
        }

        public ItemConditionBuilder appendIs(String field, Object value) {
            return this.append(field, "8", value);
        }

        public ItemConditionBuilder appendIs(String field, Object value, String text) {
            return this.append(field, "8", value, text);
        }

        private ItemConditionBuilder append(String field, String operator, Object value) {
            return this.append(field, operator, value, "");
        }

        private ItemConditionBuilder append(String field, String operator, Object value, String text) {
            ItemCondition item = new ItemCondition();
            item.setConditionField(field);
            item.setOperator(operator);
            item.setValue(value);
            item.setText(text);
            this.conditions.add(item);
            return this;
        }

        public List<ItemCondition> build() {
            return this.getConditions();
        }
    }

    public static class ConditionOperator {
        public static final String EQUAL = "0";
        public static final String NOT_EQUAL = "1";
        public static final String GREATER_THAN = "2";
        public static final String LESS_THAN = "3";
        public static final String GREATER_EQUAL = "4";
        public static final String LESS_EQUAL = "5";
        public static final String LIKE = "6";
        public static final String IN = "7";
        public static final String IS = "8";
    }
}

