/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.AbcIOException;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.stream.IntStream;
import org.springframework.web.multipart.MultipartFile;

public final class NIOUtil {
    static final IEcpLog LOG = EcpLogFactory.getLog(BlockIOUtil.class);
    private static final int DEFAULT_BUFFER_SIZE = 102400;

    private NIOUtil() {
    }

    public static byte[] readBytes(String filePath) {
        PreconditionUtil.checkNotTrimEmpty(filePath, "\u53c2\u6570\u9519\u8bef\uff1afilePath\u4e3a\u7a7a\u3002");
        return NIOUtil.readBytes(new File(filePath));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytes(File file) {
        PreconditionUtil.checkNotNull(file, "\u53c2\u6570\u9519\u8bef\uff1afile\u4e3a\u7a7a\u3002");
        try (FileInputStream fileInput = new FileInputStream(file);){
            byte[] byArray = NIOUtil.readBytes(fileInput);
            return byArray;
        }
        catch (Exception e) {
            throw AbcIOException.newInstance(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] readBytes(MultipartFile multipartFile) {
        PreconditionUtil.checkNotNull(multipartFile, "\u53c2\u6570\u9519\u8bef\uff1amultipartFile\u4e3a\u7a7a\u3002");
        try (FileInputStream fileInput = (FileInputStream)multipartFile.getInputStream();){
            byte[] byArray = NIOUtil.readBytes(fileInput);
            return byArray;
        }
        catch (Exception e) {
            throw AbcIOException.newInstance(e);
        }
    }

    public static byte[] readBytes(FileInputStream fileInput) {
        PreconditionUtil.checkNotNull(fileInput, "\u53c2\u6570\u9519\u8bef\uff1afileInput\u4e3a\u7a7a\u3002");
        try {
            FileChannel inChannel = fileInput.getChannel();
            ByteBuffer buf = ByteBuffer.allocate(102400);
            byte[] result = new byte[(int)inChannel.size()];
            int start = 0;
            int bytesRead = 0;
            while ((bytesRead = inChannel.read(buf)) != -1) {
                buf.flip();
                byte[] arr = buf.array();
                System.arraycopy(arr, 0, result, start, bytesRead);
                buf.clear();
                start += bytesRead;
            }
            return result;
        }
        catch (Exception e) {
            throw AbcIOException.newInstance(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] mappedBytes(String filePath) {
        PreconditionUtil.checkNotTrimEmpty(filePath, "\u53c2\u6570\u9519\u8bef\uff1afilePath\u4e3a\u7a7a\u3002");
        try (FileInputStream fileInput = new FileInputStream(filePath);){
            byte[] byArray = NIOUtil.mappedBytes(fileInput);
            return byArray;
        }
        catch (Exception e) {
            throw AbcIOException.newInstance(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] mappedBytes(File file) {
        PreconditionUtil.checkNotNull(file, "\u53c2\u6570\u9519\u8bef\uff1afile\u4e3a\u7a7a\u3002");
        try (FileInputStream fileInput = new FileInputStream(file);){
            byte[] byArray = NIOUtil.mappedBytes(fileInput);
            return byArray;
        }
        catch (Exception e) {
            throw AbcIOException.newInstance(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] mappedBytes(MultipartFile multipartFile) {
        PreconditionUtil.checkNotNull(multipartFile, "\u53c2\u6570\u9519\u8bef\uff1amultipartFile\u4e3a\u7a7a\u3002");
        try (FileInputStream fileInput = (FileInputStream)multipartFile.getInputStream();){
            byte[] byArray = NIOUtil.mappedBytes(fileInput);
            return byArray;
        }
        catch (Exception e) {
            throw AbcIOException.newInstance(e);
        }
    }

    public static byte[] mappedBytes(FileInputStream fileInput) {
        PreconditionUtil.checkNotNull(fileInput, "\u53c2\u6570\u9519\u8bef\uff1afileInput\u4e3a\u7a7a\u3002");
        try {
            FileChannel fileChannel = fileInput.getChannel();
            int len = (int)fileChannel.size();
            byte[] result = new byte[len];
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, len);
            for (int offset = 0; offset < len; ++offset) {
                result[offset] = mappedByteBuffer.get();
            }
            return result;
        }
        catch (Exception e) {
            throw AbcIOException.newInstance(e);
        }
    }

    public static void transferTo(String srcFilePath, String destFilePath) {
        File srcFile = new File(srcFilePath);
        File destFile = new File(destFilePath);
        NIOUtil.transferTo(srcFile, destFile);
    }

    public static void transferTo(File srcFile, File destFile) {
        try (RandomAccessFile fromFile = new RandomAccessFile(srcFile, "rw");
             RandomAccessFile toFile = new RandomAccessFile(destFile, "rw");){
            FileChannel fromChannel = fromFile.getChannel();
            FileChannel toChannel = toFile.getChannel();
            long position = 0L;
            long count = fromChannel.size();
            fromChannel.transferTo(0L, count, toChannel);
        }
        catch (Exception e) {
            throw AbcIOException.newInstance(e);
        }
    }

    public static void main(String[] args) {
        long start = 0L;
        long end = 0L;
        start = System.currentTimeMillis();
        IntStream.range(1, 100).forEach(i -> {
            byte[] arr = NIOUtil.readBytes("D:/data/1\u52b3\u52a8\u5408\u540c\u4e66\uff08\u901a\u7528\u6a21\u7248\uff0920171018.PDF");
        });
        end = System.currentTimeMillis();
        System.out.println("Channel\u8017\u65f6:" + (end - start));
        start = System.currentTimeMillis();
        IntStream.range(1, 100).forEach(i -> {
            byte[] mapBytes = NIOUtil.mappedBytes("D:/data/1\u52b3\u52a8\u5408\u540c\u4e66\uff08\u901a\u7528\u6a21\u7248\uff0920171018.PDF");
        });
        end = System.currentTimeMillis();
        System.out.println("mapped\u8017\u65f6:" + (end - start));
        start = System.currentTimeMillis();
        IntStream.range(1, 100).forEach(i -> {
            byte[] arr = BlockIOUtil.readBytes("file:D:/data/1\u52b3\u52a8\u5408\u540c\u4e66\uff08\u901a\u7528\u6a21\u7248\uff0920171018.PDF");
        });
        end = System.currentTimeMillis();
        System.out.println("read\u8017\u65f6:" + (end - start));
    }
}

