/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.necp.core.service.dcispec.PageModel;
import java.util.List;
import java.util.function.Function;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

public class PageTransferUtil {
    private PageTransferUtil() {
    }

    public static <T> PageModel<T> toPageModel(Page<T> page, Pageable pageable) {
        PageModel pageModel = new PageModel(page, pageable.getPageNumber(), pageable.getPageSize());
        return pageModel;
    }

    public static <T> PageModel<T> toPageModel(Page<T> page, int pageNo, int pageSize) {
        PageModel pageModel = new PageModel(page, pageNo, pageSize);
        return pageModel;
    }

    public static <T, R> PageModel<R> toPageModel(Page<T> page, Pageable pageable, Function<List<T>, List<R>> func) {
        PageModel pageModel = new PageModel();
        pageModel.setContent(func.apply(page.getContent()));
        pageModel.setPage(pageable.getPageNumber());
        pageModel.setPageSize(page.getSize());
        pageModel.setSize(page.getSize());
        pageModel.setTotalCounts(page.getTotalElements());
        pageModel.setTotalPages(page.getTotalPages());
        pageModel.setFirst(page.isFirst());
        pageModel.setLast(page.isLast());
        return pageModel;
    }

    public static <T, R> PageModel<R> toPageModel(PageModel<T> pageContent, Function<List<T>, List<R>> func) {
        PageModel pageModel = new PageModel();
        pageModel.setContent(func.apply(pageContent.getContent()));
        pageModel.setPage(pageContent.getPage());
        pageModel.setPageSize(pageContent.getSize());
        pageModel.setSize(pageContent.getSize());
        pageModel.setTotalCounts(pageContent.getTotalCounts());
        pageModel.setTotalPages(pageContent.getTotalPages());
        pageModel.setFirst(pageContent.isFirst());
        pageModel.setLast(pageContent.isLast());
        return pageModel;
    }

    public static <T> PageModel<T> toPageModel(List<T> data, Pageable pageable, long total) {
        PageImpl page = null;
        if (data != null) {
            page = new PageImpl(data, pageable, total);
        }
        return new PageModel((Page)page, pageable.getPageNumber(), pageable.getPageSize());
    }
}

