/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.ecp.service.tool.StreamUtil;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;

public final class QRCodeUtil {
    private static final int QRCODE_WIDTH = 200;

    private QRCodeUtil() {
    }

    public static void genQRCodeToResponse(String content, HttpServletResponse response) {
        HashMap<EncodeHintType, String> hintMap = new HashMap<EncodeHintType, String>();
        hintMap.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        try {
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix byteMatrix = qrCodeWriter.encode(content, BarcodeFormat.QR_CODE, 200, 200, hintMap);
            MatrixToImageWriter.writeToStream((BitMatrix)byteMatrix, (String)"png", (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            throw new AbcServiceException("ABC.0015", "\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25\u3002", e, new Object[0]);
        }
    }

    public static byte[] genQRCodeToByteArray(String content) {
        byte[] byArray;
        HashMap<EncodeHintType, String> hintMap = new HashMap<EncodeHintType, String>();
        hintMap.put(EncodeHintType.CHARACTER_SET, "UTF-8");
        ByteArrayOutputStream os = null;
        try {
            QRCodeWriter qrCodeWriter = new QRCodeWriter();
            BitMatrix byteMatrix = qrCodeWriter.encode(content, BarcodeFormat.QR_CODE, 200, 200, hintMap);
            os = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream((BitMatrix)byteMatrix, (String)"png", (OutputStream)os);
            byArray = os.toByteArray();
        }
        catch (Exception e) {
            try {
                throw new AbcServiceException("ABC.0015", "\u751f\u6210\u4e8c\u7ef4\u7801\u5931\u8d25\u3002", e, new Object[0]);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(os);
                throw throwable;
            }
        }
        StreamUtil.closeStream((OutputStream)os);
        return byArray;
    }
}

