/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.cache.RedissonClientFactory;
import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.exception.LockFailedException;
import com.ygsoft.abc.service.function.Workable;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.ecp.service.cache.impl.redis.RedisClientFactory;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;

public final class RedisLockUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(RedisLockUtil.class);
    private static final long ACQUIRE_TIMEOUT = 7000L;
    private static final long EXPIRE_TIME = 90000L;
    private static final String LOCK_PREFIX = "abc:lock:";
    private RLock redisLock;

    private RedisLockUtil() {
    }

    private String getLockPrefix() {
        return RedisClientFactory.getDefaultInstance().getCacheConfigUtil().getAppId("abc") + "#" + "abc" + "#" + LOCK_PREFIX;
    }

    public static RedisLockUtil getInstance() {
        RedisLockUtil entity = new RedisLockUtil();
        return entity;
    }

    private static RedissonClient getRedissonClient() {
        return RedissonClientFactory.getRedissonClient();
    }

    public static void executeWithLock(String lockName, Workable work) {
        PreconditionUtil.checkNotTrimEmpty(lockName, "\u53c2\u6570\u9519\u8bef\uff1alockName\u4e3a\u7a7a\u3002");
        RedisLockUtil lockUtil = RedisLockUtil.getInstance();
        try {
            lockUtil.tryLockWithException(lockName);
            work.run();
        }
        finally {
            lockUtil.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> R executeWithLock(String lockName, T t, Function<T, R> func) {
        PreconditionUtil.checkNotTrimEmpty(lockName, "\u53c2\u6570\u9519\u8bef\uff1alockName\u4e3a\u7a7a\u3002");
        RedisLockUtil lockUtil = RedisLockUtil.getInstance();
        try {
            lockUtil.tryLockWithException(lockName);
            R r = func.apply(t);
            return r;
        }
        finally {
            lockUtil.unlock();
        }
    }

    public static void executeTryLock(String lockName, Workable work) {
        RedisLockUtil.executeTryLock(lockName, 7000L, 90000L, work);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeTryLock(String lockName, long acquireTimeout, long expireTime, Workable work) {
        PreconditionUtil.checkNotTrimEmpty(lockName, "\u53c2\u6570\u9519\u8bef\uff1alockName\u4e3a\u7a7a\u3002");
        RedisLockUtil lockUtil = RedisLockUtil.getInstance();
        try {
            lockUtil.tryLockWithException(lockName, acquireTimeout, expireTime);
            work.run();
        }
        finally {
            lockUtil.unlock();
        }
    }

    public static <T, R> R executeTryLock(String lockName, T t, Function<T, R> func) {
        return RedisLockUtil.executeTryLock(lockName, 7000L, 90000L, t, func);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R> R executeTryLock(String lockName, long acquireTimeout, long expireTime, T t, Function<T, R> func) {
        PreconditionUtil.checkNotTrimEmpty(lockName, "\u53c2\u6570\u9519\u8bef\uff1alockName\u4e3a\u7a7a\u3002");
        RedisLockUtil lockUtil = RedisLockUtil.getInstance();
        try {
            lockUtil.tryLockWithException(lockName, acquireTimeout, expireTime);
            R r = func.apply(t);
            return r;
        }
        finally {
            lockUtil.unlock();
        }
    }

    public void lock(String lockName) {
        if (StringUtil.isNullOrTrimEmptyString((String)lockName)) {
            String msg = "\u53c2\u6570\u9519\u8bef\uff1alockName\u4e3a\u7a7a\u3002";
            String i18nMsg = EcpI18nUtil.localizedString((String)"RedisLockUtil_acquireLock_90", (String)"\u53c2\u6570\u9519\u8bef\uff1alockName\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", i18nMsg);
        }
        String lockKey = this.getLockPrefix() + lockName;
        this.redisLock = RedisLockUtil.getRedissonClient().getLock(lockKey);
        try {
            this.redisLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            throw EmptyValueException.newInstance("\u83b7\u53d6\u9501\u5931\u8d25\uff1alockName=" + lockName);
        }
    }

    public boolean tryLock(String lockName) {
        return this.tryLock(lockName, 7000L);
    }

    public boolean tryLock(String lockName, long acquireTimeout) {
        return this.tryLock(lockName, acquireTimeout, 90000L);
    }

    public void tryLockWithException(String lockName) {
        this.tryLockWithException(lockName, 7000L);
    }

    public void tryLockWithException(String lockName, long acquireTimeout) {
        this.tryLockWithException(lockName, acquireTimeout, 90000L);
    }

    public void tryLockWithException(String lockName, long acquireTimeout, long expireTime) {
        boolean flag = this.tryLock(lockName, acquireTimeout, expireTime);
        if (!flag) {
            throw LockFailedException.newInstance("\u52a0\u9501\u5931\u8d25\u3002");
        }
    }

    public boolean tryLock(String lockName, long acquireTimeout, long expireTime) {
        if (StringUtil.isNullOrTrimEmptyString((String)lockName)) {
            String msg = "\u53c2\u6570\u9519\u8bef\uff1alockName\u4e3a\u7a7a\u3002";
            String i18nMsg = EcpI18nUtil.localizedString((String)"RedisLockUtil_acquireLock_90", (String)"\u53c2\u6570\u9519\u8bef\uff1alockName\u4e3a\u7a7a\u3002");
            throw new EmptyValueException("ABC.0001", i18nMsg);
        }
        if (acquireTimeout <= 0L) {
            String msg = "\u53c2\u6570\u9519\u8bef\uff1aacquireTimeout<=0\u3002";
            String i18nMsg = EcpI18nUtil.localizedString((String)"RedisLockUtil_acquireLock_94", (String)"\u53c2\u6570\u9519\u8bef\uff1aacquireTimeout<=0\u3002");
            throw new EmptyValueException("ABC.0007", i18nMsg);
        }
        if (expireTime <= 0L) {
            String msg = "\u53c2\u6570\u9519\u8bef\uff1alockTimeout<=0\u3002";
            String i18nMsg = EcpI18nUtil.localizedString((String)"RedisLockUtil_acquireLock_98", (String)"\u53c2\u6570\u9519\u8bef\uff1alockTimeout<=0\u3002");
            throw new EmptyValueException("ABC.0007", i18nMsg);
        }
        String lockKey = this.getLockPrefix() + lockName;
        this.redisLock = RedisLockUtil.getRedissonClient().getLock(lockKey);
        try {
            boolean res = this.redisLock.tryLock(acquireTimeout, expireTime, TimeUnit.MILLISECONDS);
            return res;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"tryLock \u4e2d\u65ad\u3002", (Throwable)e);
            }
            return false;
        }
    }

    public void unlock() {
        if (Objects.isNull(this.redisLock)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"redisLock \u4e3a\u7a7a\uff0c\u65e0\u9700\u89e3\u9501\u3002");
            }
            return;
        }
        if (this.redisLock.isLocked() && this.redisLock.isHeldByCurrentThread()) {
            this.redisLock.unlock();
        } else if (LOG.isWarnEnabled()) {
            LOG.warn((Object)"redisLock \u672a\u52a0\u9501\u6216\u975e\u672c\u7ebf\u7a0b\u6301\u6709\uff0c\u65e0\u6cd5\u89e3\u9501\u3002");
        }
    }
}

