/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.necp.core.service.function.Objects;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.Unmarshaller;

public final class XmlTransferUtil {
    private static final String TAG_NAME_PATTERN = "</?(\\w+?)>";

    private XmlTransferUtil() {
    }

    public static String toCamelCaseTag(String str) {
        if (StringUtil.isNullOrTrimEmptyString((String)str)) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder();
            Pattern p = Pattern.compile(TAG_NAME_PATTERN);
            Matcher m = p.matcher(str);
            int index = 0;
            int start = 0;
            int end = 0;
            while (m.find()) {
                String tagName = m.group(0);
                start = m.start();
                end = m.end();
                if (start > index) {
                    sb.append(str.subSequence(index, start));
                }
                sb.append(XmlTransferUtil.toCamelCase(tagName));
                index = end;
            }
            if (index < str.length()) {
                sb.append(str.substring(index));
            }
            return sb.toString();
        }
        catch (Exception e) {
            String msg = "xml\u5b57\u7b26\u4e32\u8f6c\u5c0f\u5199tag\u5931\u8d25\u3002";
            throw new AbcServiceException("ABC.0015", "xml\u5b57\u7b26\u4e32\u8f6c\u5c0f\u5199tag\u5931\u8d25\u3002", e, new Object[0]);
        }
    }

    private static String toCamelCase(String tagName) {
        if (tagName.startsWith("</")) {
            String first = tagName.substring(2, 3);
            return "</" + first.toLowerCase() + tagName.substring(3);
        }
        if (tagName.startsWith("<")) {
            String first = tagName.substring(1, 2);
            return "<" + first.toLowerCase() + tagName.substring(2);
        }
        String msg = "\u89e3\u6790xml\u51fa\u9519\u3002";
        throw new AbcServiceException("ABC.0015", "\u89e3\u6790xml\u51fa\u9519\u3002");
    }

    public static String objectToString(Object obj, boolean withHead) {
        HashMap<String, Boolean> option = new HashMap<String, Boolean>();
        if (withHead) {
            option.put("jaxb.fragment", Boolean.FALSE);
        } else {
            option.put("jaxb.fragment", Boolean.TRUE);
        }
        return XmlTransferUtil.objectToString(obj, option);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String objectToString(Object obj, Map<String, Boolean> option) {
        if (Objects.isNull((Object)obj)) {
            return null;
        }
        try (StringWriter sw = new StringWriter();){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{obj.getClass()});
            Marshaller marshaller = context.createMarshaller();
            XmlTransferUtil.setProperties(marshaller, option);
            marshaller.marshal(obj, (Writer)sw);
            String string = sw.toString();
            return string;
        }
        catch (Exception e) {
            String msg = "\u5bf9\u8c61\u8f6cxml\u5b57\u7b26\u4e32\u5931\u8d25\u3002";
            throw new AbcServiceException("ABC.0015", "\u5bf9\u8c61\u8f6cxml\u5b57\u7b26\u4e32\u5931\u8d25\u3002", e, new Object[0]);
        }
    }

    private static void setProperties(Marshaller marshaller, Map<String, Boolean> option) throws PropertyException {
        if (BlockCollectionUtil.isEmpty(option)) {
            return;
        }
        for (Map.Entry<String, Boolean> entry : option.entrySet()) {
            marshaller.setProperty(entry.getKey(), (Object)entry.getValue());
        }
    }

    public static Object stringToObject(String str, Class<?> clazz) {
        if (StringUtil.isNullOrTrimEmptyString((String)str)) {
            return null;
        }
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{clazz});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            return unmarshaller.unmarshal((Reader)new StringReader(str));
        }
        catch (JAXBException e) {
            String msg = "xml\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u5931\u8d25\u3002";
            throw new AbcServiceException("ABC.0015", "xml\u5b57\u7b26\u4e32\u8f6c\u5bf9\u8c61\u5931\u8d25\u3002", e, new Object[0]);
        }
    }
}

