/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.transaction;

import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.util.function.Function;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationAdapter;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public final class TransactionSynchronizationUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(TransactionSynchronizationUtil.class);

    private TransactionSynchronizationUtil() {
    }

    public static void afterCommit(final Function<Object, Object> func) {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"\u5f53\u524d\u7ebf\u7a0b\u65e0\u4e8b\u52a1\u3002");
            }
            func.apply(null);
            return;
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCommit() {
                func.apply(null);
            }
        });
    }

    public static void afterCompletion(final Function<Integer, Object> func) {
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"\u5f53\u524d\u7ebf\u7a0b\u65e0\u4e8b\u52a1\u3002");
            }
            func.apply(-1);
            return;
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

            public void afterCompletion(int status) {
                func.apply(status);
            }
        });
    }

    public static boolean isRollback(int status) {
        return 1 == status;
    }
}

