/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.validator;

import com.ygsoft.abc.service.annotation.valid.AfterDate;
import com.ygsoft.abc.service.tool.BlockDateUtil;
import com.ygsoft.abc.service.tool.LocalDateUtil;
import com.ygsoft.abc.service.types.DateTimeUnitEnum;
import com.ygsoft.ecp.service.exception.EcpCheckException;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class AfterDateValidator
implements ConstraintValidator<AfterDate, Object> {
    private DateTimeUnitEnum dateTimeUnit;
    private boolean containsEqual;

    public void initialize(AfterDate constraintAnnotation) {
        this.dateTimeUnit = constraintAnnotation.dateTimeUnit();
        this.containsEqual = constraintAnnotation.containsEqual();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (Objects.isNull(value)) {
            return true;
        }
        if (!this.isDate(value)) {
            throw new EcpCheckException("ABC.0015", "\u65e5\u671f\u7c7b\u578b\u4e0d\u652f\u6301\u3002");
        }
        Class<?> clazz = value.getClass();
        if (clazz.equals(Date.class)) {
            Date date = (Date)value;
            return BlockDateUtil.afterNowByDateTimeUnit(date, this.dateTimeUnit, this.containsEqual);
        }
        if (clazz.equals(LocalDateTime.class)) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            return LocalDateUtil.afterNowByDateTimeUnit(localDateTime, this.dateTimeUnit, this.containsEqual);
        }
        return false;
    }

    private boolean isDate(Object value) {
        Class<?> clazz = value.getClass();
        if (clazz.equals(Date.class)) {
            return true;
        }
        return clazz.equals(LocalDateTime.class);
    }
}

