/*
 * Decompiled with CFR 0.152.
 */
package com.pansoft.xbrl.xbrljson.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;

public class ClassUtils {
    private static Logger log = Logger.getLogger(ClassUtils.class.toString());
    private static final String UTF8 = "UTF-8";
    private static final String JAR = "jar";
    private static final String FILE = "file";
    private static final String ZIP = "zip";
    private static final String VFS = "vfs";
    private static final String POINT = ".";
    private static Set<Class<?>> allClassSet = null;

    public static Set<Class<?>> getByInterface(Class clazz) {
        String packageName = clazz.getPackage().getName();
        return ClassUtils.getByInterface(clazz, packageName);
    }

    public static Set<Class<?>> getByInterface(Class clazz, String packageName) {
        LinkedHashSet classes = new LinkedHashSet();
        if (clazz.isInterface()) {
            try {
                Set<Class<?>> classesAll = ClassUtils.getClasses(packageName);
                for (Class<?> cls : classesAll) {
                    if (!cls.getPackage().getName().startsWith(packageName) || !clazz.isAssignableFrom(cls) || clazz.equals(cls)) continue;
                    classes.add(cls);
                }
            }
            catch (Exception e) {
                log.info("\u51fa\u73b0\u5f02\u5e38" + e);
            }
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Class<?>> getClasses(String packageName) {
        if (null != allClassSet) {
            return allClassSet;
        }
        LinkedHashSet classes = new LinkedHashSet();
        String packageDirName = packageName.replace('.', '/');
        Enumeration<URL> dirs = null;
        try {
            dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
        }
        catch (IOException e) {
            log.info(e.toString());
        }
        if (null == dirs) {
            return classes;
        }
        while (dirs.hasMoreElements()) {
            JarFile jar;
            String file;
            URL url = dirs.nextElement();
            String protocol = url.getProtocol();
            if (FILE.equals(protocol)) {
                String filePath = null;
                try {
                    filePath = URLDecoder.decode(url.getFile(), UTF8);
                }
                catch (UnsupportedEncodingException e) {
                    log.info(e.toString());
                }
                ClassUtils.findAndAddClassesInPackageByFile(packageName, filePath, classes);
                continue;
            }
            if (JAR.equals(protocol)) {
                try {
                    JarFile jar2 = ((JarURLConnection)url.openConnection()).getJarFile();
                    ClassUtils.searchClass(jar2, packageDirName, classes);
                }
                catch (IOException e) {
                    log.info(e.toString());
                }
                continue;
            }
            if (ZIP.equals(protocol)) {
                file = url.getFile();
                file = file.substring(0, file.lastIndexOf(".jar") + 4);
                jar = null;
                try {
                    jar = new JarFile(file);
                    ClassUtils.searchClass(jar, packageDirName, classes);
                    continue;
                }
                catch (IOException e) {
                    log.info(e.toString());
                    continue;
                }
                finally {
                    if (jar != null) {
                        ClassUtils.safeClose(jar);
                    }
                    continue;
                }
            }
            if (!VFS.equals(protocol)) continue;
            file = url.getFile();
            if (file.indexOf(".jar") > -1) {
                file = file.substring(0, file.lastIndexOf(".jar") + 4);
                jar = null;
                try {
                    jar = new JarFile(file);
                    ClassUtils.searchClass(jar, packageDirName, classes);
                    continue;
                }
                catch (IOException e) {
                    log.info(e.toString());
                    continue;
                }
                finally {
                    if (jar != null) {
                        ClassUtils.safeClose(jar);
                    }
                    continue;
                }
            }
            String filePath = null;
            try {
                filePath = URLDecoder.decode(url.getFile(), UTF8);
            }
            catch (UnsupportedEncodingException e) {
                log.info(e.toString());
            }
            ClassUtils.findAndAddClassesInPackageByFile(packageName, filePath, classes);
        }
        allClassSet = classes;
        return classes;
    }

    private static void searchClass(JarFile jar, String packageDirName, Set<Class<?>> classes) {
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String name = entry.getName();
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (!name.startsWith(packageDirName)) continue;
            int idx = name.lastIndexOf(47);
            String jarPackageName = null;
            if (idx != -1) {
                jarPackageName = name.substring(0, idx).replace('/', '.');
            }
            if (null == jarPackageName || idx == -1 || !name.endsWith(".class") || entry.isDirectory()) continue;
            String className = name.substring(jarPackageName.length() + 1, name.length() - 6);
            try {
                classes.add(Class.forName(jarPackageName + '.' + className));
            }
            catch (Error er) {
                log.info(er.toString());
            }
            catch (Exception e) {
                log.info(e.toString());
            }
        }
    }

    public static void findAndAddClassesInPackageByFile(String packageName, String packagePath, Set<Class<?>> classes) {
        File[] dirFiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirFiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                ClassUtils.findAndAddClassesInPackageByFile(packageName + POINT + file.getName(), file.getAbsolutePath(), classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                log.info(e.toString());
            }
        }
    }

    public static void safeClose(JarFile jf) {
        if (jf != null) {
            try {
                jf.close();
            }
            catch (IOException e) {
                log.info(e.toString());
            }
        }
    }
}

