/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.async;

import com.ygsoft.ecp.framework.cons.ServerProps;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorServiceCache {
    private static final int COMMON_EXECUTOR_CORE_POOL_SIZE = Integer.parseInt(ServerProps.getProperty((String)"necp.async.core-pool-size", (String)"50"));
    private static final int COMMON_EXECUTOR_MAXIMUM_POOL_SIZE = Integer.parseInt(ServerProps.getProperty((String)"necp.async.maximum-pool-size", (String)"100"));
    private static final int COMMON_EXECUTOR_QUEUE_SIZE = Integer.parseInt(ServerProps.getProperty((String)"necp.async.queue-size", (String)"50000"));
    private static ExecutorService executor = null;

    public static ExecutorService getExecutorService() {
        if (executor == null) {
            ExecutorServiceCache.init();
        }
        return executor;
    }

    public static void init() {
        executor = new ThreadPoolExecutor(COMMON_EXECUTOR_CORE_POOL_SIZE, COMMON_EXECUTOR_MAXIMUM_POOL_SIZE, 1800L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(COMMON_EXECUTOR_QUEUE_SIZE), new DefaultThreadFactory(), new ThreadPoolExecutor.AbortPolicy());
    }

    public static void destory() {
        if (executor != null) {
            executor.shutdown();
            executor = null;
        }
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        static final AtomicInteger poolNumber = new AtomicInteger(1);
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;

        DefaultThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "Asyn-pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

