/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.dataaccess;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.cache.ICache;
import com.ygsoft.ecp.service.dataaccess.ICommonTreeDataFilter;
import com.ygsoft.ecp.service.dataaccess.ICommonTreeQueryDao;
import com.ygsoft.ecp.service.entity.AbstractEntity;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.DBUitl;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonTreeQueryDao<NodeEntity extends AbstractEntity>
implements ICommonTreeQueryDao<NodeEntity> {
    private String treeKey;
    private String parentKey;
    private String sortKey;
    private ICommonTreeDataFilter<NodeEntity> dataFilter;
    private List<NodeEntity> filteredNodes;
    private List<String> leafNodeList = new ArrayList<String>();
    private Map<String, String> nodePathMap = new HashMap<String, String>();
    private Map<String, NodeEntity> nodeMap = new HashMap<String, NodeEntity>();
    private boolean isGenerateNodePath = false;
    private boolean isGenerateNodeLeaf = false;
    private boolean isMultiStartWith = false;
    private static final String COMMONTREE_QUERY_CACHE = "ecp.common.treequery";
    private static final String SPLIT_CHAR = "/";
    private Class<NodeEntity> clazz;

    @Override
    public void setSortKey(String sortKey) {
        this.sortKey = sortKey;
    }

    @Override
    public void setKey(String newTreeKey) {
        this.treeKey = newTreeKey;
    }

    @Override
    public void setParentKey(String newParentKey) {
        this.parentKey = newParentKey;
    }

    @Override
    public void setCacheFetchMode() {
    }

    public CommonTreeQueryDao(Class<NodeEntity> newClazz) {
        this.clazz = newClazz;
    }

    @Override
    public void setDataFilter(ICommonTreeDataFilter<NodeEntity> newDataFilter) {
        this.dataFilter = newDataFilter;
        this.filteredNodes = null;
    }

    private List<NodeEntity> loadAllTreeNodes() {
        if (StringUtil.isEmpty(this.sortKey)) {
            this.setSortKey(this.treeKey);
        }
        List<NodeEntity> entityList = DBUitl.getHibernateTemplate().findByHQLWithoutRowNumLimit("from " + this.clazz.getName() + " treeEntity order by treeEntity." + this.sortKey, this.clazz);
        return entityList;
    }

    private String getDoMainCacheKey() {
        return "ecp.common.treequery$" + this.clazz.getName();
    }

    private List<NodeEntity> getAllTreeNodes() {
        if (StringUtil.isNullOrTrimEmptyString(this.treeKey) || StringUtil.isNullOrTrimEmptyString(this.parentKey)) {
            throw new EcpRuntimeException("E0208.0026", EcpI18nUtil.localizedString("E0208.0026", "\u672a\u521d\u59cb\u5316\u5b9e\u4f53\u6811\u7684\u7236\u5b50\u5173\u952e\u5b57\u6bb5\u4fe1\u606f."));
        }
        ICache<String, List<NodeEntity>> cache = EcpService.getCacheService(COMMONTREE_QUERY_CACHE);
        List<NodeEntity> treeList = (List<NodeEntity>)cache.get(this.getDoMainCacheKey());
        if (treeList == null) {
            treeList = this.loadAllTreeNodes();
            cache.put(this.getDoMainCacheKey(), treeList);
        }
        return treeList;
    }

    private List<NodeEntity> getFilteredNodes() {
        if (this.filteredNodes != null) {
            return this.filteredNodes;
        }
        List<NodeEntity> allTreeNodes = this.getAllTreeNodes();
        if (this.dataFilter == null) {
            return allTreeNodes;
        }
        this.filteredNodes = new ArrayList<NodeEntity>();
        for (AbstractEntity node : allTreeNodes) {
            if (!this.dataFilter.contains(node)) continue;
            this.filteredNodes.add(node);
        }
        return this.filteredNodes;
    }

    private String getNodeIdValue(NodeEntity node, boolean isParent) {
        String keyPropName = this.treeKey;
        if (isParent) {
            keyPropName = this.parentKey;
        }
        Object nodeValue = ClassUtil.getValues(node, new String[]{keyPropName})[0];
        String convertedNodeValue = null;
        if (nodeValue != null) {
            convertedNodeValue = nodeValue.toString();
        }
        return convertedNodeValue;
    }

    private void generateChildNodes(List<NodeEntity> nodeList, String nodeId, String nodePath, List<NodeEntity> childNodes) {
        String curNodeId = null;
        String curNodePath = null;
        ArrayList<String> curChildNodeIds = new ArrayList<String>();
        for (AbstractEntity node : nodeList) {
            String pNodeId = this.getNodeIdValue(node, true);
            if (!nodeId.equals(pNodeId)) continue;
            childNodes.add(node);
            curNodeId = this.getNodeIdValue(node, false);
            if (this.isGenerateNodeLeaf) {
                curChildNodeIds.add(curNodeId);
            }
            if (this.isGenerateNodePath) {
                curNodePath = nodePath + SPLIT_CHAR + curNodeId;
                this.nodePathMap.put(curNodeId, curNodePath);
                this.nodeMap.put(curNodeId, node);
            }
            this.generateChildNodes(nodeList, curNodeId, curNodePath, childNodes);
        }
        if (this.isGenerateNodeLeaf && this.leafNodeList != null && curChildNodeIds.size() == 0) {
            this.leafNodeList.add(nodeId);
        }
    }

    private void generateParentNodes(List<NodeEntity> nodeList, String nodeId, String nodePath, List<NodeEntity> parentNodeList) {
        String pNodeId = null;
        String curNodeId = null;
        String curNodePath = null;
        ArrayList<String> curChildNodeIds = new ArrayList<String>();
        for (AbstractEntity node : nodeList) {
            curNodeId = this.getNodeIdValue(node, false);
            if (!curNodeId.equals(nodeId)) continue;
            pNodeId = this.getNodeIdValue(node, true);
            parentNodeList.add(node);
            if (this.isGenerateNodePath) {
                curNodePath = nodePath + SPLIT_CHAR + curNodeId;
                this.nodePathMap.put(curNodeId, curNodePath);
            }
            if (!StringUtil.isNotEmpty(pNodeId)) break;
            if (this.isGenerateNodeLeaf) {
                curChildNodeIds.add(curNodeId);
            }
            this.generateParentNodes(nodeList, pNodeId, curNodePath, parentNodeList);
            break;
        }
        if (this.isGenerateNodeLeaf && this.leafNodeList != null && curChildNodeIds.size() == 0) {
            this.leafNodeList.add(nodeId);
        }
    }

    private NodeEntity findByNodeId(String nodeId) {
        List<NodeEntity> nodeList = this.getFilteredNodes();
        AbstractEntity locatedNode = null;
        String pointNodeId = null;
        boolean isNullMode = false;
        if (StringUtil.isNullOrTrimEmptyString(nodeId)) {
            isNullMode = true;
        }
        for (AbstractEntity entity : nodeList) {
            pointNodeId = this.getNodeIdValue(entity, isNullMode);
            if ((!isNullMode || !StringUtil.isNullOrTrimEmptyString(pointNodeId)) && (isNullMode || !nodeId.equals(pointNodeId))) continue;
            locatedNode = entity;
            break;
        }
        return (NodeEntity)locatedNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeEntity> findByStartWith(String rootId, boolean isInversed) {
        String startWithRootId;
        ArrayList<NodeEntity> nodeList;
        block7: {
            nodeList = new ArrayList<NodeEntity>();
            startWithRootId = rootId;
            try {
                if (!this.isMultiStartWith) {
                    this.leafNodeList.clear();
                    this.nodePathMap.clear();
                    this.nodeMap.clear();
                }
                this.isGenerateNodeLeaf = true;
                this.isGenerateNodePath = true;
                NodeEntity rootNode = this.findByNodeId(rootId);
                if (rootNode != null) {
                    nodeList.add(rootNode);
                    String rootNodeId = this.getNodeIdValue(rootNode, false);
                    this.nodePathMap.put(rootNodeId, rootNodeId);
                    this.nodeMap.put(rootNodeId, rootNode);
                    if (StringUtil.isNullOrTrimEmptyString(rootId)) {
                        startWithRootId = rootNodeId;
                    }
                    break block7;
                }
                ArrayList<NodeEntity> rootNodeId = nodeList;
                Object var8_8 = null;
                this.isGenerateNodeLeaf = false;
                this.isGenerateNodePath = false;
                return rootNodeId;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                this.isGenerateNodeLeaf = false;
                this.isGenerateNodePath = false;
                throw throwable;
            }
        }
        List<NodeEntity> foundNodeList = null;
        foundNodeList = isInversed ? this.findParentNodes(startWithRootId) : this.findChildNodes(startWithRootId);
        if (foundNodeList != null && foundNodeList.size() > 0) {
            nodeList.addAll(foundNodeList);
        }
        Object var8_9 = null;
        this.isGenerateNodeLeaf = false;
        this.isGenerateNodePath = false;
        return nodeList;
    }

    private List<NodeEntity> findRootNodeIdsByNull() {
        List<NodeEntity> nodeList = this.getFilteredNodes();
        ArrayList<AbstractEntity> rootNodeIds = new ArrayList<AbstractEntity>();
        String pointNodeId = null;
        for (AbstractEntity entity : nodeList) {
            pointNodeId = this.getNodeIdValue(entity, true);
            if (!StringUtil.isNullOrTrimEmptyString(pointNodeId)) continue;
            rootNodeIds.add(entity);
        }
        return rootNodeIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeEntity> findByStartWithMulti(String[] multiNodeRootId, boolean isInversed) {
        ArrayList<NodeEntity> multiNodeList = new ArrayList<NodeEntity>();
        try {
            this.leafNodeList.clear();
            this.nodePathMap.clear();
            this.nodeMap.clear();
            this.isMultiStartWith = true;
            if (multiNodeRootId != null) {
                for (int i = 0; i < multiNodeRootId.length; ++i) {
                    multiNodeList.addAll(this.findByStartWith(multiNodeRootId[i], isInversed));
                }
            } else {
                List<String> multiRootNodeList = this.convertToNodeIdList(this.findRootNodeIdsByNull());
                for (int i = 0; i < multiRootNodeList.size(); ++i) {
                    multiNodeList.addAll(this.findByStartWith(multiRootNodeList.get(i), isInversed));
                }
            }
            Object var7_7 = null;
            this.isMultiStartWith = false;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.isMultiStartWith = false;
            throw throwable;
        }
        return multiNodeList;
    }

    @Override
    public List<String> getLeafNodeList() {
        return this.leafNodeList;
    }

    @Override
    public Map<String, String> getNodePathInfo() {
        return this.nodePathMap;
    }

    @Override
    public Map<String, String> getNodePathInfo(String attrName) {
        HashMap<String, String> newNodePathInfo = new HashMap<String, String>();
        String[] nodeIdPathArr = null;
        String nodeAttrPath = null;
        String nodeAttrValue = null;
        AbstractEntity entity = null;
        StringBuffer newNodePath = new StringBuffer();
        for (Map.Entry<String, String> entry : this.nodePathMap.entrySet()) {
            if (!StringUtil.isNotEmpty(entry.getValue())) continue;
            nodeAttrPath = entry.getValue();
            nodeIdPathArr = nodeAttrPath.split(SPLIT_CHAR);
            newNodePath.setLength(0);
            for (int i = 0; i < nodeIdPathArr.length && (entity = (AbstractEntity)this.nodeMap.get(nodeIdPathArr[i])) != null; ++i) {
                Object nodeValue = ClassUtil.getValues(entity, new String[]{attrName})[0];
                nodeAttrValue = nodeValue == null ? "" : nodeValue.toString();
                if (newNodePath.length() != 0) {
                    newNodePath.append(SPLIT_CHAR);
                }
                newNodePath.append(nodeAttrValue);
            }
            newNodePathInfo.put(entry.getKey(), newNodePath.toString());
        }
        return newNodePathInfo;
    }

    @Override
    public List<NodeEntity> findChildNodes(String currentNodeId) {
        ArrayList childNodes = new ArrayList();
        List<NodeEntity> allNodeList = this.getFilteredNodes();
        this.generateChildNodes(allNodeList, currentNodeId, currentNodeId, childNodes);
        return childNodes;
    }

    @Override
    public List<NodeEntity> findParentNodes(String currentNodeId) {
        ArrayList parentNodeList = new ArrayList();
        NodeEntity rootNode = this.findByNodeId(currentNodeId);
        if (rootNode == null) {
            return parentNodeList;
        }
        String pNodeId = this.getNodeIdValue(rootNode, true);
        if (StringUtil.isEmpty(pNodeId)) {
            return parentNodeList;
        }
        this.generateParentNodes(this.getFilteredNodes(), pNodeId, currentNodeId, parentNodeList);
        return parentNodeList;
    }

    @Override
    public List<String> convertToNodeIdList(List<NodeEntity> nodeList) {
        ArrayList<String> nodeIdList = new ArrayList<String>();
        for (AbstractEntity node : nodeList) {
            nodeIdList.add(this.getNodeIdValue(node, false));
        }
        return nodeIdList;
    }

    @Override
    public void reload() {
        EcpService.getCacheService(COMMONTREE_QUERY_CACHE).remove(this.getDoMainCacheKey());
        this.getAllTreeNodes();
        this.filteredNodes = null;
    }
}

