/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.dataaccess;

import com.ygsoft.ecp.framework.spring.SpringContextHolder;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.exception.ReflectException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.SessionFactory;
import org.springframework.context.ApplicationContext;

public final class SessionFactoryManager {
    private static final IEcpLog LOG = EcpLogFactory.getLog(SessionFactoryManager.class);
    private Map<String, SessionFactory> factoryMap = new ConcurrentHashMap<String, SessionFactory>();
    public static final SessionFactoryManager INSTANCE = new SessionFactoryManager();
    public static final String SF_NAME = "sessionFactory";

    private SessionFactoryManager() {
        ApplicationContext ac = SpringContextHolder.INSTANCE.getApplicationContext();
        if (ac != null && ac.containsBean(SF_NAME)) {
            SessionFactory sessionFactory = (SessionFactory)ac.getBean(SF_NAME);
            this.addFactory("default", sessionFactory);
        }
    }

    public SessionFactory getFactory(String domainName) {
        return SessionFactoryManager.getOriginalSessionFactory(this.factoryMap.get(domainName));
    }

    public boolean containsDomainName(String domainName) {
        return this.factoryMap.containsKey(domainName);
    }

    public boolean containsEntityName(String entityName) {
        if (this.factoryMap.size() <= 1) {
            return false;
        }
        for (String domainName : this.factoryMap.keySet()) {
            if (!this.isContains(entityName, domainName)) continue;
            return true;
        }
        return false;
    }

    public SessionFactory getFactoryForTransactionSync() {
        return this.factoryMap.get("default");
    }

    public SessionFactory getFactory() {
        return SessionFactoryManager.getOriginalSessionFactory(this.factoryMap.get("default"));
    }

    public static SessionFactory getOriginalSessionFactory(SessionFactory sessionFactory) {
        if ("com.ygsoft.ecp.service.dataaccess.uapextender.sf.UAPSessionFactoryWapper".equals(sessionFactory.getClass().getName())) {
            try {
                return (SessionFactory)ClassUtil.getStaticAttribute(sessionFactory.getClass(), SF_NAME, false);
            }
            catch (Exception e) {
                throw new ReflectException("E0208.0005", "\u53cd\u5c04\u83b7\u53d6UAPSessionFactoryWapper\u5305\u88c5\u7684SessionFactory\u51fa\u73b0\u5f02\u5e38", e, new Object[0]);
            }
        }
        return sessionFactory;
    }

    public void addFactory(String domainName, SessionFactory sessionFactory) {
        if (!this.factoryMap.containsKey(domainName)) {
            this.factoryMap.put(domainName, sessionFactory);
        }
    }

    public SessionFactory getSessionFactory(String entityName) {
        if (StringUtil.isEmptyString(entityName)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u6ca1\u6709\u67e5\u627e\u67e5\u627e\u5230[" + entityName + "]\u5bf9\u5e94\u7684SessionFactory,\u8fd4\u56de\u9ed8\u8ba4SessionFactory.");
            }
            return this.getFactory();
        }
        if (this.factoryMap.size() == 1) {
            return this.getFactory();
        }
        for (Map.Entry<String, SessionFactory> entry : this.factoryMap.entrySet()) {
            String key = entry.getKey();
            if (!this.isContains(entityName, key)) continue;
            return SessionFactoryManager.getOriginalSessionFactory(entry.getValue());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("\u6ca1\u6709\u67e5\u627e\u67e5\u627e\u5230[" + entityName + "]\u5bf9\u5e94\u7684SessionFactory,\u8fd4\u56de\u9ed8\u8ba4SessionFactory.");
        }
        return this.getFactory();
    }

    private boolean isContains(String entityName, String domainName) {
        if (StringUtil.isNotEmptyString(entityName) && StringUtil.isNotEmptyString(domainName)) {
            String point = domainName + ".";
            String line = domainName + "_";
            return entityName.equals(domainName) || entityName.indexOf(point) >= 0 || entityName.indexOf(line) >= 0;
        }
        return false;
    }

    public void clear() {
        this.factoryMap.clear();
    }
}

