/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.datasource;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.config.DatabaseType;
import com.ygsoft.ecp.service.datasource.DataSourceSwapper;
import com.ygsoft.ecp.service.datasource.DatasourceManager;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.DataSourceUtil;
import com.ygsoft.ecp.service.tool.JNDIUtil;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceWrapper
implements DataSource {
    private static final IEcpLog LOG = EcpLogFactory.getLog(DataSourceWrapper.class);
    private DataSource dataSource;

    public DataSourceWrapper(DataSource newdataSource) {
        this.init(newdataSource);
    }

    private void init(DataSource newdataSource) {
        String dsname = "jdbc/fmismain";
        if (System.getProperty("catalina.base") != null) {
            dsname = "java:/comp/env/jdbc/fmismain";
        }
        try {
            Object ds = JNDIUtil.getJndiObject(dsname);
            if (ds == null) {
                ds = JNDIUtil.getJndiObject("fmismain");
            }
            this.dataSource = ds == null ? newdataSource : (DataSource)ds;
        }
        catch (Throwable e) {
            this.dataSource = newdataSource;
        }
    }

    public DataSource getDataSource() {
        String jndiDS = DataSourceSwapper.INSTANCE.get();
        if (jndiDS == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u5f53\u524d\u4f7f\u7528\u4e3b\u6570\u636e\u6e90,\u540d\u79f0\u4e3a[fmismain]");
            }
            return this.dataSource;
        }
        if (!DataSourceUtil.isDataSourceSwapEnable()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u5f53\u524d\u4e0d\u652f\u6301\u4e3b\u4ece\u5e93\u5207\u6362\uff0c\u8fd4\u56de\u4e3b\u6570\u636e\u6e90\u540d\u79f0\u4e3a[fmismain]");
            }
            return this.dataSource;
        }
        DataSource ds = DatasourceManager.INSTANCE.getSlaveDataSource(jndiDS);
        if (ds == null) {
            if (DatasourceManager.INSTANCE.getJndiDataSources(jndiDS).isEmpty()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("\u5f53\u524d\u6ca1\u6709\u53ef\u4ee5\u7528\u7684\u4ece\u5e93,\u8fd4\u56de\u4e3b\u6570\u636e\u6e90\u540d\u79f0\u4e3a[fmismain]");
                }
                return this.dataSource;
            }
            DataSource target = DatasourceManager.INSTANCE.randomDataSource(jndiDS);
            if (target == null) {
                return this.dataSource;
            }
            return target;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("\u5f53\u524d\u4f7f\u7528\u7684\u6570\u636e\u5e93\u8fde\u63a5\u6570\u636e\u6e90\u540d\u79f0\u4e3a[" + jndiDS + "]");
        }
        return ds;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = null;
        try {
            conn = this.getDataSource().getConnection();
        }
        catch (SQLException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u5931\u8d25." + e.getMessage());
            }
            conn = this.dataSource != null ? this.dataSource.getConnection() : DatasourceManager.INSTANCE.getDefaultDataSource().getConnection();
        }
        DatabaseType curDbType = EcpService.getConfigService().getApplicationConfig().getDatabaseType();
        if (DatabaseType.Oracle.equals((Object)curDbType) || DatabaseType.DM.equals((Object)curDbType)) {
            DatasourceManager.printSessionId(conn);
        }
        return conn;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.getDataSource().getLogWriter();
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.getDataSource().getLoginTimeout();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.getDataSource().setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.getDataSource().setLoginTimeout(seconds);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return null;
    }
}

