/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.datasource;

import com.ygsoft.ecp.service.datasource.DataSourceMonitor;
import com.ygsoft.ecp.service.datasource.DataSourceMonitorObserver;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.concurrent.ConcurrentHashMap;

public final class DatasourceInvokerHolder {
    public static final DatasourceInvokerHolder INSTANCE = new DatasourceInvokerHolder();
    private Map<String, Entity> invokerMap = new ConcurrentHashMap<String, Entity>();

    public void put(String clazzName, String methodName) {
        String name = clazzName + "." + methodName;
        Entity e = this.getRealEntity(name);
        if (e == null) {
            e = new Entity(clazzName, methodName);
            this.invokerMap.put(name, e);
            e.setStatisticsEnabled(false);
        }
        e.changeUpdateEvent();
    }

    private DatasourceInvokerHolder() {
    }

    public void clearStatistics() {
        Iterator<String> it = this.invokerMap.keySet().iterator();
        while (it.hasNext()) {
            this.invokerMap.get(it.next()).clearStatistics();
        }
    }

    public void clearStatistics(String name) {
        Entity e = this.getRealEntity(name);
        if (e != null) {
            e.clearStatistics();
        }
    }

    public boolean isStatisticsEnabled(String name) {
        Entity e = this.getRealEntity(name);
        if (e != null) {
            return e.isStatisticsEnabled();
        }
        return false;
    }

    public void setStatisticsEnabled(boolean enabledStatistics) {
        Iterator<String> it = this.invokerMap.keySet().iterator();
        Entity e = null;
        while (it.hasNext()) {
            e = this.invokerMap.get(it.next());
            e.setStatisticsEnabled(enabledStatistics);
        }
        this.invokerMap.clear();
    }

    public void setStatisticsEnabled(String name, boolean enabledStatistics) {
        Entity e = this.getRealEntity(name);
        if (e == null) {
            String className = name.substring(0, name.lastIndexOf("."));
            String methodName = name.substring(name.lastIndexOf(".") + 1);
            e = new Entity(className, methodName);
            this.invokerMap.put(name, e);
            e.setStatisticsEnabled(true);
        }
        if (enabledStatistics) {
            e.setStatisticsEnabled(true);
        } else {
            e = null;
            this.invokerMap.remove(name);
        }
    }

    public long getStatistic(String name) {
        Entity e = this.getRealEntity(name);
        if (e != null) {
            return e.getInvokeCount();
        }
        return 0L;
    }

    private Entity getRealEntity(String name) {
        if (this.invokerMap.containsKey(name)) {
            return this.invokerMap.get(name);
        }
        return null;
    }

    final class Entity
    extends Observable {
        String clazzName;
        String methodName;
        DataSourceMonitor realMonitor;

        private Entity(String newClazzName, String newMethodName) {
            this.clazzName = newClazzName;
            this.methodName = newMethodName;
            this.realMonitor = new DataSourceMonitor();
            super.addObserver(new DataSourceMonitorObserver(this.realMonitor));
        }

        public void changeUpdateEvent() {
            super.setChanged();
            super.notifyObservers(null);
        }

        public long getInvokeCount() {
            return this.realMonitor.getInvokeCount();
        }

        public void setStatisticsEnabled(boolean newenabledStatistics) {
            this.realMonitor.setStatisticsEnabled(newenabledStatistics);
        }

        public boolean isStatisticsEnabled() {
            return this.realMonitor.isStatisticsEnabled();
        }

        public void clearStatistics() {
            this.realMonitor.clearStatistics();
        }
    }
}

