/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.datasource;

import com.ygsoft.ecp.framework.spring.SpringContextHolder;
import com.ygsoft.ecp.service.config.AppServerType;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.DBUitl;
import com.ygsoft.ecp.service.tool.JNDIUtil;
import com.ygsoft.ecp.service.tool.RuntimeEnvUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatasourceManager {
    private static final IEcpLog LOG = EcpLogFactory.getLog(DatasourceManager.class);
    private static final Set<String> SESSION_SET = new HashSet<String>();
    private Map<String, DataSource> datasourceMap = new ConcurrentHashMap<String, DataSource>();
    private Map<String, List<DataSource>> jndiMap = new ConcurrentHashMap<String, List<DataSource>>();
    private Map<String, DataSource> slaveMap = new ConcurrentHashMap<String, DataSource>();
    private Map<String, Set<String>> masterMap = new ConcurrentHashMap<String, Set<String>>();
    public static final DatasourceManager INSTANCE = new DatasourceManager();
    private static final Random RANDOM = new Random();
    private static final Set<String> FAILURE_SET = new HashSet<String>();

    private DatasourceManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkAllSlaveDataSource() {
        Iterator<String> jndiIterator = this.jndiMap.keySet().iterator();
        Iterator<String> it = this.slaveMap.keySet().iterator();
        DataSource ds = null;
        String key = null;
        Connection conn = null;
        while (jndiIterator.hasNext()) {
            String jndiName = jndiIterator.next();
            int count = 0;
            while (it.hasNext()) {
                Object var10_10;
                key = it.next();
                ds = this.slaveMap.get(key);
                try {
                    block12: {
                        try {
                            conn = ds.getConnection();
                            if (conn == null) break block12;
                            boolean res = this.validationConnection(conn);
                            if (res) {
                                ++count;
                                FAILURE_SET.remove(key);
                                if (LOG.isInfoEnabled()) {
                                    LOG.info("\u4ece\u5e93\u83b7\u53d6\u8fde\u63a5\u6210\u529f,\u4ece\u5e93JNDI\u6570\u636e\u6e90\u540d\u79f0:" + key);
                                }
                            } else {
                                if (LOG.isInfoEnabled()) {
                                    LOG.info("\u4ece\u5e93\u83b7\u53d6\u8fde\u63a5\u5931\u8d25,\u8bf7\u53ca\u65f6\u6062\u590d,\u4ece\u5e93JNDI\u6570\u636e\u6e90\u540d\u79f0:" + key);
                                }
                                FAILURE_SET.add(key);
                            }
                        }
                        catch (Throwable e) {
                            if (LOG.isErrorEnabled()) {
                                LOG.error("\u4ece\u5e93\u83b7\u53d6\u8fde\u63a5\u5931\u8d25,\u8bf7\u53ca\u65f6\u6062\u590d,\u4ece\u5e93JNDI\u6570\u636e\u6e90\u540d\u79f0:" + key, e);
                            }
                            var10_10 = null;
                            DBUitl.closeConnection(conn);
                            continue;
                        }
                    }
                    var10_10 = null;
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    DBUitl.closeConnection(conn);
                    throw throwable;
                }
                DBUitl.closeConnection(conn);
            }
            if (!LOG.isInfoEnabled()) continue;
            LOG.info("\u4e3b\u5e93JNDI\u6570\u636e\u6e90\u540d\u79f0:" + jndiName + ",\u53ef\u7528\u4ece\u5e93\u4e2a\u6570 " + count);
        }
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validationConnection(Connection conn) {
        String sql = "select csz from xtcs where csmc = 'xxx'";
        Statement stmt = null;
        try {
            try {
                stmt = conn.createStatement();
                stmt.execute("select csz from xtcs where csmc = 'xxx'");
                Object var5_4 = null;
                if (stmt == null) return true;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (stmt == null) throw throwable;
                stmt.close();
                throw throwable;
            }
            stmt.close();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private boolean ensureDataSourceInited() {
        if (SpringContextHolder.INSTANCE.getApplicationContext() != null) {
            return SpringContextHolder.INSTANCE.getApplicationContext().getBean("ConnectionProviderImpl") != null;
        }
        return false;
    }

    public DataSource lookupByDomainName(String domainName) {
        return this.datasourceMap.get(domainName);
    }

    public boolean containsDomainName(String domainName) {
        return this.datasourceMap.containsKey(domainName);
    }

    public DataSource getDefaultDataSource() {
        DataSource dataSource = this.datasourceMap.get("default");
        if (dataSource == null && this.ensureDataSourceInited()) {
            dataSource = this.datasourceMap.get("default");
        }
        return dataSource;
    }

    public void addDataSource(String domainName, DataSource dataSource) {
        if (!this.datasourceMap.containsKey(domainName)) {
            this.datasourceMap.put(domainName, dataSource);
        }
    }

    public DataSource lookupByEntityName(String entityName) {
        if (StringUtil.isEmptyString(entityName)) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u6ca1\u6709\u67e5\u627e\u67e5\u627e\u5230[" + entityName + "]\u5bf9\u5e94\u7684\u6570\u636e\u6e90,\u8fd4\u56de\u9ed8\u8ba4\u6570\u636e\u6e90.");
            }
            return this.getDefaultDataSource();
        }
        for (Map.Entry<String, DataSource> entry : this.datasourceMap.entrySet()) {
            String key = entry.getKey();
            if (!entityName.startsWith(key)) continue;
            return entry.getValue();
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("\u6ca1\u6709\u67e5\u627e\u67e5\u627e\u5230[" + entityName + "]\u5bf9\u5e94\u7684\u6570\u636e\u6e90,\u8fd4\u56de\u9ed8\u8ba4\u6570\u636e\u6e90.");
        }
        return this.getDefaultDataSource();
    }

    public String randomSlaveJndiName(String masterJndi) {
        if (!this.masterMap.isEmpty() && this.masterMap.containsKey(masterJndi)) {
            Set<String> set = this.masterMap.get(masterJndi);
            String jndiName = null;
            Iterator<String> it = set.iterator();
            for (int index = RANDOM.nextInt(set.size()); it.hasNext() && index >= 0; --index) {
                jndiName = it.next().toString();
            }
            return jndiName;
        }
        return "fmismain";
    }

    public String randomMasterJndiName() {
        if (!this.jndiMap.isEmpty()) {
            String jndiName = null;
            Iterator<String> it = this.jndiMap.keySet().iterator();
            for (int index = RANDOM.nextInt(this.jndiMap.size()); it.hasNext() && index >= 0; --index) {
                jndiName = it.next().toString();
            }
            return jndiName;
        }
        return "fmismain";
    }

    public DataSource getJndiDataSource(String jndiName) {
        if (StringUtil.isNotEmptyString(jndiName)) {
            Object object;
            if (LOG.isInfoEnabled()) {
                LOG.info("\u5f00\u59cb\u67e5\u627eJNDI\u6570\u636e\u6e90,JNDI\u6570\u636e\u6e90\u540d\u79f0[" + jndiName + "]");
            }
            if ((object = JNDIUtil.getJndiObject(jndiName)) == null) {
                String masterName = "jdbc/" + jndiName;
                if (System.getProperty("catalina.base") != null) {
                    masterName = "java:/comp/env/jdbc/" + jndiName;
                }
                object = JNDIUtil.getJndiObject(masterName);
            }
            if (object instanceof DataSource) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("\u67e5\u627e\u5230JNDI\u6570\u636e\u6e90,JNDI\u6570\u636e\u6e90\u540d\u79f0[" + jndiName + "]");
                }
                this.initJndiDataSource(jndiName);
                return (DataSource)object;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("\u6ca1\u6709\u67e5\u627e\u5230JNDI\u6570\u636e\u6e90,JNDI\u6570\u636e\u6e90\u540d\u79f0[" + jndiName + "]");
            }
        }
        return null;
    }

    public DataSource getSlaveDataSource(String slaveJndiName) {
        if (this.slaveMap.containsKey(slaveJndiName)) {
            if (FAILURE_SET.contains(slaveJndiName)) {
                return null;
            }
            return this.slaveMap.get(slaveJndiName);
        }
        return null;
    }

    public List<DataSource> getJndiDataSources(String jndiName) {
        if (this.jndiMap.containsKey(jndiName)) {
            return this.jndiMap.get(jndiName);
        }
        return Collections.emptyList();
    }

    public DataSource randomDataSource(String jndiName) {
        List<DataSource> datasources = this.getJndiDataSources(jndiName);
        if (datasources.isEmpty()) {
            if (LOG.isInfoEnabled()) {
                LOG.info("\u5f53\u524d\u4f7f\u7528\u4e3b\u5e93\uff0c\u6570\u636e\u6e90\u540d\u79f0[" + jndiName + "]");
            }
            return null;
        }
        if (datasources.size() == 1) {
            String slaveName = jndiName + "1";
            if (FAILURE_SET.contains(slaveName)) {
                return null;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("\u5f53\u524d\u4f7f\u7528\u4ece\u5e93\uff0c\u6570\u636e\u6e90\u540d\u79f0[" + slaveName + "]");
            }
            return datasources.get(0);
        }
        for (int index = 0; index < datasources.size(); ++index) {
            int i = index + 1;
            String slaveName = jndiName + i;
            if (FAILURE_SET.contains(slaveName)) continue;
            if (LOG.isInfoEnabled()) {
                LOG.info("\u5f53\u524d\u4f7f\u7528\u4ece\u5e93\uff0c\u6570\u636e\u6e90\u540d\u79f0[" + slaveName + "]");
            }
            return datasources.get(i);
        }
        return null;
    }

    public void initJndiDataSource(String jndiName) {
        block5: {
            int i;
            block4: {
                block6: {
                    String jndi;
                    i = 1;
                    while (true) {
                        DataSource ds;
                        jndi = jndiName + i;
                        if (LOG.isInfoEnabled()) {
                            LOG.info("\u5f00\u59cb\u67e5\u627e\u4ece\u5e93JNDI\u6570\u636e\u6e90,\u4ece\u5e93JNDI\u6570\u636e\u6e90\u540d\u79f0[" + jndi + "]");
                        }
                        if ((ds = (DataSource)JNDIUtil.getJndiObject(jndi)) == null) {
                            String slaveName = "jdbc/" + jndi;
                            if (!AppServerType.Inforsuite.equals((Object)RuntimeEnvUtil.INSTANCE.getServerType()) && System.getProperty("catalina.base") != null) {
                                slaveName = "java:/comp/env/jdbc/" + jndi;
                            }
                            ds = (DataSource)JNDIUtil.getJndiObject(slaveName);
                        }
                        if (ds == null) break;
                        ++i;
                        this.addDataSource(jndiName, jndi, ds);
                    }
                    if (i != 1) break block4;
                    if (RuntimeEnvUtil.INSTANCE.isDeployment()) break block5;
                    DataSource mainDS = (DataSource)JNDIUtil.getJndiObject(jndiName);
                    if (mainDS == null) break block6;
                    this.addDataSource(jndiName, jndi, mainDS);
                    if (!LOG.isInfoEnabled()) break block5;
                    LOG.info("\u589e\u52a0\u865a\u62df\u4ece\u5e93\u6210\u529f,\u5f00\u542f\u4e3b\u4ece\u5e93\u6a21\u5f0f,\u4ece\u5e93\u67091\u4e2a");
                    break block5;
                }
                if (!LOG.isInfoEnabled()) break block5;
                LOG.info("\u65e0\u6cd5\u83b7\u53d6\u4e3b\u6570\u636e\u6e90,\u589e\u52a0\u865a\u62df\u4ece\u5e93\u5931\u8d25");
                break block5;
            }
            int slaveSize = i - 1;
            if (!LOG.isInfoEnabled()) break block5;
            LOG.info("\u6570\u636e\u6e90[" + jndiName + "]\u4f7f\u7528\u4e3b\u4ece\u5e93\u914d\u7f6e,\u5f00\u542f\u4e3b\u4ece\u5e93\u6a21\u5f0f,\u4ece\u5e93\u6709[" + slaveSize + "]\u4e2a.");
        }
    }

    private void addDataSource(String jndiName, String slaveJndiName, DataSource ds) {
        if (!this.jndiMap.containsKey(jndiName)) {
            this.jndiMap.put(jndiName, new ArrayList());
        }
        if (this.masterMap.containsKey(jndiName)) {
            this.masterMap.get(jndiName).add(slaveJndiName);
        } else {
            HashSet<String> set = new HashSet<String>();
            set.add(slaveJndiName);
            this.masterMap.put(jndiName, set);
        }
        this.jndiMap.get(jndiName).add(ds);
        this.slaveMap.put(slaveJndiName, ds);
    }

    public void clear() {
        this.datasourceMap.clear();
        this.jndiMap.clear();
        this.slaveMap.clear();
        this.masterMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void printSessionId(Connection conn) {
        if (!"true".equals(System.getProperty("TRACE_SESSIONID"))) {
            return;
        }
        PreparedStatement prepareStatement = null;
        ResultSet resultSet = null;
        try {
            block6: {
                try {
                    String sessionId;
                    String sql = "SELECT SYS_CONTEXT('USERENV','SESSIONID') AS SESSION_ID FROM DUAL";
                    prepareStatement = conn.prepareStatement("SELECT SYS_CONTEXT('USERENV','SESSIONID') AS SESSION_ID FROM DUAL");
                    resultSet = prepareStatement.executeQuery();
                    if (!resultSet.next() || (sessionId = resultSet.getString("SESSION_ID")) == null) break block6;
                    if (!SESSION_SET.contains(sessionId) && DatasourceManager.auditSessionId(conn)) {
                        SESSION_SET.add(sessionId);
                    }
                    if (!LOG.isInfoEnabled()) break block6;
                    LOG.info("\u5f53\u524d\u8fde\u63a5\u7684sessionid\u4e3a" + sessionId);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    Object var6_7 = null;
                    DatasourceManager.close(prepareStatement, resultSet);
                    return;
                }
            }
            Object var6_6 = null;
            DatasourceManager.close(prepareStatement, resultSet);
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            DatasourceManager.close(prepareStatement, resultSet);
            throw throwable;
        }
    }

    private static void close(PreparedStatement prepareStatement, ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        if (prepareStatement != null) {
            try {
                prepareStatement.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean auditSessionId(Connection conn) {
        boolean isInvoked = true;
        CallableStatement stm = null;
        stm = conn.prepareCall("{CALL PR_SET_SEVICE_MAP(?)}");
        stm.setString(1, RuntimeEnvUtil.INSTANCE.getServerName());
        stm.execute();
        Object var5_3 = null;
        if (stm == null) return isInvoked;
        try {
            stm.close();
            return isInvoked;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
        return isInvoked;
        {
            catch (Throwable e) {
                isInvoked = false;
                e.printStackTrace();
                Object var5_4 = null;
                if (stm == null) return isInvoked;
                try {
                    stm.close();
                    return isInvoked;
                }
                catch (Throwable e2) {
                    e2.printStackTrace();
                }
                return isInvoked;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (stm == null) throw throwable;
            try {
                stm.close();
                throw throwable;
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
            throw throwable;
        }
    }
}

