/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSet
extends java.util.AbstractSet {
    protected AbstractSet() {
    }

    @Override
    public Object[] toArray() {
        return AbstractSet.collectionToArray(this);
    }

    @Override
    public Object[] toArray(Object[] a) {
        return AbstractSet.collectionToArray(this, a);
    }

    public static Object[] collectionToArray(Collection c) {
        int len = c.size();
        Object[] arr = new Object[len];
        Iterator itr = c.iterator();
        int idx = 0;
        while (true) {
            if (idx < len && itr.hasNext()) {
                arr[idx++] = itr.next();
            }
            if (!itr.hasNext()) {
                if (idx == len) {
                    return arr;
                }
                return AbstractSet.copyOf(arr, idx, Object[].class);
            }
            int newcap = (arr.length / 2 + 1) * 3;
            if (newcap < arr.length) {
                if (arr.length < Integer.MAX_VALUE) {
                    newcap = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError("required array size too large");
                }
            }
            arr = AbstractSet.copyOf(arr, newcap, Object[].class);
            len = newcap;
        }
    }

    public static Object[] collectionToArray(Collection c, Object[] a) {
        Class<?> aType = a.getClass();
        int len = c.size();
        Object[] arr = a.length >= len ? a : (Object[])Array.newInstance(aType.getComponentType(), len);
        Iterator itr = c.iterator();
        int idx = 0;
        while (true) {
            if (idx < len && itr.hasNext()) {
                arr[idx++] = itr.next();
            }
            if (!itr.hasNext()) {
                if (idx == len) {
                    return arr;
                }
                if (arr == a) {
                    a[idx] = null;
                    return a;
                }
                return AbstractSet.copyOf(arr, idx, aType);
            }
            int newcap = (arr.length / 2 + 1) * 3;
            if (newcap < arr.length) {
                if (arr.length < Integer.MAX_VALUE) {
                    newcap = Integer.MAX_VALUE;
                } else {
                    throw new OutOfMemoryError("required array size too large");
                }
            }
            arr = AbstractSet.copyOf(arr, newcap, aType);
            len = newcap;
        }
    }

    public static <T, U> T[] copyOf(U[] original, int newLength, Class<? extends T[]> newType) {
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }
}

