/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor;

import com.ygsoft.ecp.service.executor.ApplicationContextHolder;
import com.ygsoft.ecp.service.executor.DefaultMessageSource;
import com.ygsoft.ecp.service.executor.ErrorCodedException;
import com.ygsoft.ecp.service.executor.ExceptionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class ApplicationException
extends Exception
implements ErrorCodedException {
    private static final long serialVersionUID = -3908458068593711353L;
    public static final String ERROR_CODE = "APP_ERROR_APPLICATION";
    private String errorCode = "APP_ERROR_APPLICATION";

    public ApplicationException() {
        super("Application error happened!");
        this.raiseExceptionEvent();
    }

    public ApplicationException(String newerrorCode) {
        super("Applicaton error happened! Error code is: " + newerrorCode);
        this.errorCode = newerrorCode;
        this.raiseExceptionEvent();
    }

    public ApplicationException(String newerrorCode, String message) {
        super(message);
        this.errorCode = newerrorCode;
        this.raiseExceptionEvent();
    }

    public ApplicationException(String newerrorCode, Throwable cause) {
        super("Application error happend! ErrorCode is: " + newerrorCode, cause);
        this.errorCode = newerrorCode;
        this.raiseExceptionEvent();
    }

    public ApplicationException(Throwable cause) {
        super("Application error happend!", cause);
        this.raiseExceptionEvent();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getStackTraceString() {
        StringWriter sw = new StringWriter(2048);
        PrintWriter pw = new PrintWriter(sw);
        this.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    public String toString() {
        return this.getMessage();
    }

    public Object[] getArguments() {
        return null;
    }

    public String getMessage() {
        return DefaultMessageSource.INSTANCE.getMessage(this.errorCode, this.getArguments(), super.getMessage());
    }

    public ErrorCodedException getRootErrorCodedException() {
        ErrorCodedException root = this;
        while (root.getCause() != null && root.getCause() instanceof ErrorCodedException) {
            root = (ErrorCodedException)((Object)root.getCause());
        }
        return root;
    }

    public Throwable getRootCause() {
        Throwable root = this;
        while (!root.getClass().getName().startsWith("java.") && !root.getClass().getName().startsWith("javax.") && root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    private void raiseExceptionEvent() {
        Throwable cause = this.getCause();
        if (cause != null && cause instanceof ErrorCodedException) {
            return;
        }
        ApplicationContext applicationContext = ApplicationContextHolder.getApplicationContext();
        ExceptionEvent event = new ExceptionEvent(this, "APP", new Object());
        applicationContext.publishEvent((ApplicationEvent)event);
    }
}

