/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor;

import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;

public class DefaultMessageSource
implements MessageSourceAware {
    private static MessageSource messageSource;
    public static final DefaultMessageSource INSTANCE;

    private DefaultMessageSource() {
    }

    public void setMessageSource(MessageSource newmessageSource) {
        messageSource = newmessageSource;
    }

    public String getMessage(String code) {
        return this.getMessage(code, null, code);
    }

    public String getMessage(String code, Object[] args) {
        return this.getMessage(code, args, code);
    }

    public String getMessage(String code, String defaultMessage) {
        return this.getMessage(code, null, defaultMessage);
    }

    public String getMessage(String code, Object[] args, String defaultMessage) {
        Locale locale = EcpI18nUtil.getLoginLocale();
        return this.getMessage(code, null, locale, defaultMessage);
    }

    public String getMessage(String code, Object[] args, Locale locale, String defaultMessage) {
        if (messageSource == null) {
            return defaultMessage;
        }
        return messageSource.getMessage(code, args, defaultMessage, locale);
    }

    static {
        INSTANCE = new DefaultMessageSource();
    }
}

