/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor;

import com.ygsoft.ecp.service.executor.ApplicationContextHolder;
import com.ygsoft.ecp.service.executor.DefaultMessageSource;
import com.ygsoft.ecp.service.executor.ErrorCodedException;
import com.ygsoft.ecp.service.executor.ExceptionEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

public class SystemException
extends RuntimeException
implements ErrorCodedException {
    private static final long serialVersionUID = -1335537235693671811L;
    public static final String ERROR_CODE = "SYS_ERROR_SYSTEM";
    private String errorCode = "SYS_ERROR_SYSTEM";

    public SystemException() {
        super("System error happened!");
        this.raiseExceptionEvent();
    }

    public SystemException(String newerrorCode) {
        super("System error happened! Error code is: " + newerrorCode);
        this.errorCode = newerrorCode;
        this.raiseExceptionEvent();
    }

    public SystemException(String newerrorCode, String message) {
        super(message);
        this.errorCode = newerrorCode;
        this.raiseExceptionEvent();
    }

    public SystemException(Throwable cause) {
        super("System error happened!", cause);
        this.raiseExceptionEvent();
    }

    public SystemException(String newerrorCode, Throwable cause) {
        super("System error happened! Error code is: " + newerrorCode, cause);
        this.errorCode = newerrorCode;
        this.raiseExceptionEvent();
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getStackTraceString() {
        StringWriter sw = new StringWriter(2048);
        PrintWriter pw = new PrintWriter(sw);
        this.printStackTrace(pw);
        String result = sw.toString();
        try {
            sw.close();
            pw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public ErrorCodedException getRootErrorCodedException() {
        ErrorCodedException root = this;
        while (root.getCause() != null && root.getCause() instanceof ErrorCodedException) {
            root = (ErrorCodedException)((Object)root.getCause());
        }
        return root;
    }

    public Throwable getRootCause() {
        Throwable root = this;
        while (!root.getClass().getName().startsWith("java.") && !root.getClass().getName().startsWith("javax.") && root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    public String toString() {
        return this.getMessage();
    }

    public Object[] getArguments() {
        return new Object[]{this.errorCode};
    }

    public String getMessage() {
        return DefaultMessageSource.INSTANCE.getMessage(this.errorCode, this.getArguments(), super.getMessage());
    }

    private void raiseExceptionEvent() {
        Throwable cause = this.getCause();
        if (cause != null && cause instanceof ErrorCodedException) {
            return;
        }
        ApplicationContext applicationContext = ApplicationContextHolder.getApplicationContext();
        if (applicationContext != null) {
            ExceptionEvent event = new ExceptionEvent(this, "SYS", new Object());
            applicationContext.publishEvent((ApplicationEvent)event);
        }
    }
}

