/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.ecp.service.executor.cache;

import com.ygsoft.ecp.service.EcpService;
import com.ygsoft.ecp.service.cache.ICache;
import com.ygsoft.ecp.service.executor.ServiceMessage;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StringUtil;

public class MethodCacheInvoker {
    private static final IEcpLog LOG = EcpLogFactory.getLog(MethodCacheInvoker.class);

    public boolean before(ServiceMessage message) {
        String serviceCode = message.getServiceCode();
        String serviceName = message.getServiceName();
        if (StringUtil.isNotEmptyString(serviceCode) && StringUtil.isNotEmptyString(serviceName)) {
            String key;
            ICache cache;
            if (LOG.isInfoEnabled()) {
                LOG.info("\u65b9\u6cd5\u7f13\u5b58\u62e6\u622a\u5f00\u59cb,\u524d\u7f6e\u62e6\u622a\u670d\u52a1\u540d\u79f0\u3010" + message.getServiceCode() + "\u3011,\u65b9\u6cd5\u540d\u79f0\u3010" + message.getServiceName() + "\u3011");
            }
            if ((cache = EcpService.getCacheService(serviceCode, serviceName)).containsKey(key = this.genCacheKeyString(message.getParameters()))) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("\u7f13\u5b58\u91cc\u6709\u503c,\u65b9\u6cd5\u7f13\u5b58\u62e6\u622a\u6210\u529f,\u76f4\u63a5\u8fd4\u56de\u7f13\u5b58\u6570\u636e.\u524d\u7f6e\u62e6\u622a\u670d\u52a1\u540d\u79f0\u3010" + message.getServiceCode() + "\u3011,\u65b9\u6cd5\u540d\u79f0\u3010" + message.getServiceName() + "\u3011");
                }
                message.setContent(cache.get(key));
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean after(ServiceMessage message) {
        String serviceCode = message.getServiceCode();
        String serviceName = message.getServiceName();
        if (StringUtil.isNotEmptyString(serviceCode) && StringUtil.isNotEmptyString(serviceName)) {
            String key;
            ICache<String, Object> cache;
            if (LOG.isInfoEnabled()) {
                LOG.info("\u65b9\u6cd5\u7f13\u5b58\u62e6\u622a\u7ed3\u675f,\u540e\u7f6e\u62e6\u622a\u670d\u52a1\u540d\u79f0\u3010" + message.getServiceCode() + "\u3011,\u65b9\u6cd5\u540d\u79f0\u3010" + message.getServiceName() + "\u3011");
            }
            if (!(cache = EcpService.getCacheService(serviceCode, serviceName)).containsKey(key = this.genCacheKeyString(message.getParameters()))) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("\u7f13\u5b58\u91cc\u6ca1\u6709\u503c,\u5c06\u7ed3\u679c\u6570\u636e\u5199\u5165\u7f13\u5b58.\u540e\u7f6e\u62e6\u622a\u670d\u52a1\u540d\u79f0\u3010" + message.getServiceCode() + "\u3011,\u65b9\u6cd5\u540d\u79f0\u3010" + message.getServiceName() + "\u3011");
                }
                if (message.getContent() != null) {
                    cache.put(key, message.getContent());
                }
                return true;
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("\u7f13\u5b58\u91cc\u6709\u503c,\u65b9\u6cd5\u7f13\u5b58\u62e6\u622a\u6210\u529f,\u76f4\u63a5\u8fd4\u56de\u7f13\u5b58\u6570\u636e.\u540e\u7f6e\u62e6\u622a\u670d\u52a1\u540d\u79f0\u3010" + message.getServiceCode() + "\u3011,\u65b9\u6cd5\u540d\u79f0\u3010" + message.getServiceName() + "\u3011");
            }
            message.setContent(cache.get(key));
            return false;
        }
        return true;
    }

    private String genCacheKeyString(Object[] params) {
        if (params != null) {
            StringBuilder sb = new StringBuilder("");
            for (Object o : params) {
                sb.append(o == null ? "" : o).append("#");
            }
            return sb.toString();
        }
        return "NULL";
    }
}

